<?php

namespace Shared\RightManagement\Traits;

use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\User;

trait HasOwnerEntity
{
    /**
     * @var ?User the owner of the entity
     * @ORM\ManyToOne(targetEntity="Shared\Authentication\Entity\User")
     */
    private ?User $owner;

    /**
     * @return User|null
     */
    public function getOwner(): ?User
    {
        return $this->owner;
    }

    /**
     * @param User|null $owner
     */
    public function setOwner(?User $owner)
    {
        $this->owner = $owner;
        return $this;
    }

}
