<?php


namespace Webapp\Core\Entity;

use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * Class Algorithm
 * @package Webapp\Core\Entity
 *
 * @ORM\Entity
 * @ORM\Table(name="algorithm_parameter", schema="webapp")
 */
class AlgorithmParameter extends IdentifiedEntity
{
    public const SPECIAL_PARAM_NBR_TREATMENT = "treatmentNumber";
    public const SPECIAL_PARAM_CONSTANT_REPETITION = "repetitionNumber";
    public const SPECIAL_PARAM_NBR_FACTOR = "factorNumber";

    /**
     * @var string
     *
     * @ORM\Column(type="string")
     * @Groups({"platform_full_view", "protocol_full_view"})
     */
    private string $name;

    /**
     * @var int
     *
     * @ORM\Column(name="algorithm_order", type="integer")
     * @Groups({"platform_full_view", "protocol_full_view"})
     */
    private int $order;

    /**
     * @var string | null
     *
     * @ORM\Column(type="string", nullable=true)
     * @Groups({"platform_full_view", "protocol_full_view"})
     */
    private ?string $specialParam;

    /**
     * @var Algorithm
     *
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\Algorithm", inversedBy="algorithmParameters")
     */
    private Algorithm $algorithm;

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return AlgorithmParameter
     */
    public function setName(string $name): AlgorithmParameter
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return int
     */
    public function getOrder(): int
    {
        return $this->order;
    }

    /**
     * @param int $order
     * @return AlgorithmParameter
     */
    public function setOrder(int $order): AlgorithmParameter
    {
        $this->order = $order;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSpecialParam(): ?string
    {
        return $this->specialParam;
    }

    /**
     * @param string|null $specialParam
     * @return AlgorithmParameter
     */
    public function setSpecialParam(?string $specialParam): AlgorithmParameter
    {
        $this->specialParam = $specialParam;
        return $this;
    }

    /**
     * @return Algorithm
     */
    public function getAlgorithm(): Algorithm
    {
        return $this->algorithm;
    }

    /**
     * @param Algorithm $algorithm
     * @return AlgorithmParameter
     */
    public function setAlgorithm(Algorithm $algorithm): AlgorithmParameter
    {
        $this->algorithm = $algorithm;
        return $this;
    }

}
