<?php

namespace Webapp\Core\Entity\CloneVariable;

use ApiPlatform\Core\Action\NotFoundAction;
use ApiPlatform\Core\Annotation\ApiProperty;
use ApiPlatform\Core\Annotation\ApiResource;
use Webapp\Core\ApiOperation\CloneVariableToProjectOperation;
use Webapp\Core\Entity\Project;

/**
 * Class CloneVariable.
 *
 * @ApiResource(
 *     collectionOperations={
 *          "post"={
 *              "controller"=CloneVariableToProjectOperation::class,
 *              "read"=false,
 *              "security"="is_granted('ROLE_PLATFORM_MANAGER')",
 *              "openapi_context"={
 *                  "summary": "Clone a variable in a project",
 *                  "description": "Create a copy of the given variable inside a data entry project"
 *              },
 *          },
 *     },
 *     itemOperations={
 *     "get"={
 *             "controller"=NotFoundAction::class,
 *             "read"=false,
 *             "output"=false,
 *          }}
 * )
 *
 */
class CloneVariable
{
    /**
     * @ApiProperty(identifier=true)
     */
    private $id;

    /**
     * @var Project
     */
    private Project $project;

    /**
     * @var string
     */
    private string $variable;

    /**
     * @var string
     */
    private string $result;

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     * @return CloneVariable
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return Project
     */
    public function getProject(): Project
    {
        return $this->project;
    }

    /**
     * @param Project $project
     * @return CloneVariable
     */
    public function setProject(Project $project): CloneVariable
    {
        $this->project = $project;
        return $this;
    }

    /**
     * @return string
     */
    public function getVariable(): string
    {
        return $this->variable;
    }

    /**
     * @param string $variable
     * @return CloneVariable
     */
    public function setVariable(string $variable): CloneVariable
    {
        $this->variable = $variable;
        return $this;
    }

    /**
     * @return string
     */
    public function getResult(): string
    {
        return $this->result;
    }

    /**
     * @param string $result
     * @return CloneVariable
     */
    public function setResult(string $result): CloneVariable
    {
        $this->result = $result;
        return $this;
    }
}
