<?php


namespace Webapp\Core\Entity\Move;

use ApiPlatform\Core\Action\NotFoundAction;
use ApiPlatform\Core\Annotation\ApiProperty;
use ApiPlatform\Core\Annotation\ApiResource;
use Webapp\Core\ApiOperation\PlaceExperimentOperation;
use Webapp\Core\Entity\Experiment;
use Webapp\Core\Entity\Platform;

/**
 * @ApiResource(
 *     collectionOperations={
 *          "move"={
 *              "controller"=PlaceExperimentOperation::class,
 *              "method"="PATCH",
 *              "read"=false,
 *              "security"="is_granted('ROLE_PLATFORM_MANAGER')",
 *              "openapi_context"={
 *                  "summary": "Place an experiment inside an other platform",
 *                  "description": "Move all items inside the experiment and link it to given platform"
 *              }
 *          }
 *     },
 *     itemOperations={
 *          "get"={
 *             "controller"=NotFoundAction::class,
 *             "read"=false,
 *             "output"=false,
 *          }
 *     }
 * )
 */
class PlaceExperiment
{
    /**
     * @ApiProperty(identifier=true)
     */
    private $id;

    /**
     * @var Experiment
     */
    private Experiment $experiment;
    /**
     * @var int
     */
    private int $dx;
    /**
     * @var int
     */
    private int $dy;

    /**
     * @var Platform|null
     */
    private ?Platform $platform;

    public function __construct(Experiment $experiment)
    {
        $this->dx = 0;
        $this->dy = 0;
        $this->experiment = $experiment;
        $this->platform = null;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     * @return PlaceExperiment
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return Experiment
     */
    public function getExperiment(): Experiment
    {
        return $this->experiment;
    }

    /**
     * @param Experiment $experiment
     * @return PlaceExperiment
     */
    public function setExperiment(Experiment $experiment): PlaceExperiment
    {
        $this->experiment = $experiment;
        return $this;
    }

    /**
     * @return int
     */
    public function getDx(): int
    {
        return $this->dx;
    }

    /**
     * @param int $dx
     * @return PlaceExperiment
     */
    public function setDx(int $dx): PlaceExperiment
    {
        $this->dx = $dx;
        return $this;
    }

    /**
     * @return int
     */
    public function getDy(): int
    {
        return $this->dy;
    }

    /**
     * @param int $dy
     * @return PlaceExperiment
     */
    public function setDy(int $dy): PlaceExperiment
    {
        $this->dy = $dy;
        return $this;
    }

    /**
     * @return Platform|null
     */
    public function getPlatform(): ?Platform
    {
        return $this->platform;
    }

    /**
     * @param Platform|null $platform
     * @return PlaceExperiment
     */
    public function setPlatform(?Platform $platform): PlaceExperiment
    {
        $this->platform = $platform;
        return $this;
    }
}
