<?php

namespace Webapp\Core\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\Groups;

trait OpenSilexEntity
{

    /**
     * @var string|null
     *
     * @ORM\Column(type="string", nullable=true)
     * @Groups({"factor_post", "protocol_full_view", "simple_variable_post"})
     */
    private ?string $openSilexUri;

    /**
     * @var OpenSilexInstance|null
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\OpenSilexInstance")
     * @Groups({"factor_post", "protocol_full_view", "simple_variable_post"})
     */
    private ?OpenSilexInstance $openSilexInstance;

    /**
     * @return string|null
     */
    public function getOpenSilexUri(): ?string
    {
        return $this->openSilexUri;
    }

    /**
     * @param string|null $openSilexUri
     * @return self
     */
    public function setOpenSilexUri(?string $openSilexUri): self
    {
        $this->openSilexUri = $openSilexUri;
        return $this;
    }

    /**
     * @return OpenSilexInstance|null
     */
    public function getOpenSilexInstance(): ?OpenSilexInstance
    {
        return $this->openSilexInstance;
    }

    /**
     * @param OpenSilexInstance|null $openSilexInstance
     * @return self
     */
    public function setOpenSilexInstance(?OpenSilexInstance $openSilexInstance): self
    {
        $this->openSilexInstance = $openSilexInstance;
        return $this;
    }

}
