<?php


namespace Webapp\Core\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;

/**
 * Class Modality
 * @package Webapp\Core\Entity
 *
 * @ApiResource(
 *     itemOperations={
 *          "get"={"security"="is_granted('ROLE_ADMIN')"},
 *          "patch"={"security"="is_granted('ROLE_ADMIN')"}
 *     }
 * )
 *
 * @ORM\Entity
 * @ORM\Table(name="parameters", schema="webapp")
 */
class Parameters extends IdentifiedEntity
{
    /**
     * @ORM\Id()
     * @ORM\Column(name="id", type="integer")
     */
    protected $id;

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     */
    private int $daysBeforeFileDelete;

    /**
     * @return int
     */
    public function getDaysBeforeFileDelete(): int
    {
        return $this->daysBeforeFileDelete;
    }

    /**
     * @param int $daysBeforeFileDelete
     * @return Parameters
     */
    public function setDaysBeforeFileDelete(int $daysBeforeFileDelete): Parameters
    {
        $this->daysBeforeFileDelete = $daysBeforeFileDelete;
        return $this;
    }

}
