<?php


namespace Webapp\Core\Entity;

use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;
use Shared\Enumeration\Annotation\EnumType;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * Class PathLevelAlgorithm
 * @package Webapp\Core\Entity
 *
 * @ORM\Entity
 * @ORM\Table(name="path_base_level_algorithm", schema="webapp")
 */
class PathLevelAlgorithm extends IdentifiedEntity
{
    /**
     * @var string
     *
     * @ORM\Column(type="string")
     * @Groups({"variable_synthesis"})
     * @EnumType(class="Webapp\Core\Enumeration\PathLevelEnum")
     */
    private string $pathLevel;

    /**
     * @var string
     *
     * @ORM\Column(type="string")
     * @Groups({"variable_synthesis"})
     * @EnumType(class="Webapp\Core\Enumeration\PossibleMoveEnum")
     */
    private string $move;

    /**
     * @var string|null
     *
     * @Groups({"variable_synthesis"})
     * @ORM\Column(type="string", nullable=true)
     */
    private ?string $startPoint; // TODO PossibleStartPointEnum

    /**
     * @var array
     * @ORM\Column(type="simple_array", nullable=true)
     */
    private array $orderedIris;

    /**
     * @var PathBase|null
     *
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\PathBase", inversedBy="pathLevelAlgorithms")
     * @ORM\JoinColumn(nullable=false)
     */
    private ?PathBase $pathBase;

    public function __construct($move, $pathLevel)
    {
        $this->move = $move; // TODO delete when https://github.com/api-platform/core/issues/3974 is solved
        $this->pathLevel = $pathLevel; // TODO delete when https://github.com/api-platform/core/issues/3974 is solved
        $this->startPoint = null;
        $this->orderedIris = [];
    }

    /**
     * @return string
     */
    public function getPathLevel(): string
    {
        return $this->pathLevel;
    }

    /**
     * @param string $pathLevel
     * @return PathLevelAlgorithm
     */
    public function setPathLevel(string $pathLevel): PathLevelAlgorithm
    {
        $this->pathLevel = $pathLevel;
        return $this;
    }

    /**
     * @return string
     */
    public function getMove(): string
    {
        return $this->move;
    }

    /**
     * @param string $move
     * @return PathLevelAlgorithm
     */
    public function setMove(string $move): PathLevelAlgorithm
    {
        $this->move = $move;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getStartPoint(): ?string
    {
        return $this->startPoint;
    }

    /**
     * @param string|null $startPoint
     * @return PathLevelAlgorithm
     */
    public function setStartPoint(?string $startPoint): PathLevelAlgorithm
    {
        $this->startPoint = $startPoint;
        return $this;
    }

    /**
     * @return array
     */
    public function getOrderedIris(): array
    {
        return $this->orderedIris;
    }

    /**
     * @param array $orderedIris
     * @return PathLevelAlgorithm
     */
    public function setOrderedIris(array $orderedIris): PathLevelAlgorithm
    {
        $this->orderedIris = $orderedIris;
        return $this;
    }

    /**
     * @return PathBase|null
     */
    public function getPathBase(): ?PathBase
    {
        return $this->pathBase;
    }

    /**
     * @param PathBase|null $pathBase
     * @return PathLevelAlgorithm
     */
    public function setPathBase(?PathBase $pathBase): PathLevelAlgorithm
    {
        $this->pathBase = $pathBase;
        return $this;
    }

}
