<?php


namespace Webapp\Core\Entity;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use Doctrine\ORM\Mapping as ORM;
use PHPUnit\Runner\Exception;
use Shared\Authentication\Entity\IdentifiedEntity;
use Shared\Enumeration\Annotation\EnumType;
use Symfony\Component\Serializer\Annotation\Groups;
use Webapp\Core\Dto\Test\TestInputDto;
use Webapp\Core\Validator\UniqueAttributeInParent;

/**
 * Class Test
 * @package Webapp\Core\Entity
 *
 * @ApiResource(
 *     collectionOperations={
 *         "get"={},
 *         "post"={
 *              "security_post_denormalize"="is_granted('ROLE_PLATFORM_MANAGER') && object.getVariable().getProject() !== null",
 *              "input"=TestInputDto::class,
 *          },
 *     },
 *     itemOperations={
 *          "get"={},
 *          "patch"={
 *              "security"="is_granted('ROLE_PLATFORM_MANAGER', object.getVariable().getSite())"
 *          },
 *          "delete"={
 *              "security"="is_granted('ROLE_PLATFORM_MANAGER', object.getVariable().getSite())"
 *          }
 *     }
 * )
 *
 * @ApiFilter(SearchFilter::class, properties={"variable": "exact"})
 *
 *
 *
 * @ORM\Entity
 * @ORM\Table(name="test", schema="webapp")
 */
class Test extends IdentifiedEntity
{
    /**
     * @var string
     * @EnumType(class="Webapp\Core\Enumeration\TestTypeEnum")
     * @UniqueAttributeInParent(parentsAttributes={"variable.tests"})
     * @ORM\Column(type="string")
     * @Groups({"project_explorer_view", "project_synthesis", "variable_synthesis"})
     */
    private string $type;

    /**
     * @var SimpleVariable|null
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\SimpleVariable", inversedBy="tests")
     */
    private ?SimpleVariable $variableSimple;

    /**
     * @var SemiAutomaticVariable|null
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\SemiAutomaticVariable", inversedBy="tests")
     */
    private ?SemiAutomaticVariable $variableSemiAutomatic;

    /**
     * @var GeneratorVariable|null
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\GeneratorVariable", inversedBy="tests")
     */
    private ?GeneratorVariable $variableGenerator;

    /*-----------------------------------------*/

    /**
     * @var float|null
     * @ORM\Column(type="float", nullable=true)
     * @Groups({"project_synthesis"})
     */
    private ?float $authIntervalMin;

    /**
     * @var float|null
     * @ORM\Column(type="float", nullable=true)
     * @Groups({"project_synthesis"})
     */
    private ?float $probIntervalMin;

    /**
     * @var float|null
     * @ORM\Column(type="float", nullable=true)
     * @Groups({"project_synthesis"})
     */
    private ?float $probIntervalMax;

    /**
     * @var float|null
     * @ORM\Column(type="float", nullable=true)
     * @Groups({"project_synthesis"})
     */
    private ?float $authIntervalMax;

    /*-----------------------------------------*/

    /**
     * @var SimpleVariable|null
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\SimpleVariable")
     */
    private ?SimpleVariable $comparedVariable_simple;

    /**
     * @var SemiAutomaticVariable|null
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\SemiAutomaticVariable")
     */
    private ?SemiAutomaticVariable $comparedVariable_semiAutomatic;

    /**
     * @var GeneratorVariable|null
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\GeneratorVariable")
     */
    private ?GeneratorVariable $comparedVariable_generator;

    /**
     * @var float|null
     * @ORM\Column(type="float", nullable=true)
     * @Groups({"project_synthesis"})
     */
    private ?float $minGrowth;

    /**
     * @var float|null
     * @ORM\Column(type="float", nullable=true)
     * @Groups({"project_synthesis"})
     */
    private ?float $maxGrowth;

    /*-----------------------------------------*/

    /**
     * @var SimpleVariable|null
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\SimpleVariable")
     */
    private ?SimpleVariable $combinedVariable1_simple;

    /**
     * @var SemiAutomaticVariable|null
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\SemiAutomaticVariable")
     */
    private ?SemiAutomaticVariable $combinedVariable1_semiAutomatic;

    /**
     * @var GeneratorVariable|null
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\GeneratorVariable")
     */
    private ?GeneratorVariable $combinedVariable1_generator;

    /**
     * @var string|null
     * @EnumType(class="Webapp\Core\Enumeration\CombinationOperationEnum", nullable=true)
     * @ORM\Column(type="string", nullable=true)
     * @Groups({"project_synthesis"})
     */
    private ?string $combinationOperation;

    /**
     * @var SimpleVariable|null
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\SimpleVariable")
     */
    private ?SimpleVariable $combinedVariable2_simple;

    /**
     * @var SemiAutomaticVariable|null
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\SemiAutomaticVariable")
     */
    private ?SemiAutomaticVariable $combinedVariable2_semiAutomatic;

    /**
     * @var GeneratorVariable|null
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\GeneratorVariable")
     */
    private ?GeneratorVariable $combinedVariable2_generator;

    /**
     * @var float|null
     * @ORM\Column(type="string", nullable=true)
     * @Groups({"project_synthesis"})
     */
    private ?float $minLimit;

    /**
     * @var float|null
     * @ORM\Column(type="string", nullable=true)
     * @Groups({"project_synthesis"})
     */
    private ?float $maxLimit;

    /*-----------------------------------------*/

    /**
     * @var bool|null
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({"project_synthesis"})
     */
    private ?bool $compareWithVariable;

    /**
     * @var SimpleVariable|null
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\SimpleVariable")
     */
    private ?SimpleVariable $comparedVariable1_simple;

    /**
     * @var SemiAutomaticVariable|null
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\SemiAutomaticVariable")
     */
    private ?SemiAutomaticVariable $comparedVariable1_semiAutomatic;

    /**
     * @var GeneratorVariable|null
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\GeneratorVariable")
     */
    private ?GeneratorVariable $comparedVariable1_generator;

    /**
     * @var string|null
     * @EnumType(class="Webapp\Core\Enumeration\ComparisonOperationEnum", nullable=true)
     * @ORM\Column(type="string", nullable=true)
     * @Groups({"project_synthesis"})
     */
    private ?string $comparisonOperation;

    /**
     * @var SimpleVariable|null
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\SimpleVariable")
     */
    private ?SimpleVariable $comparedVariable2_simple;

    /**
     * @var SemiAutomaticVariable|null
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\SemiAutomaticVariable")
     */
    private ?SemiAutomaticVariable $comparedVariable2_semiAutomatic;

    /**
     * @var GeneratorVariable|null
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\GeneratorVariable")
     */
    private ?GeneratorVariable $comparedVariable2_generator;

    /**
     * @var float|null
     * @ORM\Column(type="float", nullable=true)
     * @Groups({"project_synthesis"})
     */
    private ?float $comparedValue;

    /**
     * @var string|null
     * @ORM\Column(type="string", nullable=true)
     * @Groups({"project_synthesis"})
     */
    private ?string $assignedValue;

    public function __construct()
    {
        $this->authIntervalMin = null;
        $this->probIntervalMin = null;
        $this->probIntervalMax = null;
        $this->authIntervalMax = null;

        $this->comparedVariable_simple = null;
        $this->comparedVariable_semiAutomatic = null;
        $this->comparedVariable_generator = null;
        $this->minGrowth = null;
        $this->maxGrowth = null;

        $this->combinedVariable1_simple = null;
        $this->combinedVariable1_semiAutomatic = null;
        $this->combinedVariable1_generator = null;
        $this->combinationOperation = null;
        $this->combinedVariable2_simple = null;
        $this->combinedVariable2_semiAutomatic = null;
        $this->combinedVariable2_generator = null;
        $this->minLimit = null;
        $this->maxLimit = null;

        $this->compareWithVariable = null;
        $this->comparedVariable1_simple = null;
        $this->comparedVariable1_semiAutomatic = null;
        $this->comparedVariable1_generator = null;
        $this->comparisonOperation = null;
        $this->comparedVariable2_simple = null;
        $this->comparedVariable2_semiAutomatic = null;
        $this->comparedVariable2_generator = null;
        $this->comparedValue = null;
        $this->assignedValue = null;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @param string $type
     * @return Test
     */
    public function setType(string $type): Test
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return AbstractVariable
     */
    public function getVariable(): AbstractVariable
    {
        return $this->variableSimple ?? $this->variableGenerator ?? $this->variableSemiAutomatic;
    }

    /**
     * @param ?AbstractVariable $variable
     * @return Test
     */
    public function setVariable(?AbstractVariable $variable): Test
    {
        if ($variable instanceof SimpleVariable) {
            $this->variableSimple = $variable;
        } elseif ($variable instanceof GeneratorVariable) {
            $this->variableGenerator = $variable;
        } elseif ($variable instanceof SemiAutomaticVariable) {
            $this->variableSemiAutomatic = $variable;
        } elseif ($variable === null) {
            $this->variableSimple = $variable;
            $this->variableGenerator = $variable;
            $this->variableSemiAutomatic = $variable;
        }
        return $this;
    }

    /**
     * @return float|null
     */
    public function getAuthIntervalMin(): ?float
    {
        return $this->authIntervalMin;
    }

    /**
     * @param float|null $authIntervalMin
     * @return Test
     */
    public function setAuthIntervalMin(?float $authIntervalMin): Test
    {
        $this->authIntervalMin = $authIntervalMin;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getProbIntervalMin(): ?float
    {
        return $this->probIntervalMin;
    }

    /**
     * @param float|null $probIntervalMin
     * @return Test
     */
    public function setProbIntervalMin(?float $probIntervalMin): Test
    {
        $this->probIntervalMin = $probIntervalMin;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getProbIntervalMax(): ?float
    {
        return $this->probIntervalMax;
    }

    /**
     * @param float|null $probIntervalMax
     * @return Test
     */
    public function setProbIntervalMax(?float $probIntervalMax): Test
    {
        $this->probIntervalMax = $probIntervalMax;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getAuthIntervalMax(): ?float
    {
        return $this->authIntervalMax;
    }

    /**
     * @param float|null $authIntervalMax
     * @return Test
     */
    public function setAuthIntervalMax(?float $authIntervalMax): Test
    {
        $this->authIntervalMax = $authIntervalMax;
        return $this;
    }

    /**
     * @return mixed
     * @Groups({"project_synthesis"})
     */
    public function getComparedVariable()
    {
        if ($this->comparedVariable_simple !== null) {
            return $this->comparedVariable_simple;
        } elseif ($this->comparedVariable_generator !== null) {
            return $this->comparedVariable_generator;
        } else {
            return $this->comparedVariable_semiAutomatic;
        }
    }

    /**
     * @param mixed $comparedVariable
     * @return Test
     */
    public function setComparedVariable($comparedVariable)
    {
        $this->comparedVariable_simple = null;
        $this->comparedVariable_generator = null;
        $this->comparedVariable_semiAutomatic = null;
        if ($comparedVariable instanceof SimpleVariable) {
            $this->comparedVariable_simple = $comparedVariable;
        } elseif ($comparedVariable instanceof GeneratorVariable) {
            $this->comparedVariable_generator = $comparedVariable;
        } elseif ($comparedVariable instanceof SemiAutomaticVariable) {
            $this->comparedVariable_semiAutomatic = $comparedVariable;
        } elseif ($comparedVariable !== null) {
            throw new Exception();
        }
        return $this;
    }

    /**
     * @return float|null
     */
    public function getMinGrowth(): ?float
    {
        return $this->minGrowth;
    }

    /**
     * @param float|null $minGrowth
     * @return Test
     */
    public function setMinGrowth(?float $minGrowth): Test
    {
        $this->minGrowth = $minGrowth;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getMaxGrowth(): ?float
    {
        return $this->maxGrowth;
    }

    /**
     * @param float|null $maxGrowth
     * @return Test
     */
    public function setMaxGrowth(?float $maxGrowth): Test
    {
        $this->maxGrowth = $maxGrowth;
        return $this;
    }

    /**
     * @return mixed
     * @Groups({"project_synthesis"})
     */
    public function getCombinedVariable1()
    {
        if ($this->combinedVariable1_simple !== null) {
            return $this->combinedVariable1_simple;
        } elseif ($this->combinedVariable1_generator !== null) {
            return $this->combinedVariable1_generator;
        } else {
            return $this->combinedVariable1_semiAutomatic;
        }
    }

    /**
     * @param mixed $combinedVariable1
     * @return Test
     */
    public function setCombinedVariable1($combinedVariable1)
    {
        $this->combinedVariable1_simple = null;
        $this->combinedVariable1_generator = null;
        $this->combinedVariable1_semiAutomatic = null;
        if ($combinedVariable1 instanceof SimpleVariable) {
            $this->combinedVariable1_simple = $combinedVariable1;
        } elseif ($combinedVariable1 instanceof GeneratorVariable) {
            $this->combinedVariable1_generator = $combinedVariable1;
        } elseif ($combinedVariable1 instanceof SemiAutomaticVariable) {
            $this->combinedVariable1_semiAutomatic = $combinedVariable1;
        } elseif ($combinedVariable1 !== null) {
            throw new Exception();
        }
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCombinationOperation(): ?string
    {
        return $this->combinationOperation;
    }

    /**
     * @param string|null $combinationOperation
     * @return Test
     */
    public function setCombinationOperation(?string $combinationOperation): Test
    {
        $this->combinationOperation = $combinationOperation;
        return $this;
    }

    /**
     * @return mixed
     * @Groups({"project_synthesis"})
     */
    public function getCombinedVariable2()
    {
        if ($this->combinedVariable2_simple !== null) {
            return $this->combinedVariable2_simple;
        } elseif ($this->combinedVariable2_generator !== null) {
            return $this->combinedVariable2_generator;
        } else {
            return $this->combinedVariable2_semiAutomatic;
        }
    }

    /**
     * @param mixed $combinedVariable2
     * @return Test
     */
    public function setCombinedVariable2($combinedVariable2)
    {
        $this->combinedVariable2_simple = null;
        $this->combinedVariable2_generator = null;
        $this->combinedVariable2_semiAutomatic = null;
        if ($combinedVariable2 instanceof SimpleVariable) {
            $this->combinedVariable2_simple = $combinedVariable2;
        } elseif ($combinedVariable2 instanceof GeneratorVariable) {
            $this->combinedVariable2_generator = $combinedVariable2;
        } elseif ($combinedVariable2 instanceof SemiAutomaticVariable) {
            $this->combinedVariable2_semiAutomatic = $combinedVariable2;
        } elseif ($combinedVariable2 !== null) {
            throw new Exception();
        }
        return $this;
    }

    /**
     * @return float|null
     */
    public function getMinLimit(): ?float
    {
        return $this->minLimit;
    }

    /**
     * @param float|null $minLimit
     * @return Test
     */
    public function setMinLimit(?float $minLimit): Test
    {
        $this->minLimit = $minLimit;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getMaxLimit(): ?float
    {
        return $this->maxLimit;
    }

    /**
     * @param float|null $maxLimit
     * @return Test
     */
    public function setMaxLimit(?float $maxLimit): Test
    {
        $this->maxLimit = $maxLimit;
        return $this;
    }

    /**
     * @return bool|null
     */
    public function getCompareWithVariable(): ?bool
    {
        return $this->compareWithVariable;
    }

    /**
     * @param bool|null $compareWithVariable
     * @return Test
     */
    public function setCompareWithVariable(?bool $compareWithVariable): Test
    {
        $this->compareWithVariable = $compareWithVariable;
        return $this;
    }

    /**
     * @return mixed
     * @Groups({"project_synthesis"})
     */
    public function getComparedVariable1()
    {
        if ($this->comparedVariable1_simple !== null) {
            return $this->comparedVariable1_simple;
        } elseif ($this->comparedVariable1_generator !== null) {
            return $this->comparedVariable1_generator;
        } else {
            return $this->comparedVariable1_semiAutomatic;
        }
    }

    /**
     * @param AbstractVariable|null $comparedVariable1
     * @return Test
     */
    public function setComparedVariable1(?AbstractVariable $comparedVariable1): Test
    {
        $this->comparedVariable1_simple = null;
        $this->comparedVariable1_generator = null;
        $this->comparedVariable1_semiAutomatic = null;
        if ($comparedVariable1 instanceof SimpleVariable) {
            $this->comparedVariable1_simple = $comparedVariable1;
        } elseif ($comparedVariable1 instanceof GeneratorVariable) {
            $this->comparedVariable1_generator = $comparedVariable1;
        } elseif ($comparedVariable1 instanceof SemiAutomaticVariable) {
            $this->comparedVariable1_semiAutomatic = $comparedVariable1;
        } elseif ($comparedVariable1 !== null) {
            throw new Exception();
        }
        return $this;
    }

    /**
     * @return string|null
     */
    public function getComparisonOperation(): ?string
    {
        return $this->comparisonOperation;
    }

    /**
     * @param string|null $comparisonOperation
     * @return Test
     */
    public function setComparisonOperation(?string $comparisonOperation): Test
    {
        $this->comparisonOperation = $comparisonOperation;
        return $this;
    }

    /**
     * @return mixed
     * @Groups({"project_synthesis"})
     */
    public function getComparedVariable2()
    {
        if ($this->comparedVariable2_simple !== null) {
            return $this->comparedVariable2_simple;
        } elseif ($this->comparedVariable2_generator !== null) {
            return $this->comparedVariable2_generator;
        } else {
            return $this->comparedVariable2_semiAutomatic;
        }
    }

    /**
     * @param mixed $comparedVariable2
     * @return Test
     */
    public function setComparedVariable2($comparedVariable2)
    {
        $this->comparedVariable2_simple = null;
        $this->comparedVariable2_generator = null;
        $this->comparedVariable2_semiAutomatic = null;
        if ($comparedVariable2 instanceof SimpleVariable) {
            $this->comparedVariable2_simple = $comparedVariable2;
        } elseif ($comparedVariable2 instanceof GeneratorVariable) {
            $this->comparedVariable2_generator = $comparedVariable2;
        } elseif ($comparedVariable2 instanceof SemiAutomaticVariable) {
            $this->comparedVariable2_semiAutomatic = $comparedVariable2;
        }
        return $this;
    }

    /**
     * @return float|null
     */
    public function getComparedValue(): ?float
    {
        return $this->comparedValue;
    }

    /**
     * @param float|null $comparedValue
     * @return Test
     */
    public function setComparedValue(?float $comparedValue): Test
    {
        $this->comparedValue = $comparedValue;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAssignedValue(): ?string
    {
        return $this->assignedValue;
    }

    /**
     * @param string|null $assignedValue
     * @return Test
     */
    public function setAssignedValue(?string $assignedValue): Test
    {
        $this->assignedValue = $assignedValue;
        return $this;
    }


}
