<?php


namespace Webapp\Core\Entity;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Serializer\Filter\GroupFilter;
use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * Class Project
 * @package Webapp\Core\Entity
 *
 * @ApiResource(
 *     collectionOperations={
 *         "get"={},
 *         "post"={},
 *     },
 *     itemOperations={
 *          "get"={},
 *          "delete"={},
 *     }
 * )
 *
 * @ApiFilter(GroupFilter::class, arguments={"whitelist"={"project_explorer_view"}})
 * @ORM\Entity
 *
 * @ORM\Table(name="variable_connection", schema="webapp")
 */
class VariableConnection extends IdentifiedEntity
{

    /**
     * @var SimpleVariable|null
     *
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\SimpleVariable", inversedBy="connectedVariables")
     * @Groups({"connected_variables"})
     */
    private ?SimpleVariable $projectSimpleVariable;

    /**
     * @var GeneratorVariable|null
     *
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\GeneratorVariable", inversedBy="connectedVariables")
     * @Groups({"connected_variables"})
     */
    private ?GeneratorVariable $projectGeneratorVariable;

    /**
     * @var SemiAutomaticVariable|null
     *
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\SemiAutomaticVariable", inversedBy="connectedVariables")
     * @Groups({"connected_variables"})
     */
    private ?SemiAutomaticVariable $projectSemiAutomaticVariable;

    /**
     * @var SimpleVariable|null
     *
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\SimpleVariable")
     * @Groups({"project_explorer_view", "connected_variables"})
     */
    private ?SimpleVariable $dataEntrySimpleVariable;

    /**
     * @var GeneratorVariable|null
     *
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\GeneratorVariable")
     * @Groups({"project_explorer_view", "connected_variables"})
     */
    private ?GeneratorVariable $dataEntryGeneratorVariable;

    /**
     * @var SemiAutomaticVariable|null
     *
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\SemiAutomaticVariable")
     * @Groups({"project_explorer_view", "connected_variables"})
     */
    private ?SemiAutomaticVariable $dataEntrySemiAutomaticVariable;

    public function __construct()
    {
        $this->projectSimpleVariable = null;
        $this->projectGeneratorVariable = null;
        $this->projectSemiAutomaticVariable = null;
        $this->dataEntrySimpleVariable = null;
        $this->dataEntryGeneratorVariable = null;
        $this->dataEntrySemiAutomaticVariable = null;
    }

    /**
     * @return SimpleVariable | GeneratorVariable | SemiAutomaticVariable
     */
    public function getProjectVariable(): AbstractVariable
    {
        return $this->projectSimpleVariable ?? $this->projectGeneratorVariable ?? $this->projectSemiAutomaticVariable;
    }

    /**
     * @return SimpleVariable | GeneratorVariable | SemiAutomaticVariable
     */
    public function getDataEntryVariable(): AbstractVariable
    {
        return $this->dataEntrySimpleVariable ?? $this->dataEntryGeneratorVariable ?? $this->dataEntrySemiAutomaticVariable;
    }

    /**
     * @return SimpleVariable|null
     */
    public function getProjectSimpleVariable(): ?SimpleVariable
    {
        return $this->projectSimpleVariable;
    }

    /**
     * @param SimpleVariable|null $projectSimpleVariable
     * @return VariableConnection
     */
    public function setProjectSimpleVariable(?SimpleVariable $projectSimpleVariable): VariableConnection
    {
        $this->projectSimpleVariable = $projectSimpleVariable;
        return $this;
    }

    /**
     * @return GeneratorVariable|null
     */
    public function getProjectGeneratorVariable(): ?GeneratorVariable
    {
        return $this->projectGeneratorVariable;
    }

    /**
     * @param GeneratorVariable|null $projectGeneratorVariable
     * @return VariableConnection
     */
    public function setProjectGeneratorVariable(?GeneratorVariable $projectGeneratorVariable): VariableConnection
    {
        $this->projectGeneratorVariable = $projectGeneratorVariable;
        return $this;
    }

    /**
     * @return SemiAutomaticVariable|null
     */
    public function getProjectSemiAutomaticVariable(): ?SemiAutomaticVariable
    {
        return $this->projectSemiAutomaticVariable;
    }

    /**
     * @param SemiAutomaticVariable|null $projectSemiAutomaticVariable
     * @return VariableConnection
     */
    public function setProjectSemiAutomaticVariable(?SemiAutomaticVariable $projectSemiAutomaticVariable): VariableConnection
    {
        $this->projectSemiAutomaticVariable = $projectSemiAutomaticVariable;
        return $this;
    }

    /**
     * @return SimpleVariable|null
     */
    public function getDataEntrySimpleVariable(): ?SimpleVariable
    {
        return $this->dataEntrySimpleVariable;
    }

    /**
     * @param SimpleVariable|null $dataEntrySimpleVariable
     * @return VariableConnection
     */
    public function setDataEntrySimpleVariable(?SimpleVariable $dataEntrySimpleVariable): VariableConnection
    {
        $this->dataEntrySimpleVariable = $dataEntrySimpleVariable;
        return $this;
    }

    /**
     * @return GeneratorVariable|null
     */
    public function getDataEntryGeneratorVariable(): ?GeneratorVariable
    {
        return $this->dataEntryGeneratorVariable;
    }

    /**
     * @param GeneratorVariable|null $dataEntryGeneratorVariable
     * @return VariableConnection
     */
    public function setDataEntryGeneratorVariable(?GeneratorVariable $dataEntryGeneratorVariable): VariableConnection
    {
        $this->dataEntryGeneratorVariable = $dataEntryGeneratorVariable;
        return $this;
    }

    /**
     * @return SemiAutomaticVariable|null
     */
    public function getDataEntrySemiAutomaticVariable(): ?SemiAutomaticVariable
    {
        return $this->dataEntrySemiAutomaticVariable;
    }

    /**
     * @param SemiAutomaticVariable|null $dataEntrySemiAutomaticVariable
     * @return VariableConnection
     */
    public function setDataEntrySemiAutomaticVariable(?SemiAutomaticVariable $dataEntrySemiAutomaticVariable): VariableConnection
    {
        $this->dataEntrySemiAutomaticVariable = $dataEntrySemiAutomaticVariable;
        return $this;
    }

    public function setProjectVariable(AbstractVariable $variable)
    {
        if ($variable instanceof SimpleVariable) {
            $this->setProjectSimpleVariable($variable);
        } elseif ($variable instanceof SemiAutomaticVariable) {
            $this->setProjectSemiAutomaticVariable($variable);
        } elseif ($variable instanceof GeneratorVariable) {
            $this->setProjectGeneratorVariable($variable);
        }
    }

    public function setDataEntryVariable(AbstractVariable $variable)
    {
        if ($variable instanceof SimpleVariable) {
            $this->setDataEntrySimpleVariable($variable);
        } elseif ($variable instanceof SemiAutomaticVariable) {
            $this->setDataEntrySemiAutomaticVariable($variable);
        } elseif ($variable instanceof GeneratorVariable) {
            $this->setDataEntryGeneratorVariable($variable);
        }
        return $this;
    }


}
