<?php

namespace Webapp\Core\Entity;

use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * Class VariableScaleItem
 * @package Webapp\Core\Entity
 *
 * @ORM\Entity()
 * @ORM\Table(name="variable_scale_item", schema="webapp")
 */
class VariableScaleItem extends IdentifiedEntity
{
    /**
     * @var integer
     * @Groups({"webapp_data_view", "simple_variable_get", "simple_variable_post"})
     * @ORM\Column(type="integer")
     */
    private int $value;

    /**
     * @var string|null
     * @Groups({"webapp_data_view", "simple_variable_get", "simple_variable_post"})
     * @ORM\Column(type="string", nullable=true)
     */
    private ?string $text;

    /**
     * @var string|null
     * @Groups({"simple_variable_get", "simple_variable_post"})
     * @ORM\Column(type="text", nullable=true)
     */
    private ?string $pic;

    /**
     * @var VariableScale|null
     *
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\VariableScale", inversedBy="values")
     */
    private ?VariableScale $scale;

    public function __construct($value)
    {
        $this->value = $value;
        $this->text = null;
        $this->scale = null;
        $this->pic = null;
    }

    /**
     * @return int
     */
    public function getValue(): int
    {
        return $this->value;
    }

    /**
     * @param int $value
     * @return VariableScaleItem
     */
    public function setValue(int $value): VariableScaleItem
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getText(): ?string
    {
        return $this->text;
    }

    /**
     * @param string|null $text
     * @return VariableScaleItem
     */
    public function setText(?string $text): VariableScaleItem
    {
        $this->text = $text;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPic(): ?string
    {
        return $this->pic;
    }

    /**
     * @param string|null $pic
     * @return VariableScaleItem
     */
    public function setPic(?string $pic): VariableScaleItem
    {
        $this->pic = $pic;
        return $this;
    }

    /**
     * @return VariableScale|null
     */
    public function getScale(): ?VariableScale
    {
        return $this->scale;
    }

    /**
     * @param VariableScale|null $scale
     * @return VariableScaleItem
     */
    public function setScale(?VariableScale $scale): VariableScaleItem
    {
        $this->scale = $scale;
        return $this;
    }

}
