<?php

namespace Webapp\Core\Traits;

use DateTime;
use Doctrine\ORM\Mapping as ORM;

trait GraphicallyDeletableEntity
{
    /**
     * @ORM\Column(type="datetime", nullable=true)
     *
     * @var DateTime|null
     */
    protected $graphicallyDeletedAt;

    /**
     * Set or clear the deleted at timestamp.
     *
     * @return self
     */
    public function setGraphicallyDeletedAt(DateTime $deletedAt = null)
    {
        $this->graphicallyDeletedAt = $deletedAt;

        return $this;
    }

    /**
     * Get the deleted at timestamp value. Will return null if
     * the entity has not been soft deleted.
     *
     * @return DateTime|null
     */
    public function getGraphicallyDeletedAt()
    {
        return $this->graphicallyDeletedAt;
    }

    /**
     * Check if the entity has been soft deleted.
     *
     * @return bool
     */
    public function isGraphicallyDeleted()
    {
        return null !== $this->graphicallyDeletedAt;
    }
}
