<?php

namespace Mobile\Device\Entity;

use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;

/**
 * Class Anomaly.
 *
 * @ORM\Entity(repositoryClass="Mobile\Device\Repository\AnomalyRepository")
 * @ORM\Table(name="anomaly", schema="adonis")
 */
class Anomaly extends IdentifiedEntity
{
    const TYPE_DEAD = 0;
    const TYPE_BAD_TREATMENT = 1;

    /**
     * @var string
     *
     * @ORM\Column(type="text", nullable=false)
     */
    private $description;

    /**
     * @var integer
     *
     * @ORM\Column(type="integer", nullable=false)
     */
    private $type;

    /**
     * @var Treatment | null
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Device\Entity\Treatment")
     */
    private $constatedTreatment;

    /**
     * @var BusinessObject
     *
     * @ORM\OneToOne(targetEntity="Mobile\Device\Entity\BusinessObject", mappedBy="anomaly")
     */
    private $businessObject;

    /**
     * @return string
     */
    public function getDescription(): string
    {
        return $this->description;
    }

    /**
     * @param string $description
     * @return Anomaly
     */
    public function setDescription(string $description): Anomaly
    {
        $this->description = $description;
        return $this;
    }

    /**
     * @return int
     */
    public function getType(): int
    {
        return $this->type;
    }

    /**
     * @param int $type
     * @return Anomaly
     */
    public function setType(int $type): Anomaly
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return Treatment|null
     */
    public function getConstatedTreatment(): ?Treatment
    {
        return $this->constatedTreatment;
    }

    /**
     * @param Treatment|null $constatedTreatment
     * @return Anomaly
     */
    public function setConstatedTreatment(?Treatment $constatedTreatment): Anomaly
    {
        $this->constatedTreatment = $constatedTreatment;
        return $this;
    }

    /**
     * @return BusinessObject
     */
    public function getBusinessObject(): BusinessObject
    {
        return $this->businessObject;
    }

    /**
     * @param BusinessObject $businessObject
     * @return Anomaly
     */
    public function setBusinessObject(BusinessObject $businessObject): Anomaly
    {
        $this->businessObject = $businessObject;
        return $this;
    }

}
