<?php

namespace Mobile\Device\Entity;

use DateTime;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Mobile\Project\Entity\Platform;

/**
 * Class DataEntryProject.
 *
 * @ORM\Entity(repositoryClass="Mobile\Device\Repository\DeviceRepository")
 * @ORM\Table(name="experiment", schema="adonis")
 */
class Device extends BusinessObject
{
    /**
     * @var Platform|null
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Project\Entity\Platform", inversedBy="devices")
     * @ORM\JoinColumn(nullable=true, onDelete="CASCADE")
     */
    private $platform;

    /**
     * @var bool
     *
     * @ORM\Column(type="boolean", nullable=false)
     */
    private $individualPU;

    /**
     * @var Collection<array-key, Block>
     *
     * @ORM\OneToMany(targetEntity="Mobile\Device\Entity\Block", mappedBy="device", cascade={"persist", "remove", "detach"})
     */
    private $blocks;

    /**
     * @var Protocol
     *
     * @ORM\OneToOne(targetEntity="Mobile\Device\Entity\Protocol", mappedBy="device", cascade={"persist", "remove", "detach"})
     */
    private $protocol;

    /**
     * @var Collection<array-key, OutExperimentationZone>
     *
     * @ORM\OneToMany(targetEntity="Mobile\Device\Entity\OutExperimentationZone", mappedBy="device", cascade={"persist", "remove", "detach"})
     */
    private $outExperimentationZones;

    /**
     * @var DateTime
     *
     * @ORM\Column(type="datetime", nullable=false)
     */
    private $creationDate;

    /**
     * @var DateTime | null
     *
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $validationDate;

    /**
     * Device constructor.
     */
    public function __construct()
    {
        parent::__construct();
        $this->blocks = new ArrayCollection();
        $this->outExperimentationZones = new ArrayCollection();
    }

    /**
     * @return Platform|null
     */
    public function getPlatform(): ?Platform
    {
        return $this->platform;
    }

    /**
     * @param Platform|null $platform
     * @return Device
     */
    public function setPlatform(?Platform $platform): Device
    {
        $this->platform = $platform;
        return $this;
    }

    /**
     * @return bool
     */
    public function isIndividualPU(): bool
    {
        return $this->individualPU;
    }

    /**
     * @param bool $individualPU
     * @return Device
     */
    public function setIndividualPU(bool $individualPU): Device
    {
        $this->individualPU = $individualPU;
        return $this;
    }

    /**
     * @return Collection<array-key, Block>
     */
    public function getBlocks(): Collection
    {
        return $this->blocks;
    }

    /**
     * @param Block $block
     */
    public function addBlock(Block $block): void
    {
        if (!$this->blocks->contains($block)) {
            $block->setDevice($this);
            $this->blocks->add($block);
        }
    }

    /**
     * @param Block $block
     */
    public function removeBlock(Block $block): void
    {
        if ($this->blocks->contains($block)) {
            $block->setDevice(null);
            $this->blocks->removeElement($block);
        }
    }

    /**
     * @return Protocol
     */
    public function getProtocol(): Protocol
    {
        return $this->protocol;
    }

    /**
     * @param Protocol $protocol
     * @return Device
     */
    public function setProtocol(Protocol $protocol): Device
    {
        $this->protocol = $protocol;
        $protocol->setDevice($this);
        return $this;
    }

    /**
     * @return Collection
     */
    public function getOutExperimentationZones(): Collection
    {
        return $this->outExperimentationZones;
    }

    /**
     * @param OutExperimentationZone $outExperimentationZone
     */
    public function addOutExperimentationZone(OutExperimentationZone $outExperimentationZone): void
    {
        if (!$this->outExperimentationZones->contains($outExperimentationZone)) {
            $outExperimentationZone->setDevice($this);
            $this->outExperimentationZones->add($outExperimentationZone);
        }
    }

    /**
     * @param OutExperimentationZone $outExperimentationZone
     */
    public function removeOutExperimentationZone(OutExperimentationZone $outExperimentationZone): void
    {
        if ($this->outExperimentationZones->contains($outExperimentationZone)) {
            $outExperimentationZone->setDevice(null);
            $this->outExperimentationZones->removeElement($outExperimentationZone);
        }
    }

    /**
     * @return DateTime
     */
    public function getCreationDate(): DateTime
    {
        return $this->creationDate;
    }

    /**
     * @param DateTime $creationDate
     * @return Device
     */
    public function setCreationDate(DateTime $creationDate): Device
    {
        $this->creationDate = $creationDate;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getValidationDate(): ?DateTime
    {
        return $this->validationDate;
    }

    /**
     * @param DateTime|null $validationDate
     * @return Device
     */
    public function setValidationDate(?DateTime $validationDate): Device
    {
        $this->validationDate = $validationDate;
        return $this;
    }

    public function parent(): ?BusinessObject
    {
        return null;
    }
}
