<?php

namespace Mobile\Device\Entity;

use DateTime;
use Doctrine\ORM\Mapping as ORM;
use Mobile\Measure\Entity\Variable\StateCode;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * Class Individual.
 *
 * @ORM\Entity(repositoryClass="Mobile\Device\Repository\IndividualRepository")
 * @ORM\Table(name="individual", schema="adonis")
 */
class Individual extends BusinessObject
{
    public const DEFAULT_NAME_FROM_CSV = "";

    /**
     * @var int
     * @Groups({"status_project_webapp_return_data"})
     * @ORM\Column(type="integer", nullable=false)
     */
    private $x;

    /**
     * @var int
     * @Groups({"status_project_webapp_return_data"})
     * @ORM\Column(type="integer", nullable=false)
     */
    private $y;

    /**
     * @var StateCode|null
     * @Groups({"status_project_webapp_return_data"})
     * @ORM\ManyToOne(targetEntity="Mobile\Measure\Entity\Variable\StateCode", cascade={"persist", "remove", "detach"})
     * @ORM\JoinColumn(nullable=true)
     */
    private $stateCode;

    /**
     * @var UnitParcel
     * @Groups({"status_project_webapp_return_data"})
     * @ORM\ManyToOne(targetEntity="Mobile\Device\Entity\UnitParcel", inversedBy="individuals")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    private $unitParcel;

    /**
     * @var DateTime
     * @Groups({"status_project_webapp_return_data"})
     * @ORM\Column(type="datetime", nullable=false)
     */
    private $apparitionDate;

    /**
     * @var DateTime|null
     * @Groups({"status_project_webapp_return_data"})
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $demiseDate;

    /**
     * @var string | null
     * @Groups({"status_project_webapp_return_data"})
     * @ORM\Column(type="string", nullable=true)
     */
    private $ident;

    public function __toString()
    {
        return $this->getUri();
    }

    /**
     * @return int
     */
    public function getX(): int
    {
        return $this->x;
    }

    /**
     * @param int $x
     * @return Individual
     */
    public function setX(int $x): Individual
    {
        $this->x = $x;
        return $this;
    }

    /**
     * @return int
     */
    public function getY(): int
    {
        return $this->y;
    }

    /**
     * @param int $y
     * @return Individual
     */
    public function setY(int $y): Individual
    {
        $this->y = $y;
        return $this;
    }

    /**
     * @return StateCode|null
     */
    public function getStateCode(): ?StateCode
    {
        return $this->stateCode;
    }

    /**
     * @param StateCode|null $stateCode
     * @return Individual
     */
    public function setStateCode(?StateCode $stateCode): Individual
    {
        $this->stateCode = $stateCode;
        return $this;
    }

    /**
     * @return UnitParcel
     */
    public function getUnitParcel(): UnitParcel
    {
        return $this->unitParcel;
    }

    /**
     * @param UnitParcel $unitParcel
     * @return Individual
     */
    public function setUnitParcel(UnitParcel $unitParcel): Individual
    {
        $this->unitParcel = $unitParcel;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getApparitionDate(): DateTime
    {
        return $this->apparitionDate;
    }

    /**
     * @param DateTime $apparitionDate
     * @return Individual
     */
    public function setApparitionDate(DateTime $apparitionDate): Individual
    {
        $this->apparitionDate = $apparitionDate;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getDemiseDate(): ?DateTime
    {
        return $this->demiseDate;
    }

    /**
     * @param DateTime|null $demiseDate
     * @return Individual
     */
    public function setDemiseDate(?DateTime $demiseDate): Individual
    {
        $this->demiseDate = $demiseDate;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getIdent(): ?string
    {
        return $this->ident;
    }

    /**
     * @param string|null $ident
     * @return Individual
     */
    public function setIdent(?string $ident): Individual
    {
        $this->ident = $ident;
        return $this;
    }

    public function parent(): ?BusinessObject
    {
        return $this->getUnitParcel();
    }
}
