<?php

namespace Mobile\Device\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * Class SubBloc.
 *
 * @ORM\Entity(repositoryClass="Mobile\Device\Repository\SubBlockRepository")
 * @ORM\Table(name="sub_block", schema="adonis")
 */
class SubBlock extends BusinessObject
{
    /**
     * @var Block
     * @Groups({"status_project_webapp_return_data"})
     * @ORM\ManyToOne(targetEntity="Mobile\Device\Entity\Block", inversedBy="subBlocks")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    private $block;

    /**
     * @var Collection<array-key, UnitParcel>
     *
     * @ORM\OneToMany(targetEntity="Mobile\Device\Entity\UnitParcel", mappedBy="subBlock", cascade={"persist", "remove", "detach"})
     */
    private $unitParcels;

    /**
     * @var Collection<array-key, OutExperimentationZone>
     *
     * @ORM\OneToMany(targetEntity="Mobile\Device\Entity\OutExperimentationZone", mappedBy="subBlock", cascade={"persist", "remove", "detach"})
     */
    private $outExperimentationZones;

    /**
     * SubBlock constructor.
     */
    public function __construct()
    {
        parent::__construct();
        $this->unitParcels = new ArrayCollection();
        $this->outExperimentationZones = new ArrayCollection();
    }

    /**
     * @return Block
     */
    public function getBlock(): Block
    {
        return $this->block;
    }

    /**
     * @param Block $block
     * @return SubBlock
     */
    public function setBlock(Block $block): SubBlock
    {
        $this->block = $block;
        return $this;
    }

    /**
     * @return Collection<array-key, UnitParcel>
     */
    public function getUnitParcels(): Collection
    {
        return $this->unitParcels;
    }

    /**
     * @param UnitParcel $pu
     */
    public function addUnitParcel(UnitParcel $pu): void
    {
        if (!$this->unitParcels->contains($pu)) {
            $pu->setBlock(null);
            $pu->setSubBlock($this);
            $this->unitParcels->add($pu);
        }
    }

    /**
     * @param UnitParcel $pu
     */
    public function removeUnitParcel(UnitParcel $pu): void
    {
        if ($this->unitParcels->contains($pu)) {
            $pu->setSubBlock(null);
            $this->unitParcels->removeElement($pu);
        }
    }

    /**
     * @return Collection
     */
    public function getOutExperimentationZones(): Collection
    {
        return $this->outExperimentationZones;
    }

    /**
     * @param Collection $outExperimentationZones
     * @return SubBlock
     */
    public function setOutExperimentationZones(Collection $outExperimentationZones): SubBlock
    {
        $this->outExperimentationZones = $outExperimentationZones;
        return $this;
    }

    /**
     * @param OutExperimentationZone $outExperimentationZone
     */
    public function addOutExperimentationZone(OutExperimentationZone $outExperimentationZone): void
    {
        if (!$this->outExperimentationZones->contains($outExperimentationZone)) {
            $outExperimentationZone->setSubBlock($this);
            $this->outExperimentationZones->add($outExperimentationZone);
        }
    }

    /**
     * @param OutExperimentationZone $outExperimentationZone
     */
    public function removeOutExperimentationZone(OutExperimentationZone $outExperimentationZone): void
    {
        if ($this->outExperimentationZones->contains($outExperimentationZone)) {
            $outExperimentationZone->setSubBlock(null);
            $this->outExperimentationZones->removeElement($outExperimentationZone);
        }
    }

    public function parent(): ?BusinessObject
    {
        return $this->getBlock();
    }
}
