<?php

namespace Mobile\Project\Entity;

use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;

/**
 * Class GraphicalStructure
 *
 * @ORM\Entity(repositoryClass="Mobile\Project\Repository\GraphicalStructureRepository")
 * @ORM\Table(name="graphical_structure", schema="adonis")
 */
class GraphicalStructure extends IdentifiedEntity
{
    /**
     * @var DataEntryProject
     *
     * @ORM\OneToOne(targetEntity="Mobile\Project\Entity\DataEntryProject", inversedBy="graphicalStructure")
     * @ORM\JoinColumn(nullable=true)
     */
    private $project;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $platformColor;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $deviceColor;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $blockColor;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $subBlockColor;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $individualUnitParcelColor;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $surfaceUnitParcelColor;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $abnormalUnitParcelColor;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $individualColor;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $abnormalIndividualColor;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $emptyColor;

    /**
     * @var bool
     *
     * @ORM\Column(type="boolean", nullable=false)
     */
    private $tooltipActive;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $deviceLabel;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $blockLabel;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $subBlockLabel;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $individualUnitParcelLabel;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $surfaceUnitParcelLabel;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $individualLabel;

    /**
     * @var string|null
     *
     * @ORM\Column(type="string", nullable=true)
     */
    private $origin;


    /**
     * @var int|null
     *
     * @ORM\Column(type="integer", nullable=true)
     */
    private $baseWidth;


    /**
     * @var int|null
     *
     * @ORM\Column(type="integer", nullable=true)
     */
    private $baseHeight;

    /**
     * @return DataEntryProject
     */
    public function getProject(): DataEntryProject
    {
        return $this->project;
    }

    /**
     * @param DataEntryProject $project
     * @return GraphicalStructure
     */
    public function setProject(DataEntryProject $project): GraphicalStructure
    {
        $this->project = $project;
        return $this;
    }

    /**
     * @return string
     */
    public function getPlatformColor(): string
    {
        return $this->platformColor;
    }

    /**
     * @param string $platformColor
     * @return GraphicalStructure
     */
    public function setPlatformColor(string $platformColor): GraphicalStructure
    {
        $this->platformColor = $platformColor;
        return $this;
    }

    /**
     * @return string
     */
    public function getDeviceColor(): string
    {
        return $this->deviceColor;
    }

    /**
     * @param string $deviceColor
     * @return GraphicalStructure
     */
    public function setDeviceColor(string $deviceColor): GraphicalStructure
    {
        $this->deviceColor = $deviceColor;
        return $this;
    }

    /**
     * @return string
     */
    public function getBlockColor(): string
    {
        return $this->blockColor;
    }

    /**
     * @param string $blockColor
     * @return GraphicalStructure
     */
    public function setBlockColor(string $blockColor): GraphicalStructure
    {
        $this->blockColor = $blockColor;
        return $this;
    }

    /**
     * @return string
     */
    public function getSubBlockColor(): string
    {
        return $this->subBlockColor;
    }

    /**
     * @param string $subBlockColor
     * @return GraphicalStructure
     */
    public function setSubBlockColor(string $subBlockColor): GraphicalStructure
    {
        $this->subBlockColor = $subBlockColor;
        return $this;
    }

    /**
     * @return string
     */
    public function getIndividualUnitParcelColor(): string
    {
        return $this->individualUnitParcelColor;
    }

    /**
     * @param string $individualUnitParcelColor
     * @return GraphicalStructure
     */
    public function setIndividualUnitParcelColor(string $individualUnitParcelColor): GraphicalStructure
    {
        $this->individualUnitParcelColor = $individualUnitParcelColor;
        return $this;
    }

    /**
     * @return string
     */
    public function getSurfaceUnitParcelColor(): string
    {
        return $this->surfaceUnitParcelColor;
    }

    /**
     * @param string $surfaceUnitParcelColor
     * @return GraphicalStructure
     */
    public function setSurfaceUnitParcelColor(string $surfaceUnitParcelColor): GraphicalStructure
    {
        $this->surfaceUnitParcelColor = $surfaceUnitParcelColor;
        return $this;
    }

    /**
     * @return string
     */
    public function getAbnormalUnitParcelColor(): string
    {
        return $this->abnormalUnitParcelColor;
    }

    /**
     * @param string $abnormalUnitParcelColor
     * @return GraphicalStructure
     */
    public function setAbnormalUnitParcelColor(string $abnormalUnitParcelColor): GraphicalStructure
    {
        $this->abnormalUnitParcelColor = $abnormalUnitParcelColor;
        return $this;
    }

    /**
     * @return string
     */
    public function getIndividualColor(): string
    {
        return $this->individualColor;
    }

    /**
     * @param string $individualColor
     * @return GraphicalStructure
     */
    public function setIndividualColor(string $individualColor): GraphicalStructure
    {
        $this->individualColor = $individualColor;
        return $this;
    }

    /**
     * @return string
     */
    public function getAbnormalIndividualColor(): string
    {
        return $this->abnormalIndividualColor;
    }

    /**
     * @param string $abnormalIndividualColor
     * @return GraphicalStructure
     */
    public function setAbnormalIndividualColor(string $abnormalIndividualColor): GraphicalStructure
    {
        $this->abnormalIndividualColor = $abnormalIndividualColor;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmptyColor(): string
    {
        return $this->emptyColor;
    }

    /**
     * @param string $emptyColor
     * @return GraphicalStructure
     */
    public function setEmptyColor(string $emptyColor): GraphicalStructure
    {
        $this->emptyColor = $emptyColor;
        return $this;
    }

    /**
     * @return bool
     */
    public function isTooltipActive(): bool
    {
        return $this->tooltipActive;
    }

    /**
     * @param bool $tooltipActive
     * @return GraphicalStructure
     */
    public function setTooltipActive(bool $tooltipActive): GraphicalStructure
    {
        $this->tooltipActive = $tooltipActive;
        return $this;
    }

    /**
     * @return string
     */
    public function getDeviceLabel(): string
    {
        return $this->deviceLabel;
    }

    /**
     * @param string $deviceLabel
     * @return GraphicalStructure
     */
    public function setDeviceLabel(string $deviceLabel): GraphicalStructure
    {
        $this->deviceLabel = $deviceLabel;
        return $this;
    }

    /**
     * @return string
     */
    public function getBlockLabel(): string
    {
        return $this->blockLabel;
    }

    /**
     * @param string $blockLabel
     * @return GraphicalStructure
     */
    public function setBlockLabel(string $blockLabel): GraphicalStructure
    {
        $this->blockLabel = $blockLabel;
        return $this;
    }

    /**
     * @return string
     */
    public function getSubBlockLabel(): string
    {
        return $this->subBlockLabel;
    }

    /**
     * @param string $subBlockLabel
     * @return GraphicalStructure
     */
    public function setSubBlockLabel(string $subBlockLabel): GraphicalStructure
    {
        $this->subBlockLabel = $subBlockLabel;
        return $this;
    }

    /**
     * @return string
     */
    public function getIndividualUnitParcelLabel(): string
    {
        return $this->individualUnitParcelLabel;
    }

    /**
     * @param string $individualUnitParcelLabel
     * @return GraphicalStructure
     */
    public function setIndividualUnitParcelLabel(string $individualUnitParcelLabel): GraphicalStructure
    {
        $this->individualUnitParcelLabel = $individualUnitParcelLabel;
        return $this;
    }

    /**
     * @return string
     */
    public function getSurfaceUnitParcelLabel(): string
    {
        return $this->surfaceUnitParcelLabel;
    }

    /**
     * @param string $surfaceUnitParcelLabel
     * @return GraphicalStructure
     */
    public function setSurfaceUnitParcelLabel(string $surfaceUnitParcelLabel): GraphicalStructure
    {
        $this->surfaceUnitParcelLabel = $surfaceUnitParcelLabel;
        return $this;
    }

    /**
     * @return string
     */
    public function getIndividualLabel(): string
    {
        return $this->individualLabel;
    }

    /**
     * @param string $individualLabel
     * @return GraphicalStructure
     */
    public function setIndividualLabel(string $individualLabel): GraphicalStructure
    {
        $this->individualLabel = $individualLabel;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getOrigin(): ?string
    {
        return $this->origin;
    }

    /**
     * @param string|null $origin
     * @return GraphicalStructure
     */
    public function setOrigin(?string $origin): GraphicalStructure
    {
        $this->origin = $origin;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getBaseWidth(): ?int
    {
        return $this->baseWidth;
    }

    /**
     * @param int|null $baseWidth
     * @return GraphicalStructure
     */
    public function setBaseWidth(?int $baseWidth): GraphicalStructure
    {
        $this->baseWidth = $baseWidth;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getBaseHeight(): ?int
    {
        return $this->baseHeight;
    }

    /**
     * @param int|null $baseHeight
     * @return GraphicalStructure
     */
    public function setBaseHeight(?int $baseHeight): GraphicalStructure
    {
        $this->baseHeight = $baseHeight;
        return $this;
    }

}
