<?php


namespace Webapp\Core\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;
use Symfony\Component\Serializer\Annotation\Groups;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class VariableScale
 * @package Webapp\Core\Entity
 *
 * @ApiResource(
 *     itemOperations={
 *         "get"={},
 *         "delete"={},
 *         "patch"={}
 *     }
 * )
 *
 *
 * @ORM\Entity
 * @ORM\Table(name="scale", schema="webapp")
 */
class VariableScale extends IdentifiedEntity
{
    /**
     * @var string
     *
     * @Assert\NotBlank
     * @ORM\Column(type="string")
     * @Groups({"webapp_data_view", "project_explorer_view", "simple_variable_get", "simple_variable_post", "project_synthesis"})
     */
    private string $name;

    /**
     * @var int
     * @Groups({"webapp_data_view", "simple_variable_get", "simple_variable_post"})
     *
     * @ORM\Column(type="integer")
     */
    private int $minValue;

    /**
     * @var int
     * @Groups({"webapp_data_view", "simple_variable_get", "simple_variable_post"})
     *
     * @ORM\Column(type="integer")
     */
    private int $maxValue;

    /**
     * @var bool
     * @Groups({"webapp_data_view", "simple_variable_get", "simple_variable_post"})
     *
     * @ORM\Column(type="boolean")
     */
    private bool $open;

    /**
     * @var SimpleVariable
     *
     * @ORM\OneToOne(targetEntity="Webapp\Core\Entity\SimpleVariable", inversedBy="scale")
     */
    private SimpleVariable $variable;

    /**
     * @var Collection<array-key, VariableScaleItem>|array
     * @Groups({"webapp_data_view", "simple_variable_get", "simple_variable_post"})
     *
     * @ORM\OneToMany(targetEntity="Webapp\Core\Entity\VariableScaleItem", mappedBy="scale", cascade={"persist", "remove"}, orphanRemoval=true)
     */
    private $values;

    public function __construct()
    {
        $this->values = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return VariableScale
     */
    public function setName(string $name): VariableScale
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return int
     */
    public function getMinValue(): int
    {
        return $this->minValue;
    }

    /**
     * @param int $minValue
     * @return VariableScale
     */
    public function setMinValue(int $minValue): VariableScale
    {
        $this->minValue = $minValue;
        return $this;
    }

    /**
     * @return int
     */
    public function getMaxValue(): int
    {
        return $this->maxValue;
    }

    /**
     * @param int $maxValue
     * @return VariableScale
     */
    public function setMaxValue(int $maxValue): VariableScale
    {
        $this->maxValue = $maxValue;
        return $this;
    }

    /**
     * @return bool
     */
    public function isOpen(): bool
    {
        return $this->open;
    }

    /**
     * @param bool $open
     * @return VariableScale
     */
    public function setOpen(bool $open): VariableScale
    {
        $this->open = $open;
        return $this;
    }

    /**
     * @return SimpleVariable
     */
    public function getVariable(): SimpleVariable
    {
        return $this->variable;
    }

    /**
     * @param SimpleVariable $variable
     * @return VariableScale
     */
    public function setVariable(SimpleVariable $variable): VariableScale
    {
        $this->variable = $variable;
        return $this;
    }

    /**
     * @return array<VariableScaleItem>|Collection
     */
    public function getValues()
    {
        return $this->values;
    }

    /**
     * @param array|Collection $values
     * @return VariableScale
     */
    public function setValues($values)
    {
        $this->values = $values;
        return $this;
    }

    /**
     * @param VariableScaleItem $variableScaleItem
     * @return VariableScale
     */
    public function addValue($variableScaleItem)
    {
        if (!$this->values->contains($variableScaleItem)) {
            $this->values->add($variableScaleItem);
            $variableScaleItem->setScale($this);
        }
        return $this;
    }

    /**
     * @param VariableScaleItem $variableScaleItem
     * @return VariableScale
     */
    public function removeValue($variableScaleItem)
    {
        if ($this->values->contains($variableScaleItem)) {
            $this->values->removeElement($variableScaleItem);
            $variableScaleItem->setScale(null);
        }
        return $this;
    }
}
