<?php
/**
 * @author      Aurélien BERNARD - TRYDEA - 2020
 */

declare(strict_types=1);

namespace Mobile\Measure\Entity;

use DateTime;
use Mobile\Measure\Entity\Variable\StateCode;
use Mobile\Project\Entity\ProjectObject;
use Doctrine\ORM\Mapping as ORM;

/**
 * Class Measure.
 *
 * @ORM\Entity()
 * @ORM\Table(name="measure", schema="adonis")
 */
class Measure extends ProjectObject
{
    /**
     * @var FormField
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Measure\Entity\FormField", inversedBy="measures")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    private $formField;

    /**
     * @var string|null
     *
     * @ORM\Column(type="text", nullable=true)
     */
    private $value;

    /**
     * Define the repetition number of the variable.
     * @var int
     *
     * @ORM\Column(type="integer", nullable=false)
     */
    private $repetition;

    /**
     * @var DateTime
     *
     * @ORM\Column(type="datetime", nullable=false)
     */
    private $timestamp;

    /**
     * @var StateCode|null
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Measure\Entity\Variable\StateCode")
     * @ORM\JoinColumn(nullable=true)
     */
    private $state;

    /**
     * Measure constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @return FormField
     */
    public function getFormField(): FormField
    {
        return $this->formField;
    }

    /**
     * @param FormField $formField
     * @return Measure
     */
    public function setFormField(FormField $formField): Measure
    {
        $this->formField = $formField;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getValue(): ?string
    {
        return $this->value;
    }

    /**
     * @param string|null $value
     * @return Measure
     */
    public function setValue(?string $value): Measure
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return int
     */
    public function getRepetition(): int
    {
        return $this->repetition ?? 1;
    }

    /**
     * @param int $repetition
     * @return Measure
     */
    public function setRepetition(int $repetition): Measure
    {
        $this->repetition = $repetition;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getTimestamp(): DateTime
    {
        return $this->timestamp;
    }

    /**
     * @param DateTime $timestamp
     * @return Measure
     */
    public function setTimestamp(DateTime $timestamp): Measure
    {
        $this->timestamp = $timestamp;
        return $this;
    }

    /**
     * @return StateCode|null
     */
    public function getState(): ?StateCode
    {
        return $this->state;
    }

    /**
     * @param StateCode|null $state
     * @return Measure
     */
    public function setState(?StateCode $state): Measure
    {
        $this->state = $state;
        return $this;
    }
}
