<?php
/**
 * @author      Aurélien BERNARD - TRYDEA - 2020
 */

declare(strict_types=1);

namespace Mobile\Project\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Mobile\Measure\Entity\Annotation;
use Shared\Authentication\Entity\IdentifiedEntity;

/**
 * Class ProjectObject.
 *
 * @ORM\Entity()
 * @ORM\Table("project_object", schema="adonis")
 * @ORM\InheritanceType(value="JOINED")
 * @ORM\DiscriminatorColumn(name="discr", type="string")
 * @ORM\DiscriminatorMap({
 *     "BusinessObject" = "Mobile\Device\Entity\BusinessObject",
 *     "Measure" = "Mobile\Measure\Entity\Measure"
 * })
 */
abstract class ProjectObject extends IdentifiedEntity
{
    /**
     * @var Collection<array-key, Annotation>
     *
     * @ORM\OneToMany(targetEntity="Mobile\Measure\Entity\Annotation", mappedBy="projectObject", cascade={"persist", "remove", "detach"})
     */
    private $annotations;

    /**
     * ProjectObject constructor.
     */
    public function __construct()
    {
        $this->annotations = new ArrayCollection();
    }

    /**
     * @return Collection
     */
    public function getAnnotations(): Collection
    {
        return $this->annotations;
    }

    /**
     * @param Annotation $annotation
     */
    public function addAnnotation(Annotation $annotation): void
    {
        if (!$this->annotations->contains($annotation)) {
            $annotation->setProjectObject($this);
            $this->annotations->add($annotation);
        }
    }

    /**
     * @param Annotation $annotation
     */
    public function removeAnnotation(Annotation $annotation): void
    {
        if ($this->annotations->contains($annotation)) {
            $this->annotations->removeElement($annotation);
        }
    }
}
