<?php


namespace Webapp\Core\Entity;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use Date;
use DateTime;
use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;
use Shared\Enumeration\Annotation\EnumType;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * Class ChangeReport
 * @package Webapp\Core\Entity
 *
 * @ApiResource(
 *     collectionOperations={
 *         "get"={}
 *     }
 * )
 *
 * @ApiFilter(SearchFilter::class, properties={})
 *
 * @ORM\Entity
 * @ORM\Table(name="change_report", schema="webapp")
 */
class ChangeReport extends IdentifiedEntity
{
    /**
     * @var Individual|null
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\Individual")
     * @Groups({"change_report"})
     */
    private ?Individual $involvedIndividual;

    /**
     * @var SurfacicUnitPlot|null
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\SurfacicUnitPlot")
     * @Groups({"change_report"})
     */
    private ?SurfacicUnitPlot $involvedSurfacicUnitPlot;

    /**
     * @var bool
     * @ORM\Column(type="boolean")
     * @Groups({"change_report", "data_entry_synthesis"})
     */
    private bool $aproved;

    /**
     * @var string
     * @ORM\Column(type="string")
     * @EnumType(class="Webapp\Core\Enumeration\ChangeTypeEnum")
     * @Groups({"change_report", "data_entry_synthesis"})
     */
    private string $changeType;

    /**
     * @var DateTime
     * @ORM\Column(type="datetime", nullable=false)
     * @Groups({"change_report"})
     */
    private DateTime $lastChangeDate;

    /**
     * @var DateTime
     * @ORM\Column(type="datetime", nullable=false)
     * @Groups({"change_report"})
     */
    private DateTime $changeDate;

    /**
     * @var ProjectData
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\ProjectData", inversedBy="changeReports")
     * @ORM\JoinColumn(nullable=false)
     */
    private ProjectData $projectData;

    public function __construct()
    {
        $this->involvedIndividual = null;
        $this->involvedSurfacicUnitPlot = null;
    }

    /**
     * @return Individual|null
     */
    public function getInvolvedIndividual(): ?Individual
    {
        return $this->involvedIndividual;
    }

    /**
     * @param Individual|null $involvedIndividual
     * @return ChangeReport
     */
    public function setInvolvedIndividual(?Individual $involvedIndividual): ChangeReport
    {
        $this->involvedIndividual = $involvedIndividual;
        return $this;
    }

    /**
     * @return SurfacicUnitPlot|null
     */
    public function getInvolvedSurfacicUnitPlot(): ?SurfacicUnitPlot
    {
        return $this->involvedSurfacicUnitPlot;
    }

    /**
     * @param SurfacicUnitPlot|null $involvedSurfacicUnitPlot
     * @return ChangeReport
     */
    public function setInvolvedSurfacicUnitPlot(?SurfacicUnitPlot $involvedSurfacicUnitPlot): ChangeReport
    {
        $this->involvedSurfacicUnitPlot = $involvedSurfacicUnitPlot;
        return $this;
    }

    /**
     * @return bool
     */
    public function isAproved(): bool
    {
        return $this->aproved;
    }

    /**
     * @param bool $aproved
     * @return ChangeReport
     */
    public function setAproved(bool $aproved): ChangeReport
    {
        $this->aproved = $aproved;
        return $this;
    }

    /**
     * @return string
     */
    public function getChangeType(): string
    {
        return $this->changeType;
    }

    /**
     * @param string $changeType
     * @return ChangeReport
     */
    public function setChangeType(string $changeType): ChangeReport
    {
        $this->changeType = $changeType;
        return $this;
    }

    /**
     * @return ProjectData
     */
    public function getProjectData(): ProjectData
    {
        return $this->projectData;
    }

    /**
     * @param ProjectData $projectData
     * @return ChangeReport
     */
    public function setProjectData(ProjectData $projectData): ChangeReport
    {
        $this->projectData = $projectData;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getChangeDate(): DateTime
    {
        return $this->changeDate;
    }

    /**
     * @param DateTime $changeDate
     * @return ChangeReport
     */
    public function setChangeDate(DateTime $changeDate): ChangeReport
    {
        $this->changeDate = $changeDate;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getLastChangeDate(): DateTime
    {
        return $this->lastChangeDate;
    }

    /**
     * @param DateTime $lastChangeDate
     * @return ChangeReport
     */
    public function setLastChangeDate(DateTime $lastChangeDate): ChangeReport
    {
        $this->lastChangeDate = $lastChangeDate;
        return $this;
    }

}
