<?php

namespace Webapp\Core\Entity\CloneExperiment;

use ApiPlatform\Core\Action\NotFoundAction;
use ApiPlatform\Core\Annotation\ApiProperty;
use ApiPlatform\Core\Annotation\ApiResource;
use Webapp\Core\ApiOperation\CloneExperimentOperation;
use Webapp\Core\Entity\Experiment;

/**
 * Class CloneExperiment.
 *
 * @ApiResource(
 *     collectionOperations={
 *          "post"={
 *              "controller"=CloneExperimentOperation::class,
 *              "read"=false,
 *              "security"="is_granted('ROLE_PLATFORM_MANAGER')",
 *              "openapi_context"={
 *                  "summary": "Clone an experiment",
 *                  "description": "Create a copy of the given experiment giving him a new name and place it in the library"
 *              },
 *          },
 *     },
 *     itemOperations={
 *     "get"={
 *             "controller"=NotFoundAction::class,
 *             "read"=false,
 *             "output"=false,
 *          }}
 * )
 *
 */
class CloneExperiment
{
    /**
     * @ApiProperty(identifier=true)
     */
    private $id;

    /**
     * @var Experiment
     */
    private Experiment $experiment;

    /**
     * @var string
     */
    private string $newName;

    /**
     * @var Experiment
     */
    private Experiment $result;

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     * @return CloneExperiment
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return Experiment
     */
    public function getExperiment(): Experiment
    {
        return $this->experiment;
    }

    /**
     * @param Experiment $experiment
     * @return CloneExperiment
     */
    public function setExperiment(Experiment $experiment): CloneExperiment
    {
        $this->experiment = $experiment;
        return $this;
    }

    /**
     * @return string
     */
    public function getNewName(): string
    {
        return $this->newName;
    }

    /**
     * @param string $newName
     * @return CloneExperiment
     */
    public function setNewName(string $newName): CloneExperiment
    {
        $this->newName = $newName;
        return $this;
    }

    /**
     * @return Experiment
     */
    public function getResult(): Experiment
    {
        return $this->result;
    }

    /**
     * @param Experiment $result
     * @return CloneExperiment
     */
    public function setResult(Experiment $result): CloneExperiment
    {
        $this->result = $result;
        return $this;
    }
}
