<?php


namespace Webapp\Core\Entity\Move;

use ApiPlatform\Core\Action\NotFoundAction;
use ApiPlatform\Core\Annotation\ApiProperty;
use ApiPlatform\Core\Annotation\ApiResource;
use Symfony\Component\Serializer\Annotation\Groups;
use Webapp\Core\ApiOperation\CopyBusinessObjectOperation;
use Webapp\Core\Entity\Block;
use Webapp\Core\Entity\Experiment;
use Webapp\Core\Entity\Individual;
use Webapp\Core\Entity\SubBlock;
use Webapp\Core\Entity\SurfacicUnitPlot;
use Webapp\Core\Entity\UnitPlot;

/**
 * @ApiResource(
 *     collectionOperations={
 *          "copy"={
 *              "controller"=CopyBusinessObjectOperation::class,
 *              "method"="PATCH",
 *              "read"=false,
 *              "security"="is_granted('ROLE_PLATFORM_MANAGER')",
 *              "openapi_context"={
 *                  "summary": "Copy one or more buisness object with the same delta",
 *                  "description": "Copy all items with given IRI to a new position and a new parent"
 *              },
 *              "normalization_context"={"groups"={"platform_full_view"}}
 *          }
 *     },
 *     itemOperations={
 *          "get"={
 *             "controller"=NotFoundAction::class,
 *             "read"=false,
 *             "output"=false,
 *          }
 *     }
 * )
 */
class Copy
{
    /**
     * @ApiProperty(identifier=true)
     */
    private $id;

    /**
     * @var array<array<string>>
     */
    private array $objectIris;
    /**
     * @var int | null
     */
    private ?int $dx;
    /**
     * @var int | null
     */
    private ?int $dy;
    /**
     * @var UnitPlot | SubBlock | Block | Experiment | null
     */
    private $parent;

    /**
     * @var Block[]|SubBlock[]|UnitPlot[]|Individual[]|SurfacicUnitPlot[]
     * @Groups({"platform_full_view"})
     */
    private array $createdObjects;

    public function __construct()
    {
        $this->objectIris = [];
        $this->dx = null;
        $this->dy = null;
        $this->parent = null;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     * @return Copy
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return \string[][]
     */
    public function getObjectIris(): array
    {
        return $this->objectIris;
    }

    /**
     * @param \string[][] $objectIris
     * @return Copy
     */
    public function setObjectIris(array $objectIris): Copy
    {
        $this->objectIris = $objectIris;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getDx(): ?int
    {
        return $this->dx;
    }

    /**
     * @param int|null $dx
     * @return Copy
     */
    public function setDx(?int $dx): Copy
    {
        $this->dx = $dx;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getDy(): ?int
    {
        return $this->dy;
    }

    /**
     * @param int|null $dy
     * @return Copy
     */
    public function setDy(?int $dy): Copy
    {
        $this->dy = $dy;
        return $this;
    }

    /**
     * @return Block|Experiment|SubBlock|UnitPlot|null
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * @param Block|Experiment|SubBlock|UnitPlot|null $parent
     * @return Copy
     */
    public function setParent($parent)
    {
        $this->parent = $parent;
        return $this;
    }

    /**
     * @return Block[]|Individual[]|SubBlock[]|SurfacicUnitPlot[]|UnitPlot[]
     */
    public function getCreatedObjects(): array
    {
        return $this->createdObjects;
    }

    /**
     * @param Block[]|Individual[]|SubBlock[]|SurfacicUnitPlot[]|UnitPlot[] $createdObjects
     * @return Copy
     */
    public function setCreatedObjects(array $createdObjects): Copy
    {
        $this->createdObjects = $createdObjects;
        return $this;
    }
}
