<?php


namespace Webapp\Core\Entity\Move;

use ApiPlatform\Core\Action\NotFoundAction;
use ApiPlatform\Core\Annotation\ApiProperty;
use ApiPlatform\Core\Annotation\ApiResource;
use Webapp\Core\ApiOperation\RestoreBusinessObjectOperation;

/**
 * @ApiResource(
 *     collectionOperations={
 *          "restore"={
 *              "controller"=RestoreBusinessObjectOperation::class,
 *              "method"="PATCH",
 *              "read"=false,
 *              "security"="is_granted('ROLE_PLATFORM_MANAGER')",
 *              "openapi_context"={
 *                  "summary": "Restore one or more buisness object given in parameter",
 *                  "description": "Restore all items with given IRI"
 *              }
 *          }
 *     },
 *     itemOperations={
 *          "get"={
 *             "controller"=NotFoundAction::class,
 *             "read"=false,
 *             "output"=false,
 *          }
 *     }
 * )
 */
class Restore
{
    /**
     * @ApiProperty(identifier=true)
     */
    private $id;

    /**
     * @var array<array<string>>
     */
    private array $objectIris;

    public function __construct()
    {
        $this->objectIris = [];
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     * @return Restore
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return \string[][]
     */
    public function getObjectIris(): array
    {
        return $this->objectIris;
    }

    /**
     * @param \string[][] $objectIris
     * @return Restore
     */
    public function setObjectIris(array $objectIris): Restore
    {
        $this->objectIris = $objectIris;
        return $this;
    }

}
