<?php

namespace Webapp\Core\Entity;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\ExistsFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\GroupFilter;
use DateTime;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Gedmo\SoftDeleteable\Traits\SoftDeleteableEntity;
use Shared\Authentication\CustomFilters\DeletedFilter;
use Shared\Authentication\Entity\IdentifiedEntity;
use Shared\Authentication\Entity\Site;
use Shared\Authentication\Entity\User;
use Shared\Enumeration\Annotation\EnumType;
use Shared\RightManagement\Annotation\AdvancedRight;
use Shared\RightManagement\Traits\HasOwnerEntity;
use Symfony\Component\Serializer\Annotation\Groups;
use Symfony\Component\Validator\Constraints as Assert;
use Webapp\Core\Annotation\GraphicallyDeletable;
use Webapp\Core\ApiOperation\RestoreObjectOperation;
use Webapp\Core\Dto\BusinessObject\BusinessObjectCsvOutputDto;
use Webapp\Core\Entity\Attachment\PlatformAttachment;
use Webapp\Core\Enumeration\GraphicalOriginEnum;
use Webapp\Core\Traits\GraphicallyDeletableEntity;
use Webapp\Core\Validator\UniqueAttributeInParent;

/**
 * Class Platform
 * @package Webapp\Core\Entity
 *
 * @ApiResource(
 *     collectionOperations={
 *         "get"={},
 *         "post"={
 *              "security_post_denormalize"="is_granted('ROLE_SITE_ADMIN', object.getSite())",
 *          },
 *     },
 *     itemOperations={
 *          "get"={},
 *          "patch"={
 *              "security"="is_granted('ROLE_SITE_ADMIN', object.getSite())",
 *          },
 *          "delete"={
 *              "security"="is_granted('ROLE_SITE_ADMIN', object.getSite())"
 *          },
 *     }
 * )
 * @ApiFilter(SearchFilter::class, properties={"site": "exact"})
 * @ApiFilter(GroupFilter::class, arguments={"whitelist"={"admin_explorer_view"}})
 *
 * @AdvancedRight(siteAttribute="site")
 *
 * @ORM\Entity()
 * @ORM\Table(name="opensilex_instance", schema="webapp")
 */
class OpenSilexInstance extends IdentifiedEntity
{
    /**
     * @var Site
     *
     * @ORM\ManyToOne(targetEntity="Shared\Authentication\Entity\Site", inversedBy="openSilexInstances")
     * @ORM\JoinColumn(nullable=false)
     * @Groups({"admin_explorer_view"})
     */
    private Site $site;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     * @Groups({"admin_explorer_view"})
     */
    private string $url;

    /**
     * @return Site
     */
    public function getSite(): Site
    {
        return $this->site;
    }

    /**
     * @param Site $site
     */
    public function setSite(Site $site): void
    {
        $this->site = $site;
    }

    /**
     * @return string
     */
    public function getUrl(): string
    {
        return $this->url;
    }

    /**
     * @param string $url
     */
    public function setUrl(string $url): void
    {
        $this->url = $url;
    }

}
