<?php

namespace Mobile\Device\Entity;

use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;

/**
 * Class Modality.
 *
 * @ORM\Entity(repositoryClass="Mobile\Device\Repository\ModalityRepository")
 * @ORM\Table(name="modality", schema="adonis")
 */
class Modality extends IdentifiedEntity
{
    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $value;

    /**
     * @var Factor
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Device\Entity\Factor", inversedBy="modalities")
     * @ORM\JoinColumn(nullable=false)
     */
    private $factor;

    /**
     * @return string
     */
    public function getValue(): string
    {
        return $this->value;
    }

    /**
     * @param string $value
     * @return Modality
     */
    public function setValue(string $value): Modality
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return Factor
     */
    public function getFactor(): Factor
    {
        return $this->factor;
    }

    /**
     * @param Factor $factor
     * @return Modality
     */
    public function setFactor(Factor $factor): Modality
    {
        $this->factor = $factor;
        return $this;
    }
}
