<?php

namespace Mobile\Measure\Entity\Variable;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;

/**
 * Class ValueHintList.
 *
 * @ORM\Entity(repositoryClass="Mobile\Measure\Repository\Variable\ValueHintListRepository")
 * @ORM\Table(name="value_hint_list", schema="adonis")
 */
class ValueHintList extends IdentifiedEntity
{
    /**
     * @var UniqueVariable | null
     *
     * @ORM\OneToOne(targetEntity="Mobile\Measure\Entity\Variable\UniqueVariable", inversedBy="valueHintList")
     * @ORM\JoinColumn(nullable=true, onDelete="CASCADE")
     */
    private $variable;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $name;

    /**
     * @var Collection<array-key, ValueHint>
     *
     * @ORM\OneToMany(targetEntity="Mobile\Measure\Entity\Variable\ValueHint", mappedBy="list", cascade={"persist", "remove", "detach"})
     */
    private $valueHints;

    /**
     * ValueHintList constructor.
     */
    public function __construct()
    {
        $this->valueHints = new ArrayCollection();
    }

    /**
     * @return UniqueVariable|null
     */
    public function getVariable(): ?UniqueVariable
    {
        return $this->variable;
    }

    /**
     * @param UniqueVariable|null $variable
     * @return ValueHintList
     */
    public function setVariable(?UniqueVariable $variable): ValueHintList
    {
        $this->variable = $variable;
        return $this;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return ValueHintList
     */
    public function setName(string $name): ValueHintList
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return Collection<array-key, ValueHint>
     */
    public function getValueHints(): Collection
    {
        return $this->valueHints;
    }

    /**
     * @param ValueHint $valueHint
     */
    public function addValueHint(ValueHint $valueHint): void
    {
        if (!$this->valueHints->contains($valueHint)) {
            $valueHint->setList($this);
            $this->valueHints->add($valueHint);
        }
    }

    /**
     * @param ValueHint $valueHint
     */
    public function removeValueHint(ValueHint $valueHint): void
    {
        if ($this->valueHints->contains($valueHint)) {
            $this->valueHints->removeElement($valueHint);
        }
    }
}
