<?php

namespace Mobile\Project\Entity;

use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;

/**
 * Class Workpath.
 *
 * @ORM\Entity(repositoryClass="Mobile\Project\Repository\WorkpathRepository")
 * @ORM\Table(name="workpath", schema="adonis")
 */
class Workpath extends IdentifiedEntity
{
    /**
     * @var string
     *
     * @ORM\Column(type="text", nullable=false)
     */
    private $path;

    /**
     * @var DataEntryProject
     *
     * @ORM\ManyToOne(targetEntity="Mobile\Project\Entity\DataEntryProject", inversedBy="workpaths")
     * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
     */
    private $dataEntryProject;

    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=false)
     */
    private $username;

    /**
     * @var bool
     *
     * @ORM\Column(type="boolean", nullable=false, options={"default"=false})
     */
    private $startEnd;

    /**
     * Workpath constructor.
     */
    public function __construct()
    {
        $this->startEnd = false;
    }

    /**
     * @return string
     */
    public function getPath(): string
    {
        return $this->path;
    }

    /**
     * @param string $path
     * @return Workpath
     */
    public function setPath(string $path): Workpath
    {
        $this->path = $path;
        return $this;
    }

    /**
     * @return DataEntryProject
     */
    public function getDataEntryProject(): DataEntryProject
    {
        return $this->dataEntryProject;
    }

    /**
     * @param DataEntryProject $dataEntryProject
     * @return Workpath
     */
    public function setDataEntryProject(DataEntryProject $dataEntryProject): Workpath
    {
        $this->dataEntryProject = $dataEntryProject;
        return $this;
    }

    /**
     * @return string
     */
    public function getUsername(): string
    {
        return $this->username;
    }

    /**
     * @param string $username
     * @return Workpath
     */
    public function setUsername(string $username): Workpath
    {
        $this->username = $username;
        return $this;
    }

    /**
     * @return bool
     */
    public function isStartEnd(): bool
    {
        return $this->startEnd;
    }

    /**
     * @param bool $startEnd
     * @return Workpath
     */
    public function setStartEnd(bool $startEnd): Workpath
    {
        $this->startEnd = $startEnd;
        return $this;
    }
}
