<?php

namespace Shared\Application\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use DateTime;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Gedmo\SoftDeleteable\Traits\SoftDeleteableEntity;
use Shared\Application\ApiOperation\CreateFile;
use Shared\Authentication\Entity\IdentifiedEntity;
use Shared\Authentication\Entity\User;
use Shared\RightManagement\Traits\HasOwnerEntity;
use Symfony\Component\Serializer\Annotation\Groups;
use Symfony\Component\Validator\Constraints as Assert;
use Vich\UploaderBundle\Mapping\Annotation as Vich;

/**
 * @ApiResource(
 *     collectionOperations={
 *         "post"={
 *             "controller"=CreateFile::class,
 *             "deserialize"=false,
 *             "access_control"="is_granted('ROLE_USER')",
 *             "validation_groups"={"Default"},
 *             "openapi_context"={
 *                 "requestBody"={
 *                     "content"={
 *                         "multipart/form-data"={
 *                             "schema"={
 *                                 "type"="object",
 *                                 "properties"={
 *                                     "file"={
 *                                         "type"="string",
 *                                         "format"="binary"
 *                                     },
 *                                 }
 *                             }
 *                         }
 *                     }
 *                 }
 *             }
 *         },
 *     },
 *     itemOperations={
 *         "get"={ "is_granted('ROLE_USER') && security"="object.getUser() == user" },
 *     }
 * )
 *
 * @ORM\Entity()
 * @ORM\Table(name="file", schema="shared")
 *
 * @Gedmo\SoftDeleteable()
 * @Vich\Uploadable()
 */
class File extends IdentifiedEntity
{
    use HasOwnerEntity;
    use SoftDeleteableEntity;
    /**
     * @Assert\NotNull()
     * @Assert\File(maxSize="10M")
     * @Vich\UploadableField(mapping="attachments")
     * @var \Symfony\Component\HttpFoundation\File\File|null
     */
    protected $file;

    /**
     * @ORM\Column(type="string")
     *
     * @Groups({"attachment_read"})
     *
     * @var null|string
     */
    private $fileName;

    /**
     * @ORM\Column(type="string")
     *
     * @Groups({"attachment_read"})
     *
     * @var null|string
     */
    private $originalFileName;

    /**
     * @ORM\Column(type="integer")
     *
     * @Groups({"attachment_read"})
     *
     * @var null|int
     */
    private $size;

    /**
     * @ORM\Column(type="date")
     *
     * @Groups({"attachment_read"})
     *
     * @var null|DateTime
     */
    private $date;

    /**
     * @return \Symfony\Component\HttpFoundation\File\File|null
     */
    public function getFile(): ?\Symfony\Component\HttpFoundation\File\File
    {
        return $this->file;
    }

    /**
     * @param \Symfony\Component\HttpFoundation\File\File|null $file
     * @return File
     */
    public function setFile(?\Symfony\Component\HttpFoundation\File\File $file): File
    {
        $this->file = $file;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFileName(): ?string
    {
        return $this->fileName;
    }

    /**
     * @param string|null $fileName
     * @return File
     */
    public function setFileName(?string $fileName): File
    {
        $this->fileName = $fileName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getOriginalFileName(): ?string
    {
        return $this->originalFileName;
    }

    /**
     * @param string|null $originalFileName
     * @return File
     */
    public function setOriginalFileName(?string $originalFileName): File
    {
        $this->originalFileName = $originalFileName;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getSize(): ?int
    {
        return $this->size;
    }

    /**
     * @param int|null $size
     * @return File
     */
    public function setSize(?int $size): File
    {
        $this->size = $size;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getDate(): ?DateTime
    {
        return $this->date;
    }

    /**
     * @param DateTime|null $date
     * @return File
     */
    public function setDate(?DateTime $date): File
    {
        $this->date = $date;
        return $this;
    }

    /**
     * @param User|null $owner
     */
    public function setOwner(?User $owner): File
    {
        $this->owner = $owner;
        return $this;
    }
}
