<?php
/**
 * @author      Aurélien BERNARD - TRYDEA - 2020
 */

declare(strict_types=1);

namespace Webapp\Core\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * Class GeneratedField.
 * @ApiResource(
 *     collectionOperations={
 *     },
 *     itemOperations={
 *          "get"={},
 *     }
 * )
 * @ORM\Entity()
 * @ORM\Table(name="field_generation", schema="webapp")
 */
class FieldGeneration extends IdentifiedEntity
{
    /**
     * @var FieldMeasure
     *
     * @ORM\ManyToOne(targetEntity="FieldMeasure", inversedBy="fieldGenerations")
     * @ORM\JoinColumn(nullable=false)
     */
    private $formField;

    /**
     * @var int
     * @Groups({"webapp_data_view", "data_view_item"})
     * @ORM\Column(type="integer")
     */
    private $index;

    /**
     * @var string
     * @Groups({"webapp_data_view", "data_view_item"})
     * @ORM\Column(type="string")
     */
    private $prefix;

    /**
     * @var bool
     * @Groups({"webapp_data_view", "data_view_item"})
     * @ORM\Column(type="boolean")
     */
    private $numeralIncrement;

    /**
     * @var Collection<array-key, FieldMeasure>
     * @Groups({"webapp_data_view", "data_view_item"})
     * @ORM\OneToMany(targetEntity="Webapp\Core\Entity\FieldMeasure", mappedBy="fieldParent", cascade={"persist", "remove", "detach"})
     */
    private $children;

    /**
     * GeneratedField constructor.
     */
    public function __construct()
    {
        $this->children = new ArrayCollection();
    }

    /**
     * @return FieldMeasure
     */
    public function getFormField(): FieldMeasure
    {
        return $this->formField;
    }

    /**
     * @param FieldMeasure $formField
     * @return FieldGeneration
     */
    public function setFormField(FieldMeasure $formField): FieldGeneration
    {
        $this->formField = $formField;
        return $this;
    }

    /**
     * @return int
     */
    public function getIndex(): int
    {
        return $this->index;
    }

    /**
     * @param int $index
     * @return FieldGeneration
     */
    public function setIndex(int $index): FieldGeneration
    {
        $this->index = $index;
        return $this;
    }

    /**
     * @return string
     */
    public function getPrefix(): string
    {
        return $this->prefix;
    }

    /**
     * @param string $prefix
     * @return FieldGeneration
     */
    public function setPrefix(string $prefix): FieldGeneration
    {
        $this->prefix = $prefix;
        return $this;
    }

    /**
     * @return bool
     */
    public function isNumeralIncrement(): bool
    {
        return $this->numeralIncrement;
    }

    /**
     * @param bool $numeralIncrement
     * @return FieldGeneration
     */
    public function setNumeralIncrement(bool $numeralIncrement): FieldGeneration
    {
        $this->numeralIncrement = $numeralIncrement;
        return $this;
    }

    /**
     * @return Collection<array-key, FieldMeasure>
     */
    public function getChildren(): Collection
    {
        return $this->children;
    }

    /**
     * @param FieldMeasure $formField
     *
     * @return FieldGeneration
     */
    public function addChild(FieldMeasure $formField): FieldGeneration
    {
        if (!$this->children->contains($formField)) {
            $this->children->add($formField);
            $formField->setFieldParent($this);
        }
        return $this;
    }

    /**
     * @param FieldMeasure $child
     *
     * @return FieldGeneration
     */
    public function removeChild(FieldMeasure $child): FieldGeneration
    {
        if ($this->children->contains($child)) {
            $this->children->removeElement($child);
        }
        return $this;
    }
}
