<?php
/**
 * @author      Aurélien BERNARD - TRYDEA - 2020
 */

declare(strict_types=1);

namespace Webapp\Core\Entity;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use Doctrine\ORM\Mapping as ORM;
use Shared\Authentication\Entity\IdentifiedEntity;
use Shared\Authentication\Entity\User;
use Symfony\Component\Serializer\Annotation\Groups;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class PathUserWorkflow
 * @package Webapp\Core\Entity
 *
 * @ApiResource(
 *     collectionOperations={
 *         "get"={},
 *         "post"={}
 *     },
 *     itemOperations={
 *         "get"={},
 *         "patch"={},
 *         "delete"={}
 *     }
 * )
 *
 * @ApiFilter(SearchFilter::class, properties={"pathBase": "exact"})
 *
 * @ORM\Entity
 * @ORM\Table(name="path_user_workflow", schema="webapp")
 */
class PathUserWorkflow extends IdentifiedEntity
{
    /**
     * @var array
     * @ORM\Column(type="simple_array", nullable=true)
     */
    private array $workflow;

    /**
     * @var User
     *
     * @ORM\ManyToOne(targetEntity="Shared\Authentication\Entity\User")
     * @Assert\NotBlank
     */
    private User $user;

    /**
     * @var PathBase
     *
     * @ORM\ManyToOne(targetEntity="Webapp\Core\Entity\PathBase", inversedBy="userPaths")
     * @Assert\NotBlank
     */
    private PathBase $pathBase;

    /**
     * @return array
     */
    public function getWorkflow(): array
    {
        return $this->workflow;
    }

    /**
     * @param array $workflow
     * @return PathUserWorkflow
     */
    public function setWorkflow(array $workflow): PathUserWorkflow
    {
        $this->workflow = $workflow;
        return $this;
    }

    /**
     * @return string
     *
     * @Groups({"project_explorer_view"})
     */
    public function getUsername(): string
    {
        return $this->user->getUsername();
    }

    /**
     * @return User
     */
    public function getUser(): User
    {
        return $this->user;
    }

    /**
     * @param User $user
     * @return PathUserWorkflow
     */
    public function setUser(User $user): PathUserWorkflow
    {
        $this->user = $user;
        return $this;
    }

    /**
     * @return PathBase
     */
    public function getPathBase()
    {
        return $this->pathBase;
    }

    /**
     * @param PathBase $pathBase
     * @return PathUserWorkflow
     */
    public function setPathBase($pathBase)
    {
        $this->pathBase = $pathBase;
        return $this;
    }
}
