<?php

declare(strict_types=1);

namespace Webapp\FileManagement\Worker;

use Doctrine\ORM\EntityManagerInterface;
use Dtc\QueueBundle\Model\Worker;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Throwable;

/**
 * Class AbstractParsingWorker
 * @package Webapp\FileManagement\Worker
 */
abstract class AbstractParsingWorker extends Worker implements LoggerAwareInterface
{
    use LoggerAwareTrait;

    protected EntityManagerInterface $entityManager;

    /**
     * AbstractRequestWorker constructor.
     * @param EntityManagerInterface $entityManager
     */
    public function __construct(
        EntityManagerInterface $entityManager
    )
    {
        $this->entityManager = $entityManager;
    }

    /**
     * @param Throwable $e
     */
    protected function onError(Throwable $e): void
    {
        $this->logger->error($e);
        $this->entityManager->clear();
    }
}
