<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Initialize the database.
 */
final class Version20201029130540 extends AbstractMigration
{
    public function getDescription() : string
    {
        return 'Initialize the database';
    }

    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'postgresql', 'Migration can only be executed safely on \'postgresql\'.');

        $this->addSql('CREATE SCHEMA IF NOT EXISTS adonis');
        $this->addSql('CREATE SEQUENCE adonis.ado_user_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_site_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_user_project_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_file_request_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_file_response_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_project_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_graphical_structure_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_project_object_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_nature_zhe_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_desktop_user_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_platform_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_workpath_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_variable_library_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_device_library_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_device_wrapper_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_protocol_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_treatment_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_out_experimentation_zone_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_modality_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_factor_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_anomaly_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_note_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_driver_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_mark_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_value_hint_list_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_required_metadata_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_scale_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_previous_value_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_variable_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_state_code_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_material_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_value_hint_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_test_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_session_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_field_measure_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_field_generation_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_entry_data_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE adonis.ado_metadata_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE refresh_tokens_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE dtc_queue_job_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE dtc_queue_job_timing_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE dtc_queue_run_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE dtc_queue_run_archive_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE TABLE adonis.ado_user (id INT NOT NULL, username VARCHAR(180) NOT NULL, email VARCHAR(255) NOT NULL, roles JSON NOT NULL, password VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_A1DDC6A7F85E0677 ON adonis.ado_user (username)');
        $this->addSql('CREATE TABLE adonis.rel_user_site (user_id INT NOT NULL, site_id INT NOT NULL, PRIMARY KEY(user_id, site_id))');
        $this->addSql('CREATE INDEX IDX_9C804012A76ED395 ON adonis.rel_user_site (user_id)');
        $this->addSql('CREATE INDEX IDX_9C804012F6BD1646 ON adonis.rel_user_site (site_id)');
        $this->addSql('CREATE TABLE adonis.ado_site (id INT NOT NULL, label VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE adonis.ado_user_project (id INT NOT NULL, user_id INT NOT NULL, request_id INT DEFAULT NULL, response_id INT DEFAULT NULL, status VARCHAR(255) NOT NULL, synchronizable BOOLEAN DEFAULT \'false\' NOT NULL, discr VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_B759CC60A76ED395 ON adonis.ado_user_project (user_id)');
        $this->addSql('CREATE INDEX IDX_B759CC60427EB8A5 ON adonis.ado_user_project (request_id)');
        $this->addSql('CREATE INDEX IDX_B759CC60FBF32840 ON adonis.ado_user_project (response_id)');
        $this->addSql('CREATE TABLE adonis.ado_file_request (id INT NOT NULL, project_id INT DEFAULT NULL, user_id INT NOT NULL, deleted TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, name VARCHAR(255) NOT NULL, lined_error JSON DEFAULT NULL, csv_bindings TEXT DEFAULT NULL, disabled BOOLEAN DEFAULT \'false\' NOT NULL, type VARCHAR(255) NOT NULL, status VARCHAR(255) NOT NULL, file_path VARCHAR(255) DEFAULT NULL, uniq_directory_name TEXT DEFAULT NULL, upload_date TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_A0163420166D1F9C ON adonis.ado_file_request (project_id)');
        $this->addSql('CREATE INDEX IDX_A0163420A76ED395 ON adonis.ado_file_request (user_id)');
        $this->addSql('CREATE TABLE adonis.ado_file_response (id INT NOT NULL, project_id INT NOT NULL, user_id INT NOT NULL, deleted TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, name VARCHAR(255) NOT NULL, type VARCHAR(255) NOT NULL, status VARCHAR(255) NOT NULL, file_path VARCHAR(255) DEFAULT NULL, uniq_directory_name TEXT DEFAULT NULL, upload_date TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_653E245D166D1F9C ON adonis.ado_file_response (project_id)');
        $this->addSql('CREATE INDEX IDX_653E245DA76ED395 ON adonis.ado_file_response (user_id)');
        $this->addSql('CREATE TABLE adonis.ado_project (id INT NOT NULL, creator_id INT DEFAULT NULL, name VARCHAR(255) NOT NULL, creation_date TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, discr VARCHAR(255) NOT NULL, improvised BOOLEAN DEFAULT \'false\', PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_576953AE61220EA6 ON adonis.ado_project (creator_id)');
        $this->addSql('CREATE TABLE adonis.ado_graphical_structure (id INT NOT NULL, project_id INT DEFAULT NULL, platform_color VARCHAR(255) NOT NULL, device_color VARCHAR(255) NOT NULL, block_color VARCHAR(255) NOT NULL, sub_block_color VARCHAR(255) NOT NULL, individual_unit_parcel_color VARCHAR(255) NOT NULL, surface_unit_parcel_color VARCHAR(255) NOT NULL, abnormal_unit_parcel_color VARCHAR(255) NOT NULL, individual_color VARCHAR(255) NOT NULL, abnormal_individual_color VARCHAR(255) NOT NULL, empty_color VARCHAR(255) NOT NULL, tooltip_active BOOLEAN NOT NULL, device_label VARCHAR(255) NOT NULL, block_label VARCHAR(255) NOT NULL, sub_block_label VARCHAR(255) NOT NULL, individual_unit_parcel_label VARCHAR(255) NOT NULL, surface_unit_parcel_label VARCHAR(255) NOT NULL, individual_label VARCHAR(255) NOT NULL, origin VARCHAR(255) DEFAULT NULL, base_width INT DEFAULT NULL, base_height INT DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_F5200720166D1F9C ON adonis.ado_graphical_structure (project_id)');
        $this->addSql('CREATE TABLE adonis.ado_project_object (id INT NOT NULL, discr VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE adonis.ado_nature_zhe (id INT NOT NULL, project_id INT DEFAULT NULL, device_wrapper_id INT DEFAULT NULL, name VARCHAR(255) NOT NULL, color VARCHAR(255) DEFAULT NULL, texture VARCHAR(255) DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_BA0806B3166D1F9C ON adonis.ado_nature_zhe (project_id)');
        $this->addSql('CREATE INDEX IDX_BA0806B35C96AFC5 ON adonis.ado_nature_zhe (device_wrapper_id)');
        $this->addSql('CREATE TABLE adonis.ado_desktop_user (id INT NOT NULL, project_id INT NOT NULL, name VARCHAR(255) NOT NULL, firstname VARCHAR(255) NOT NULL, email VARCHAR(255) NOT NULL, login VARCHAR(255) NOT NULL, password VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_3AFF77EC166D1F9C ON adonis.ado_desktop_user (project_id)');
        $this->addSql('CREATE TABLE adonis.ado_platform (id INT NOT NULL, project_id INT NOT NULL, name VARCHAR(255) NOT NULL, creation_date TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, site VARCHAR(255) NOT NULL, place VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_4FF64BD8166D1F9C ON adonis.ado_platform (project_id)');
        $this->addSql('CREATE TABLE adonis.ado_workpath (id INT NOT NULL, data_entry_project_id INT NOT NULL, path TEXT NOT NULL, username VARCHAR(255) NOT NULL, start_end BOOLEAN DEFAULT \'false\' NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_4AF55E7AD616280 ON adonis.ado_workpath (data_entry_project_id)');
        $this->addSql('CREATE TABLE adonis.ado_variable_library (id INT NOT NULL, user_id INT NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_24807347A76ED395 ON adonis.ado_variable_library (user_id)');
        $this->addSql('CREATE TABLE adonis.ado_device_library (id INT NOT NULL, user_id INT NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_9AD7BDA5A76ED395 ON adonis.ado_device_library (user_id)');
        $this->addSql('CREATE TABLE adonis.ado_device_wrapper (id INT NOT NULL, device_id INT NOT NULL, device_library_id INT DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_F403A1CB94A4C7D4 ON adonis.ado_device_wrapper (device_id)');
        $this->addSql('CREATE INDEX IDX_F403A1CB79160211 ON adonis.ado_device_wrapper (device_library_id)');
        $this->addSql('CREATE TABLE adonis.ado_protocol (id INT NOT NULL, device_id INT NOT NULL, creator_id INT DEFAULT NULL, name VARCHAR(255) NOT NULL, aim VARCHAR(255) NOT NULL, algorithm VARCHAR(255) NOT NULL, creation_date TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, nb_individuals_per_parcel INT DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_BE64275F94A4C7D4 ON adonis.ado_protocol (device_id)');
        $this->addSql('CREATE INDEX IDX_BE64275F61220EA6 ON adonis.ado_protocol (creator_id)');
        $this->addSql('CREATE TABLE adonis.ado_block (id INT NOT NULL, device_id INT NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_C485164D94A4C7D4 ON adonis.ado_block (device_id)');
        $this->addSql('CREATE TABLE adonis.ado_business_object (id INT NOT NULL, anomaly_id INT DEFAULT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_196942D3BAF977BB ON adonis.ado_business_object (anomaly_id)');
        $this->addSql('CREATE TABLE adonis.ado_treatment (id INT NOT NULL, protocol_id INT NOT NULL, name VARCHAR(255) NOT NULL, short_name VARCHAR(255) NOT NULL, repetitions INT NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_1CC9D974CCD59258 ON adonis.ado_treatment (protocol_id)');
        $this->addSql('CREATE TABLE adonis.rel_treatment_modality (treatment_id INT NOT NULL, modality_id INT NOT NULL, PRIMARY KEY(treatment_id, modality_id))');
        $this->addSql('CREATE INDEX IDX_27C903A3471C0366 ON adonis.rel_treatment_modality (treatment_id)');
        $this->addSql('CREATE INDEX IDX_27C903A32D6D889B ON adonis.rel_treatment_modality (modality_id)');
        $this->addSql('CREATE TABLE adonis.ado_sub_bloc (id INT NOT NULL, block_id INT NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_964A9188E9ED820C ON adonis.ado_sub_bloc (block_id)');
        $this->addSql('CREATE TABLE adonis.ado_out_experimentation_zone (id INT NOT NULL, nature_zhe_id INT NOT NULL, device_id INT DEFAULT NULL, block_id INT DEFAULT NULL, sub_block_id INT DEFAULT NULL, unit_parcel_id INT DEFAULT NULL, x INT NOT NULL, y INT NOT NULL, number VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_CF66711813CD0A4C ON adonis.ado_out_experimentation_zone (nature_zhe_id)');
        $this->addSql('CREATE INDEX IDX_CF66711894A4C7D4 ON adonis.ado_out_experimentation_zone (device_id)');
        $this->addSql('CREATE INDEX IDX_CF667118E9ED820C ON adonis.ado_out_experimentation_zone (block_id)');
        $this->addSql('CREATE INDEX IDX_CF66711853426C55 ON adonis.ado_out_experimentation_zone (sub_block_id)');
        $this->addSql('CREATE INDEX IDX_CF667118582AAB8E ON adonis.ado_out_experimentation_zone (unit_parcel_id)');
        $this->addSql('CREATE TABLE adonis.ado_modality (id INT NOT NULL, factor_id INT NOT NULL, value VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_46DD13D3BC88C1A3 ON adonis.ado_modality (factor_id)');
        $this->addSql('CREATE TABLE adonis.ado_factor (id INT NOT NULL, protocol_id INT NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_30720E48CCD59258 ON adonis.ado_factor (protocol_id)');
        $this->addSql('CREATE TABLE adonis.ado_anomaly (id INT NOT NULL, constated_treatment_id INT DEFAULT NULL, description TEXT NOT NULL, type INT NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_8123F623DAF72ACC ON adonis.ado_anomaly (constated_treatment_id)');
        $this->addSql('CREATE TABLE adonis.ado_device (id INT NOT NULL, platform_id INT DEFAULT NULL, individual_pu BOOLEAN NOT NULL, creation_date TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, validation_date TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_D46554C6FFE6496F ON adonis.ado_device (platform_id)');
        $this->addSql('CREATE TABLE adonis.ado_note (id INT NOT NULL, business_object_id INT DEFAULT NULL, creator_id INT DEFAULT NULL, text TEXT DEFAULT \'\' NOT NULL, deleted BOOLEAN NOT NULL, creation_date TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_E3F3EAFA3A495054 ON adonis.ado_note (business_object_id)');
        $this->addSql('CREATE INDEX IDX_E3F3EAFA61220EA6 ON adonis.ado_note (creator_id)');
        $this->addSql('CREATE TABLE adonis.ado_individual (id INT NOT NULL, state_code_id INT DEFAULT NULL, unit_parcel_id INT NOT NULL, x INT NOT NULL, y INT NOT NULL, apparition_date TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, demise_date TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, ident VARCHAR(255) DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_81A181ED61BA84B1 ON adonis.ado_individual (state_code_id)');
        $this->addSql('CREATE INDEX IDX_81A181ED582AAB8E ON adonis.ado_individual (unit_parcel_id)');
        $this->addSql('CREATE TABLE adonis.ado_unit_parcel (id INT NOT NULL, state_code_id INT DEFAULT NULL, sub_block_id INT DEFAULT NULL, block_id INT DEFAULT NULL, treatment_id INT DEFAULT NULL, x INT NOT NULL, y INT NOT NULL, ident VARCHAR(255) DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_3AC9FE961BA84B1 ON adonis.ado_unit_parcel (state_code_id)');
        $this->addSql('CREATE INDEX IDX_3AC9FE953426C55 ON adonis.ado_unit_parcel (sub_block_id)');
        $this->addSql('CREATE INDEX IDX_3AC9FE9E9ED820C ON adonis.ado_unit_parcel (block_id)');
        $this->addSql('CREATE INDEX IDX_3AC9FE9471C0366 ON adonis.ado_unit_parcel (treatment_id)');
        $this->addSql('CREATE TABLE adonis.ado_driver (id INT NOT NULL, type VARCHAR(255) NOT NULL, timeout INT NOT NULL, frame_length INT NOT NULL, frame_start VARCHAR(255) DEFAULT NULL, frame_end VARCHAR(255) DEFAULT NULL, csv_separator VARCHAR(255) DEFAULT NULL, baudrate INT DEFAULT NULL, stopbit DOUBLE PRECISION DEFAULT NULL, parity VARCHAR(255) DEFAULT NULL, flow_control VARCHAR(255) DEFAULT NULL, push BOOLEAN DEFAULT NULL, request VARCHAR(255) DEFAULT NULL, databits_format INT DEFAULT NULL, port VARCHAR(255) DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE adonis.ado_mark (id INT NOT NULL, scale_id INT NOT NULL, text VARCHAR(255) NOT NULL, value INT NOT NULL, image_name TEXT DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_4A3AE29FF73142C2 ON adonis.ado_mark (scale_id)');
        $this->addSql('CREATE TABLE adonis.ado_value_hint_list (id INT NOT NULL, variable_id INT DEFAULT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_F5152880F3037E8E ON adonis.ado_value_hint_list (variable_id)');
        $this->addSql('CREATE TABLE adonis.ado_required_metadata (id INT NOT NULL, data_entry_project_id INT DEFAULT NULL, path_level VARCHAR(255) NOT NULL, type INT NOT NULL, comment TEXT NOT NULL, active BOOLEAN NOT NULL, ask_when_entering BOOLEAN NOT NULL, buisness_objects TEXT NOT NULL, category TEXT NOT NULL, keywords TEXT NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_5D69D831D616280 ON adonis.ado_required_metadata (data_entry_project_id)');
        $this->addSql('COMMENT ON COLUMN adonis.ado_required_metadata.category IS \'(DC2Type:array)\'');
        $this->addSql('COMMENT ON COLUMN adonis.ado_required_metadata.keywords IS \'(DC2Type:array)\'');
        $this->addSql('CREATE TABLE adonis.ado_scale (id INT NOT NULL, variable_id INT DEFAULT NULL, name VARCHAR(255) NOT NULL, min_value INT NOT NULL, max_value INT NOT NULL, exclusive BOOLEAN DEFAULT \'false\' NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_ABD8A4EBF3037E8E ON adonis.ado_scale (variable_id)');
        $this->addSql('CREATE TABLE adonis.ado_previous_value (id INT NOT NULL, variable_id INT NOT NULL, origin_variable_id INT DEFAULT NULL, state_id INT DEFAULT NULL, value VARCHAR(255) DEFAULT NULL, object_uri VARCHAR(255) NOT NULL, date TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_476E5DE7F3037E8E ON adonis.ado_previous_value (variable_id)');
        $this->addSql('CREATE INDEX IDX_476E5DE7FBD798F9 ON adonis.ado_previous_value (origin_variable_id)');
        $this->addSql('CREATE INDEX IDX_476E5DE75D83CC1 ON adonis.ado_previous_value (state_id)');
        $this->addSql('CREATE TABLE adonis.ado_var_generator (id INT NOT NULL, project_id INT DEFAULT NULL, connected_data_entry_project_id INT DEFAULT NULL, generator_variable_id INT DEFAULT NULL, material_id INT DEFAULT NULL, generated_prefix VARCHAR(255) NOT NULL, numeral_increment BOOLEAN NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_8E713CAE166D1F9C ON adonis.ado_var_generator (project_id)');
        $this->addSql('CREATE INDEX IDX_8E713CAEEAD2FD5 ON adonis.ado_var_generator (connected_data_entry_project_id)');
        $this->addSql('CREATE INDEX IDX_8E713CAECE8F2B87 ON adonis.ado_var_generator (generator_variable_id)');
        $this->addSql('CREATE INDEX IDX_8E713CAEE308AC6F ON adonis.ado_var_generator (material_id)');
        $this->addSql('CREATE TABLE adonis.ado_variable (id INT NOT NULL, variable_library_id INT DEFAULT NULL, name VARCHAR(255) NOT NULL, short_name VARCHAR(255) NOT NULL, repetitions INT NOT NULL, unit VARCHAR(255) DEFAULT NULL, ask_timestamp BOOLEAN NOT NULL, path_level VARCHAR(255) NOT NULL, comment TEXT DEFAULT NULL, print_order INT NOT NULL, active BOOLEAN NOT NULL, format VARCHAR(255) DEFAULT NULL, default_value VARCHAR(255) DEFAULT NULL, type VARCHAR(255) NOT NULL, mandatory BOOLEAN NOT NULL, creation_date TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, modification_date TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, start_position INT DEFAULT NULL, end_position INT DEFAULT NULL, discr VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_BAE91C9E27166D67 ON adonis.ado_variable (variable_library_id)');
        $this->addSql('CREATE TABLE adonis.ado_state_code (id INT NOT NULL, project_id INT NOT NULL, code INT NOT NULL, label VARCHAR(255) NOT NULL, description VARCHAR(255) DEFAULT NULL, propagation VARCHAR(255) DEFAULT NULL, color VARCHAR(255) DEFAULT NULL, type VARCHAR(255) DEFAULT \'non_permanent\' NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_E5C4C4A4166D1F9C ON adonis.ado_state_code (project_id)');
        $this->addSql('CREATE TABLE adonis.ado_material (id INT NOT NULL, driver_id INT DEFAULT NULL, project_id INT NOT NULL, name VARCHAR(255) NOT NULL, physical_device VARCHAR(255) NOT NULL, manufacturer VARCHAR(255) DEFAULT NULL, type VARCHAR(255) DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_A1AEE86C3423909 ON adonis.ado_material (driver_id)');
        $this->addSql('CREATE INDEX IDX_A1AEE86166D1F9C ON adonis.ado_material (project_id)');
        $this->addSql('CREATE TABLE adonis.ado_var_unique (id INT NOT NULL, project_id INT DEFAULT NULL, connected_data_entry_project_id INT DEFAULT NULL, generator_variable_id INT DEFAULT NULL, material_id INT DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_6F7F8DD3166D1F9C ON adonis.ado_var_unique (project_id)');
        $this->addSql('CREATE INDEX IDX_6F7F8DD3EAD2FD5 ON adonis.ado_var_unique (connected_data_entry_project_id)');
        $this->addSql('CREATE INDEX IDX_6F7F8DD3CE8F2B87 ON adonis.ado_var_unique (generator_variable_id)');
        $this->addSql('CREATE INDEX IDX_6F7F8DD3E308AC6F ON adonis.ado_var_unique (material_id)');
        $this->addSql('CREATE TABLE adonis.ado_value_hint (id INT NOT NULL, list_id INT NOT NULL, value VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_9B1B25703DAE168B ON adonis.ado_value_hint (list_id)');
        $this->addSql('CREATE TABLE adonis.ado_test (id INT NOT NULL, name VARCHAR(255) NOT NULL, active BOOLEAN NOT NULL, discr VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE adonis.ado_test_combination (id INT NOT NULL, variable_id INT NOT NULL, first_operand_id INT NOT NULL, second_operand_id INT NOT NULL, operator VARCHAR(255) NOT NULL, high_limit DOUBLE PRECISION NOT NULL, low_limit DOUBLE PRECISION NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_6A93F388F3037E8E ON adonis.ado_test_combination (variable_id)');
        $this->addSql('CREATE INDEX IDX_6A93F388894F9321 ON adonis.ado_test_combination (first_operand_id)');
        $this->addSql('CREATE INDEX IDX_6A93F388FB8912B5 ON adonis.ado_test_combination (second_operand_id)');
        $this->addSql('CREATE TABLE adonis.ado_test_growth (id INT NOT NULL, variable_id INT NOT NULL, comparison_variable_id INT NOT NULL, min_diff DOUBLE PRECISION NOT NULL, max_diff DOUBLE PRECISION NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_D757CFA7F3037E8E ON adonis.ado_test_growth (variable_id)');
        $this->addSql('CREATE INDEX IDX_D757CFA7AE1AE982 ON adonis.ado_test_growth (comparison_variable_id)');
        $this->addSql('CREATE TABLE adonis.ado_test_preconditioned (id INT NOT NULL, variable_id INT NOT NULL, comparison_variable_id INT NOT NULL, compared_variable_id INT DEFAULT NULL, condition VARCHAR(255) NOT NULL, compared_value DOUBLE PRECISION DEFAULT NULL, affectation_value VARCHAR(255) DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_B3D549C9F3037E8E ON adonis.ado_test_preconditioned (variable_id)');
        $this->addSql('CREATE INDEX IDX_B3D549C9AE1AE982 ON adonis.ado_test_preconditioned (comparison_variable_id)');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_B3D549C9FE13CFD8 ON adonis.ado_test_preconditioned (compared_variable_id)');
        $this->addSql('CREATE TABLE adonis.ado_test_range (id INT NOT NULL, variable_id INT NOT NULL, mandatory_min_value DOUBLE PRECISION NOT NULL, mandatory_max_value DOUBLE PRECISION NOT NULL, optional_min_value DOUBLE PRECISION NOT NULL, optional_max_value DOUBLE PRECISION NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_9E6B81B8F3037E8E ON adonis.ado_test_range (variable_id)');
        $this->addSql('CREATE TABLE adonis.ado_session (id INT NOT NULL, data_entry_id INT NOT NULL, started_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, ended_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_A89E569470E8809E ON adonis.ado_session (data_entry_id)');
        $this->addSql('CREATE TABLE adonis.ado_field_measure (id INT NOT NULL, session_id INT DEFAULT NULL, generated_field_id INT DEFAULT NULL, variable_id INT NOT NULL, target_id INT NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_84369CBE613FECDF ON adonis.ado_field_measure (session_id)');
        $this->addSql('CREATE INDEX IDX_84369CBE4963009 ON adonis.ado_field_measure (generated_field_id)');
        $this->addSql('CREATE INDEX IDX_84369CBEF3037E8E ON adonis.ado_field_measure (variable_id)');
        $this->addSql('CREATE INDEX IDX_84369CBE158E0B66 ON adonis.ado_field_measure (target_id)');
        $this->addSql('CREATE TABLE adonis.ado_field_generation (id INT NOT NULL, form_field_id INT NOT NULL, index INT NOT NULL, prefix VARCHAR(255) NOT NULL, numeral_increment BOOLEAN NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_354A571AF50D82F4 ON adonis.ado_field_generation (form_field_id)');
        $this->addSql('CREATE TABLE adonis.ado_measure (id INT NOT NULL, form_field_id INT NOT NULL, state_id INT DEFAULT NULL, value VARCHAR(255) DEFAULT NULL, timestamp TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_F8DD9A65F50D82F4 ON adonis.ado_measure (form_field_id)');
        $this->addSql('CREATE INDEX IDX_F8DD9A655D83CC1 ON adonis.ado_measure (state_id)');
        $this->addSql('CREATE TABLE adonis.ado_entry_data (id INT NOT NULL, project_id INT NOT NULL, status VARCHAR(255) NOT NULL, started_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, ended_at TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, current_position VARCHAR(255) DEFAULT NULL, workpath JSON DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_FE3F68A166D1F9C ON adonis.ado_entry_data (project_id)');
        $this->addSql('CREATE TABLE adonis.ado_metadata (id INT NOT NULL, project_object_id INT NOT NULL, name VARCHAR(255) DEFAULT NULL, type INT NOT NULL, value VARCHAR(255) DEFAULT NULL, image TEXT DEFAULT NULL, timestamp TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, categories TEXT NOT NULL, keywords TEXT NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_39B0AF07321113FC ON adonis.ado_metadata (project_object_id)');
        $this->addSql('COMMENT ON COLUMN adonis.ado_metadata.categories IS \'(DC2Type:array)\'');
        $this->addSql('COMMENT ON COLUMN adonis.ado_metadata.keywords IS \'(DC2Type:array)\'');
        $this->addSql('CREATE TABLE refresh_tokens (id INT NOT NULL, refresh_token VARCHAR(128) NOT NULL, username VARCHAR(255) NOT NULL, valid TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_9BACE7E1C74F2195 ON refresh_tokens (refresh_token)');
        $this->addSql('CREATE TABLE dtc_queue_job (id BIGINT NOT NULL, worker_name VARCHAR(255) NOT NULL, class_name VARCHAR(255) NOT NULL, method VARCHAR(255) NOT NULL, status VARCHAR(255) NOT NULL, args TEXT NOT NULL, priority INT DEFAULT NULL, crc_hash VARCHAR(255) NOT NULL, when_us NUMERIC(18, 0) DEFAULT NULL, expires_at TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, started_at TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, finished_at TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, elapsed DOUBLE PRECISION DEFAULT NULL, message TEXT DEFAULT NULL, created_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, updated_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, max_duration INT DEFAULT NULL, run_id BIGINT DEFAULT NULL, stalls INT NOT NULL, max_stalls INT DEFAULT NULL, exceptions INT NOT NULL, max_exceptions INT DEFAULT NULL, failures INT NOT NULL, max_failures INT DEFAULT NULL, retries INT NOT NULL, max_retries INT DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX job_crc_hash_idx ON dtc_queue_job (crc_hash, status)');
        $this->addSql('CREATE INDEX job_priority_idx ON dtc_queue_job (priority, when_us)');
        $this->addSql('CREATE INDEX job_when_idx ON dtc_queue_job (when_us)');
        $this->addSql('CREATE INDEX job_status_idx ON dtc_queue_job (status, when_us)');
        $this->addSql('CREATE TABLE dtc_queue_job_archive (id BIGINT NOT NULL, finished_at TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, elapsed DOUBLE PRECISION DEFAULT NULL, started_at TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, when_us NUMERIC(18, 0) DEFAULT NULL, priority INT DEFAULT NULL, expires_at TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, updated_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, worker_name VARCHAR(255) NOT NULL, class_name VARCHAR(255) NOT NULL, method VARCHAR(255) NOT NULL, status VARCHAR(255) NOT NULL, args TEXT NOT NULL, crc_hash VARCHAR(255) NOT NULL, message TEXT DEFAULT NULL, created_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, max_duration INT DEFAULT NULL, run_id BIGINT DEFAULT NULL, stalls INT NOT NULL, max_stalls INT DEFAULT NULL, exceptions INT NOT NULL, max_exceptions INT DEFAULT NULL, failures INT NOT NULL, max_failures INT DEFAULT NULL, retries INT NOT NULL, max_retries INT DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX job_archive_status_idx ON dtc_queue_job_archive (status)');
        $this->addSql('CREATE INDEX job_archive_updated_at_idx ON dtc_queue_job_archive (updated_at)');
        $this->addSql('CREATE TABLE dtc_queue_job_timing (id BIGINT NOT NULL, finished_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, status INT NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX job_timing_finished_at ON dtc_queue_job_timing (status, finished_at)');
        $this->addSql('CREATE TABLE dtc_queue_run (id BIGINT NOT NULL, started_at TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, ended_at TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, elapsed DOUBLE PRECISION DEFAULT NULL, duration INT DEFAULT NULL, last_heartbeat_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, max_count INT DEFAULT NULL, processed INT NOT NULL, hostname VARCHAR(255) DEFAULT NULL, pid INT DEFAULT NULL, process_timeout INT DEFAULT NULL, current_job_id VARCHAR(255) DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX run_last_heart_beat ON dtc_queue_run (last_heartbeat_at)');
        $this->addSql('CREATE TABLE dtc_queue_run_archive (id BIGINT NOT NULL, started_at TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, duration INT DEFAULT NULL, ended_at TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, elapsed DOUBLE PRECISION DEFAULT NULL, max_count INT DEFAULT NULL, last_heartbeat_at TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, process_timeout INT DEFAULT NULL, current_job_id VARCHAR(255) DEFAULT NULL, processed INT NOT NULL, hostname VARCHAR(255) DEFAULT NULL, pid INT DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX run_archive_ended_at_idx ON dtc_queue_run_archive (ended_at)');
        $this->addSql('ALTER TABLE adonis.rel_user_site ADD CONSTRAINT FK_9C804012A76ED395 FOREIGN KEY (user_id) REFERENCES adonis.ado_user (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.rel_user_site ADD CONSTRAINT FK_9C804012F6BD1646 FOREIGN KEY (site_id) REFERENCES adonis.ado_site (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_user_project ADD CONSTRAINT FK_B759CC60A76ED395 FOREIGN KEY (user_id) REFERENCES adonis.ado_user (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_user_project ADD CONSTRAINT FK_B759CC60427EB8A5 FOREIGN KEY (request_id) REFERENCES adonis.ado_project (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_user_project ADD CONSTRAINT FK_B759CC60FBF32840 FOREIGN KEY (response_id) REFERENCES adonis.ado_project (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_file_request ADD CONSTRAINT FK_A0163420166D1F9C FOREIGN KEY (project_id) REFERENCES adonis.ado_project (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_file_request ADD CONSTRAINT FK_A0163420A76ED395 FOREIGN KEY (user_id) REFERENCES adonis.ado_user (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_file_response ADD CONSTRAINT FK_653E245D166D1F9C FOREIGN KEY (project_id) REFERENCES adonis.ado_project (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_file_response ADD CONSTRAINT FK_653E245DA76ED395 FOREIGN KEY (user_id) REFERENCES adonis.ado_user (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_project ADD CONSTRAINT FK_576953AE61220EA6 FOREIGN KEY (creator_id) REFERENCES adonis.ado_desktop_user (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_graphical_structure ADD CONSTRAINT FK_F5200720166D1F9C FOREIGN KEY (project_id) REFERENCES adonis.ado_project (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_nature_zhe ADD CONSTRAINT FK_BA0806B3166D1F9C FOREIGN KEY (project_id) REFERENCES adonis.ado_project (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_nature_zhe ADD CONSTRAINT FK_BA0806B35C96AFC5 FOREIGN KEY (device_wrapper_id) REFERENCES adonis.ado_device_wrapper (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_desktop_user ADD CONSTRAINT FK_3AFF77EC166D1F9C FOREIGN KEY (project_id) REFERENCES adonis.ado_project (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_platform ADD CONSTRAINT FK_4FF64BD8166D1F9C FOREIGN KEY (project_id) REFERENCES adonis.ado_project (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_workpath ADD CONSTRAINT FK_4AF55E7AD616280 FOREIGN KEY (data_entry_project_id) REFERENCES adonis.ado_project (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_variable_library ADD CONSTRAINT FK_24807347A76ED395 FOREIGN KEY (user_id) REFERENCES adonis.ado_user (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_device_library ADD CONSTRAINT FK_9AD7BDA5A76ED395 FOREIGN KEY (user_id) REFERENCES adonis.ado_user (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_device_wrapper ADD CONSTRAINT FK_F403A1CB94A4C7D4 FOREIGN KEY (device_id) REFERENCES adonis.ado_device (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_device_wrapper ADD CONSTRAINT FK_F403A1CB79160211 FOREIGN KEY (device_library_id) REFERENCES adonis.ado_device_library (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_protocol ADD CONSTRAINT FK_BE64275F94A4C7D4 FOREIGN KEY (device_id) REFERENCES adonis.ado_device (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_protocol ADD CONSTRAINT FK_BE64275F61220EA6 FOREIGN KEY (creator_id) REFERENCES adonis.ado_desktop_user (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_block ADD CONSTRAINT FK_C485164D94A4C7D4 FOREIGN KEY (device_id) REFERENCES adonis.ado_device (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_block ADD CONSTRAINT FK_C485164DBF396750 FOREIGN KEY (id) REFERENCES adonis.ado_project_object (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_business_object ADD CONSTRAINT FK_196942D3BAF977BB FOREIGN KEY (anomaly_id) REFERENCES adonis.ado_anomaly (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_business_object ADD CONSTRAINT FK_196942D3BF396750 FOREIGN KEY (id) REFERENCES adonis.ado_project_object (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_treatment ADD CONSTRAINT FK_1CC9D974CCD59258 FOREIGN KEY (protocol_id) REFERENCES adonis.ado_protocol (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.rel_treatment_modality ADD CONSTRAINT FK_27C903A3471C0366 FOREIGN KEY (treatment_id) REFERENCES adonis.ado_treatment (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.rel_treatment_modality ADD CONSTRAINT FK_27C903A32D6D889B FOREIGN KEY (modality_id) REFERENCES adonis.ado_modality (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_sub_bloc ADD CONSTRAINT FK_964A9188E9ED820C FOREIGN KEY (block_id) REFERENCES adonis.ado_block (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_sub_bloc ADD CONSTRAINT FK_964A9188BF396750 FOREIGN KEY (id) REFERENCES adonis.ado_project_object (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_out_experimentation_zone ADD CONSTRAINT FK_CF66711813CD0A4C FOREIGN KEY (nature_zhe_id) REFERENCES adonis.ado_nature_zhe (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_out_experimentation_zone ADD CONSTRAINT FK_CF66711894A4C7D4 FOREIGN KEY (device_id) REFERENCES adonis.ado_device (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_out_experimentation_zone ADD CONSTRAINT FK_CF667118E9ED820C FOREIGN KEY (block_id) REFERENCES adonis.ado_block (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_out_experimentation_zone ADD CONSTRAINT FK_CF66711853426C55 FOREIGN KEY (sub_block_id) REFERENCES adonis.ado_sub_bloc (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_out_experimentation_zone ADD CONSTRAINT FK_CF667118582AAB8E FOREIGN KEY (unit_parcel_id) REFERENCES adonis.ado_unit_parcel (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_modality ADD CONSTRAINT FK_46DD13D3BC88C1A3 FOREIGN KEY (factor_id) REFERENCES adonis.ado_factor (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_factor ADD CONSTRAINT FK_30720E48CCD59258 FOREIGN KEY (protocol_id) REFERENCES adonis.ado_protocol (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_anomaly ADD CONSTRAINT FK_8123F623DAF72ACC FOREIGN KEY (constated_treatment_id) REFERENCES adonis.ado_treatment (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_device ADD CONSTRAINT FK_D46554C6FFE6496F FOREIGN KEY (platform_id) REFERENCES adonis.ado_platform (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_device ADD CONSTRAINT FK_D46554C6BF396750 FOREIGN KEY (id) REFERENCES adonis.ado_project_object (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_note ADD CONSTRAINT FK_E3F3EAFA3A495054 FOREIGN KEY (business_object_id) REFERENCES adonis.ado_business_object (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_note ADD CONSTRAINT FK_E3F3EAFA61220EA6 FOREIGN KEY (creator_id) REFERENCES adonis.ado_user (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_individual ADD CONSTRAINT FK_81A181ED61BA84B1 FOREIGN KEY (state_code_id) REFERENCES adonis.ado_state_code (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_individual ADD CONSTRAINT FK_81A181ED582AAB8E FOREIGN KEY (unit_parcel_id) REFERENCES adonis.ado_unit_parcel (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_individual ADD CONSTRAINT FK_81A181EDBF396750 FOREIGN KEY (id) REFERENCES adonis.ado_project_object (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_unit_parcel ADD CONSTRAINT FK_3AC9FE961BA84B1 FOREIGN KEY (state_code_id) REFERENCES adonis.ado_state_code (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_unit_parcel ADD CONSTRAINT FK_3AC9FE953426C55 FOREIGN KEY (sub_block_id) REFERENCES adonis.ado_sub_bloc (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_unit_parcel ADD CONSTRAINT FK_3AC9FE9E9ED820C FOREIGN KEY (block_id) REFERENCES adonis.ado_block (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_unit_parcel ADD CONSTRAINT FK_3AC9FE9471C0366 FOREIGN KEY (treatment_id) REFERENCES adonis.ado_treatment (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_unit_parcel ADD CONSTRAINT FK_3AC9FE9BF396750 FOREIGN KEY (id) REFERENCES adonis.ado_project_object (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_mark ADD CONSTRAINT FK_4A3AE29FF73142C2 FOREIGN KEY (scale_id) REFERENCES adonis.ado_scale (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_value_hint_list ADD CONSTRAINT FK_F5152880F3037E8E FOREIGN KEY (variable_id) REFERENCES adonis.ado_var_unique (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_required_metadata ADD CONSTRAINT FK_5D69D831D616280 FOREIGN KEY (data_entry_project_id) REFERENCES adonis.ado_project (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_scale ADD CONSTRAINT FK_ABD8A4EBF3037E8E FOREIGN KEY (variable_id) REFERENCES adonis.ado_variable (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_previous_value ADD CONSTRAINT FK_476E5DE7F3037E8E FOREIGN KEY (variable_id) REFERENCES adonis.ado_variable (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_previous_value ADD CONSTRAINT FK_476E5DE7FBD798F9 FOREIGN KEY (origin_variable_id) REFERENCES adonis.ado_variable (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_previous_value ADD CONSTRAINT FK_476E5DE75D83CC1 FOREIGN KEY (state_id) REFERENCES adonis.ado_state_code (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_var_generator ADD CONSTRAINT FK_8E713CAE166D1F9C FOREIGN KEY (project_id) REFERENCES adonis.ado_project (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_var_generator ADD CONSTRAINT FK_8E713CAEEAD2FD5 FOREIGN KEY (connected_data_entry_project_id) REFERENCES adonis.ado_project (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_var_generator ADD CONSTRAINT FK_8E713CAECE8F2B87 FOREIGN KEY (generator_variable_id) REFERENCES adonis.ado_var_generator (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_var_generator ADD CONSTRAINT FK_8E713CAEE308AC6F FOREIGN KEY (material_id) REFERENCES adonis.ado_material (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_var_generator ADD CONSTRAINT FK_8E713CAEBF396750 FOREIGN KEY (id) REFERENCES adonis.ado_variable (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_variable ADD CONSTRAINT FK_BAE91C9E27166D67 FOREIGN KEY (variable_library_id) REFERENCES adonis.ado_variable_library (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_state_code ADD CONSTRAINT FK_E5C4C4A4166D1F9C FOREIGN KEY (project_id) REFERENCES adonis.ado_project (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_material ADD CONSTRAINT FK_A1AEE86C3423909 FOREIGN KEY (driver_id) REFERENCES adonis.ado_driver (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_material ADD CONSTRAINT FK_A1AEE86166D1F9C FOREIGN KEY (project_id) REFERENCES adonis.ado_project (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_var_unique ADD CONSTRAINT FK_6F7F8DD3166D1F9C FOREIGN KEY (project_id) REFERENCES adonis.ado_project (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_var_unique ADD CONSTRAINT FK_6F7F8DD3EAD2FD5 FOREIGN KEY (connected_data_entry_project_id) REFERENCES adonis.ado_project (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_var_unique ADD CONSTRAINT FK_6F7F8DD3CE8F2B87 FOREIGN KEY (generator_variable_id) REFERENCES adonis.ado_var_generator (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_var_unique ADD CONSTRAINT FK_6F7F8DD3E308AC6F FOREIGN KEY (material_id) REFERENCES adonis.ado_material (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_var_unique ADD CONSTRAINT FK_6F7F8DD3BF396750 FOREIGN KEY (id) REFERENCES adonis.ado_variable (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_value_hint ADD CONSTRAINT FK_9B1B25703DAE168B FOREIGN KEY (list_id) REFERENCES adonis.ado_value_hint_list (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_test_combination ADD CONSTRAINT FK_6A93F388F3037E8E FOREIGN KEY (variable_id) REFERENCES adonis.ado_variable (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_test_combination ADD CONSTRAINT FK_6A93F388894F9321 FOREIGN KEY (first_operand_id) REFERENCES adonis.ado_variable (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_test_combination ADD CONSTRAINT FK_6A93F388FB8912B5 FOREIGN KEY (second_operand_id) REFERENCES adonis.ado_variable (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_test_combination ADD CONSTRAINT FK_6A93F388BF396750 FOREIGN KEY (id) REFERENCES adonis.ado_test (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_test_growth ADD CONSTRAINT FK_D757CFA7F3037E8E FOREIGN KEY (variable_id) REFERENCES adonis.ado_variable (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_test_growth ADD CONSTRAINT FK_D757CFA7AE1AE982 FOREIGN KEY (comparison_variable_id) REFERENCES adonis.ado_variable (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_test_growth ADD CONSTRAINT FK_D757CFA7BF396750 FOREIGN KEY (id) REFERENCES adonis.ado_test (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_test_preconditioned ADD CONSTRAINT FK_B3D549C9F3037E8E FOREIGN KEY (variable_id) REFERENCES adonis.ado_variable (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_test_preconditioned ADD CONSTRAINT FK_B3D549C9AE1AE982 FOREIGN KEY (comparison_variable_id) REFERENCES adonis.ado_variable (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_test_preconditioned ADD CONSTRAINT FK_B3D549C9FE13CFD8 FOREIGN KEY (compared_variable_id) REFERENCES adonis.ado_variable (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_test_preconditioned ADD CONSTRAINT FK_B3D549C9BF396750 FOREIGN KEY (id) REFERENCES adonis.ado_test (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_test_range ADD CONSTRAINT FK_9E6B81B8F3037E8E FOREIGN KEY (variable_id) REFERENCES adonis.ado_variable (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_test_range ADD CONSTRAINT FK_9E6B81B8BF396750 FOREIGN KEY (id) REFERENCES adonis.ado_test (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_session ADD CONSTRAINT FK_A89E569470E8809E FOREIGN KEY (data_entry_id) REFERENCES adonis.ado_entry_data (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_field_measure ADD CONSTRAINT FK_84369CBE613FECDF FOREIGN KEY (session_id) REFERENCES adonis.ado_session (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_field_measure ADD CONSTRAINT FK_84369CBE4963009 FOREIGN KEY (generated_field_id) REFERENCES adonis.ado_field_generation (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_field_measure ADD CONSTRAINT FK_84369CBEF3037E8E FOREIGN KEY (variable_id) REFERENCES adonis.ado_variable (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_field_measure ADD CONSTRAINT FK_84369CBE158E0B66 FOREIGN KEY (target_id) REFERENCES adonis.ado_business_object (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_field_generation ADD CONSTRAINT FK_354A571AF50D82F4 FOREIGN KEY (form_field_id) REFERENCES adonis.ado_field_measure (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_measure ADD CONSTRAINT FK_F8DD9A65F50D82F4 FOREIGN KEY (form_field_id) REFERENCES adonis.ado_field_measure (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_measure ADD CONSTRAINT FK_F8DD9A655D83CC1 FOREIGN KEY (state_id) REFERENCES adonis.ado_state_code (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_measure ADD CONSTRAINT FK_F8DD9A65BF396750 FOREIGN KEY (id) REFERENCES adonis.ado_project_object (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_entry_data ADD CONSTRAINT FK_FE3F68A166D1F9C FOREIGN KEY (project_id) REFERENCES adonis.ado_project (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE adonis.ado_metadata ADD CONSTRAINT FK_39B0AF07321113FC FOREIGN KEY (project_object_id) REFERENCES adonis.ado_project_object (id) ON DELETE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE');
    }

    public function down(Schema $schema) : void
    {
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'postgresql', 'Migration can only be executed safely on \'postgresql\'.');

        $this->addSql('ALTER TABLE adonis.rel_user_site DROP CONSTRAINT FK_9C804012A76ED395');
        $this->addSql('ALTER TABLE adonis.ado_user_project DROP CONSTRAINT FK_B759CC60A76ED395');
        $this->addSql('ALTER TABLE adonis.ado_file_request DROP CONSTRAINT FK_A0163420A76ED395');
        $this->addSql('ALTER TABLE adonis.ado_file_response DROP CONSTRAINT FK_653E245DA76ED395');
        $this->addSql('ALTER TABLE adonis.ado_variable_library DROP CONSTRAINT FK_24807347A76ED395');
        $this->addSql('ALTER TABLE adonis.ado_device_library DROP CONSTRAINT FK_9AD7BDA5A76ED395');
        $this->addSql('ALTER TABLE adonis.ado_note DROP CONSTRAINT FK_E3F3EAFA61220EA6');
        $this->addSql('ALTER TABLE adonis.rel_user_site DROP CONSTRAINT FK_9C804012F6BD1646');
        $this->addSql('ALTER TABLE adonis.ado_user_project DROP CONSTRAINT FK_B759CC60427EB8A5');
        $this->addSql('ALTER TABLE adonis.ado_user_project DROP CONSTRAINT FK_B759CC60FBF32840');
        $this->addSql('ALTER TABLE adonis.ado_file_request DROP CONSTRAINT FK_A0163420166D1F9C');
        $this->addSql('ALTER TABLE adonis.ado_file_response DROP CONSTRAINT FK_653E245D166D1F9C');
        $this->addSql('ALTER TABLE adonis.ado_graphical_structure DROP CONSTRAINT FK_F5200720166D1F9C');
        $this->addSql('ALTER TABLE adonis.ado_nature_zhe DROP CONSTRAINT FK_BA0806B3166D1F9C');
        $this->addSql('ALTER TABLE adonis.ado_desktop_user DROP CONSTRAINT FK_3AFF77EC166D1F9C');
        $this->addSql('ALTER TABLE adonis.ado_platform DROP CONSTRAINT FK_4FF64BD8166D1F9C');
        $this->addSql('ALTER TABLE adonis.ado_workpath DROP CONSTRAINT FK_4AF55E7AD616280');
        $this->addSql('ALTER TABLE adonis.ado_required_metadata DROP CONSTRAINT FK_5D69D831D616280');
        $this->addSql('ALTER TABLE adonis.ado_var_generator DROP CONSTRAINT FK_8E713CAE166D1F9C');
        $this->addSql('ALTER TABLE adonis.ado_var_generator DROP CONSTRAINT FK_8E713CAEEAD2FD5');
        $this->addSql('ALTER TABLE adonis.ado_state_code DROP CONSTRAINT FK_E5C4C4A4166D1F9C');
        $this->addSql('ALTER TABLE adonis.ado_material DROP CONSTRAINT FK_A1AEE86166D1F9C');
        $this->addSql('ALTER TABLE adonis.ado_var_unique DROP CONSTRAINT FK_6F7F8DD3166D1F9C');
        $this->addSql('ALTER TABLE adonis.ado_var_unique DROP CONSTRAINT FK_6F7F8DD3EAD2FD5');
        $this->addSql('ALTER TABLE adonis.ado_entry_data DROP CONSTRAINT FK_FE3F68A166D1F9C');
        $this->addSql('ALTER TABLE adonis.ado_block DROP CONSTRAINT FK_C485164DBF396750');
        $this->addSql('ALTER TABLE adonis.ado_business_object DROP CONSTRAINT FK_196942D3BF396750');
        $this->addSql('ALTER TABLE adonis.ado_sub_bloc DROP CONSTRAINT FK_964A9188BF396750');
        $this->addSql('ALTER TABLE adonis.ado_device DROP CONSTRAINT FK_D46554C6BF396750');
        $this->addSql('ALTER TABLE adonis.ado_individual DROP CONSTRAINT FK_81A181EDBF396750');
        $this->addSql('ALTER TABLE adonis.ado_unit_parcel DROP CONSTRAINT FK_3AC9FE9BF396750');
        $this->addSql('ALTER TABLE adonis.ado_measure DROP CONSTRAINT FK_F8DD9A65BF396750');
        $this->addSql('ALTER TABLE adonis.ado_metadata DROP CONSTRAINT FK_39B0AF07321113FC');
        $this->addSql('ALTER TABLE adonis.ado_out_experimentation_zone DROP CONSTRAINT FK_CF66711813CD0A4C');
        $this->addSql('ALTER TABLE adonis.ado_project DROP CONSTRAINT FK_576953AE61220EA6');
        $this->addSql('ALTER TABLE adonis.ado_protocol DROP CONSTRAINT FK_BE64275F61220EA6');
        $this->addSql('ALTER TABLE adonis.ado_device DROP CONSTRAINT FK_D46554C6FFE6496F');
        $this->addSql('ALTER TABLE adonis.ado_variable DROP CONSTRAINT FK_BAE91C9E27166D67');
        $this->addSql('ALTER TABLE adonis.ado_device_wrapper DROP CONSTRAINT FK_F403A1CB79160211');
        $this->addSql('ALTER TABLE adonis.ado_nature_zhe DROP CONSTRAINT FK_BA0806B35C96AFC5');
        $this->addSql('ALTER TABLE adonis.ado_treatment DROP CONSTRAINT FK_1CC9D974CCD59258');
        $this->addSql('ALTER TABLE adonis.ado_factor DROP CONSTRAINT FK_30720E48CCD59258');
        $this->addSql('ALTER TABLE adonis.ado_sub_bloc DROP CONSTRAINT FK_964A9188E9ED820C');
        $this->addSql('ALTER TABLE adonis.ado_out_experimentation_zone DROP CONSTRAINT FK_CF667118E9ED820C');
        $this->addSql('ALTER TABLE adonis.ado_unit_parcel DROP CONSTRAINT FK_3AC9FE9E9ED820C');
        $this->addSql('ALTER TABLE adonis.ado_note DROP CONSTRAINT FK_E3F3EAFA3A495054');
        $this->addSql('ALTER TABLE adonis.ado_field_measure DROP CONSTRAINT FK_84369CBE158E0B66');
        $this->addSql('ALTER TABLE adonis.rel_treatment_modality DROP CONSTRAINT FK_27C903A3471C0366');
        $this->addSql('ALTER TABLE adonis.ado_anomaly DROP CONSTRAINT FK_8123F623DAF72ACC');
        $this->addSql('ALTER TABLE adonis.ado_unit_parcel DROP CONSTRAINT FK_3AC9FE9471C0366');
        $this->addSql('ALTER TABLE adonis.ado_out_experimentation_zone DROP CONSTRAINT FK_CF66711853426C55');
        $this->addSql('ALTER TABLE adonis.ado_unit_parcel DROP CONSTRAINT FK_3AC9FE953426C55');
        $this->addSql('ALTER TABLE adonis.rel_treatment_modality DROP CONSTRAINT FK_27C903A32D6D889B');
        $this->addSql('ALTER TABLE adonis.ado_modality DROP CONSTRAINT FK_46DD13D3BC88C1A3');
        $this->addSql('ALTER TABLE adonis.ado_business_object DROP CONSTRAINT FK_196942D3BAF977BB');
        $this->addSql('ALTER TABLE adonis.ado_device_wrapper DROP CONSTRAINT FK_F403A1CB94A4C7D4');
        $this->addSql('ALTER TABLE adonis.ado_protocol DROP CONSTRAINT FK_BE64275F94A4C7D4');
        $this->addSql('ALTER TABLE adonis.ado_block DROP CONSTRAINT FK_C485164D94A4C7D4');
        $this->addSql('ALTER TABLE adonis.ado_out_experimentation_zone DROP CONSTRAINT FK_CF66711894A4C7D4');
        $this->addSql('ALTER TABLE adonis.ado_out_experimentation_zone DROP CONSTRAINT FK_CF667118582AAB8E');
        $this->addSql('ALTER TABLE adonis.ado_individual DROP CONSTRAINT FK_81A181ED582AAB8E');
        $this->addSql('ALTER TABLE adonis.ado_material DROP CONSTRAINT FK_A1AEE86C3423909');
        $this->addSql('ALTER TABLE adonis.ado_value_hint DROP CONSTRAINT FK_9B1B25703DAE168B');
        $this->addSql('ALTER TABLE adonis.ado_mark DROP CONSTRAINT FK_4A3AE29FF73142C2');
        $this->addSql('ALTER TABLE adonis.ado_var_generator DROP CONSTRAINT FK_8E713CAECE8F2B87');
        $this->addSql('ALTER TABLE adonis.ado_var_unique DROP CONSTRAINT FK_6F7F8DD3CE8F2B87');
        $this->addSql('ALTER TABLE adonis.ado_scale DROP CONSTRAINT FK_ABD8A4EBF3037E8E');
        $this->addSql('ALTER TABLE adonis.ado_previous_value DROP CONSTRAINT FK_476E5DE7F3037E8E');
        $this->addSql('ALTER TABLE adonis.ado_previous_value DROP CONSTRAINT FK_476E5DE7FBD798F9');
        $this->addSql('ALTER TABLE adonis.ado_var_generator DROP CONSTRAINT FK_8E713CAEBF396750');
        $this->addSql('ALTER TABLE adonis.ado_var_unique DROP CONSTRAINT FK_6F7F8DD3BF396750');
        $this->addSql('ALTER TABLE adonis.ado_test_combination DROP CONSTRAINT FK_6A93F388F3037E8E');
        $this->addSql('ALTER TABLE adonis.ado_test_combination DROP CONSTRAINT FK_6A93F388894F9321');
        $this->addSql('ALTER TABLE adonis.ado_test_combination DROP CONSTRAINT FK_6A93F388FB8912B5');
        $this->addSql('ALTER TABLE adonis.ado_test_growth DROP CONSTRAINT FK_D757CFA7F3037E8E');
        $this->addSql('ALTER TABLE adonis.ado_test_growth DROP CONSTRAINT FK_D757CFA7AE1AE982');
        $this->addSql('ALTER TABLE adonis.ado_test_preconditioned DROP CONSTRAINT FK_B3D549C9F3037E8E');
        $this->addSql('ALTER TABLE adonis.ado_test_preconditioned DROP CONSTRAINT FK_B3D549C9AE1AE982');
        $this->addSql('ALTER TABLE adonis.ado_test_preconditioned DROP CONSTRAINT FK_B3D549C9FE13CFD8');
        $this->addSql('ALTER TABLE adonis.ado_test_range DROP CONSTRAINT FK_9E6B81B8F3037E8E');
        $this->addSql('ALTER TABLE adonis.ado_field_measure DROP CONSTRAINT FK_84369CBEF3037E8E');
        $this->addSql('ALTER TABLE adonis.ado_individual DROP CONSTRAINT FK_81A181ED61BA84B1');
        $this->addSql('ALTER TABLE adonis.ado_unit_parcel DROP CONSTRAINT FK_3AC9FE961BA84B1');
        $this->addSql('ALTER TABLE adonis.ado_previous_value DROP CONSTRAINT FK_476E5DE75D83CC1');
        $this->addSql('ALTER TABLE adonis.ado_measure DROP CONSTRAINT FK_F8DD9A655D83CC1');
        $this->addSql('ALTER TABLE adonis.ado_var_generator DROP CONSTRAINT FK_8E713CAEE308AC6F');
        $this->addSql('ALTER TABLE adonis.ado_var_unique DROP CONSTRAINT FK_6F7F8DD3E308AC6F');
        $this->addSql('ALTER TABLE adonis.ado_value_hint_list DROP CONSTRAINT FK_F5152880F3037E8E');
        $this->addSql('ALTER TABLE adonis.ado_test_combination DROP CONSTRAINT FK_6A93F388BF396750');
        $this->addSql('ALTER TABLE adonis.ado_test_growth DROP CONSTRAINT FK_D757CFA7BF396750');
        $this->addSql('ALTER TABLE adonis.ado_test_preconditioned DROP CONSTRAINT FK_B3D549C9BF396750');
        $this->addSql('ALTER TABLE adonis.ado_test_range DROP CONSTRAINT FK_9E6B81B8BF396750');
        $this->addSql('ALTER TABLE adonis.ado_field_measure DROP CONSTRAINT FK_84369CBE613FECDF');
        $this->addSql('ALTER TABLE adonis.ado_field_generation DROP CONSTRAINT FK_354A571AF50D82F4');
        $this->addSql('ALTER TABLE adonis.ado_measure DROP CONSTRAINT FK_F8DD9A65F50D82F4');
        $this->addSql('ALTER TABLE adonis.ado_field_measure DROP CONSTRAINT FK_84369CBE4963009');
        $this->addSql('ALTER TABLE adonis.ado_session DROP CONSTRAINT FK_A89E569470E8809E');
        $this->addSql('DROP SEQUENCE adonis.ado_user_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_site_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_user_project_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_file_request_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_file_response_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_project_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_graphical_structure_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_project_object_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_nature_zhe_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_desktop_user_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_platform_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_workpath_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_variable_library_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_device_library_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_device_wrapper_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_protocol_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_treatment_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_out_experimentation_zone_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_modality_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_factor_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_anomaly_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_note_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_driver_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_mark_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_value_hint_list_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_required_metadata_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_scale_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_previous_value_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_variable_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_state_code_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_material_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_value_hint_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_test_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_session_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_field_measure_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_field_generation_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_entry_data_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE adonis.ado_metadata_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE refresh_tokens_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE dtc_queue_job_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE dtc_queue_job_timing_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE dtc_queue_run_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE dtc_queue_run_archive_id_seq CASCADE');
        $this->addSql('DROP TABLE adonis.ado_user');
        $this->addSql('DROP TABLE adonis.rel_user_site');
        $this->addSql('DROP TABLE adonis.ado_site');
        $this->addSql('DROP TABLE adonis.ado_user_project');
        $this->addSql('DROP TABLE adonis.ado_file_request');
        $this->addSql('DROP TABLE adonis.ado_file_response');
        $this->addSql('DROP TABLE adonis.ado_project');
        $this->addSql('DROP TABLE adonis.ado_graphical_structure');
        $this->addSql('DROP TABLE adonis.ado_project_object');
        $this->addSql('DROP TABLE adonis.ado_nature_zhe');
        $this->addSql('DROP TABLE adonis.ado_desktop_user');
        $this->addSql('DROP TABLE adonis.ado_platform');
        $this->addSql('DROP TABLE adonis.ado_workpath');
        $this->addSql('DROP TABLE adonis.ado_variable_library');
        $this->addSql('DROP TABLE adonis.ado_device_library');
        $this->addSql('DROP TABLE adonis.ado_device_wrapper');
        $this->addSql('DROP TABLE adonis.ado_protocol');
        $this->addSql('DROP TABLE adonis.ado_block');
        $this->addSql('DROP TABLE adonis.ado_business_object');
        $this->addSql('DROP TABLE adonis.ado_treatment');
        $this->addSql('DROP TABLE adonis.rel_treatment_modality');
        $this->addSql('DROP TABLE adonis.ado_sub_bloc');
        $this->addSql('DROP TABLE adonis.ado_out_experimentation_zone');
        $this->addSql('DROP TABLE adonis.ado_modality');
        $this->addSql('DROP TABLE adonis.ado_factor');
        $this->addSql('DROP TABLE adonis.ado_anomaly');
        $this->addSql('DROP TABLE adonis.ado_device');
        $this->addSql('DROP TABLE adonis.ado_note');
        $this->addSql('DROP TABLE adonis.ado_individual');
        $this->addSql('DROP TABLE adonis.ado_unit_parcel');
        $this->addSql('DROP TABLE adonis.ado_driver');
        $this->addSql('DROP TABLE adonis.ado_mark');
        $this->addSql('DROP TABLE adonis.ado_value_hint_list');
        $this->addSql('DROP TABLE adonis.ado_required_metadata');
        $this->addSql('DROP TABLE adonis.ado_scale');
        $this->addSql('DROP TABLE adonis.ado_previous_value');
        $this->addSql('DROP TABLE adonis.ado_var_generator');
        $this->addSql('DROP TABLE adonis.ado_variable');
        $this->addSql('DROP TABLE adonis.ado_state_code');
        $this->addSql('DROP TABLE adonis.ado_material');
        $this->addSql('DROP TABLE adonis.ado_var_unique');
        $this->addSql('DROP TABLE adonis.ado_value_hint');
        $this->addSql('DROP TABLE adonis.ado_test');
        $this->addSql('DROP TABLE adonis.ado_test_combination');
        $this->addSql('DROP TABLE adonis.ado_test_growth');
        $this->addSql('DROP TABLE adonis.ado_test_preconditioned');
        $this->addSql('DROP TABLE adonis.ado_test_range');
        $this->addSql('DROP TABLE adonis.ado_session');
        $this->addSql('DROP TABLE adonis.ado_field_measure');
        $this->addSql('DROP TABLE adonis.ado_field_generation');
        $this->addSql('DROP TABLE adonis.ado_measure');
        $this->addSql('DROP TABLE adonis.ado_entry_data');
        $this->addSql('DROP TABLE adonis.ado_metadata');
        $this->addSql('DROP TABLE refresh_tokens');
        $this->addSql('DROP TABLE dtc_queue_job');
        $this->addSql('DROP TABLE dtc_queue_job_archive');
        $this->addSql('DROP TABLE dtc_queue_job_timing');
        $this->addSql('DROP TABLE dtc_queue_run');
        $this->addSql('DROP TABLE dtc_queue_run_archive');
    }
}
