<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20210713120419 extends AbstractMigration
{
    public function getDescription(): string
    {
        return 'Performs schema and table name change to a clearer structure';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'postgresql', 'Migration can only be executed safely on \'postgresql\'.');

        $this->addSql('ALTER TABLE webapp.rel_user_project_status SET SCHEMA shared');
        $this->addSql('ALTER TABLE adonis.ado_user SET SCHEMA shared');
        $this->addSql('ALTER TABLE adonis.ado_site SET SCHEMA shared');
        $this->addSql('ALTER TABLE adonis.rel_user_site SET SCHEMA shared');
        $this->addSql('ALTER TABLE adonis.ado_file_request SET SCHEMA webapp');
        $this->addSql('ALTER TABLE webapp.ado_file_request RENAME TO file_request');
        $this->addSql('ALTER TABLE adonis.ado_file_response SET SCHEMA webapp');
        $this->addSql('ALTER TABLE webapp.ado_file_response RENAME TO file_response');

        $this->addSql('ALTER SEQUENCE webapp.rel_user_project_status_id_seq SET SCHEMA shared');
        $this->addSql('ALTER SEQUENCE adonis.ado_user_id_seq SET SCHEMA shared');
        $this->addSql('ALTER SEQUENCE adonis.ado_site_id_seq SET SCHEMA shared');
        $this->addSql('ALTER SEQUENCE adonis.ado_file_request_id_seq SET SCHEMA webapp');
        $this->addSql('ALTER SEQUENCE webapp.ado_file_request_id_seq RENAME TO file_request_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_file_response_id_seq SET SCHEMA webapp');
        $this->addSql('ALTER SEQUENCE webapp.ado_file_response_id_seq RENAME TO file_response_id_seq');

        $this->addSql('ALTER TABLE adonis.ado_anomaly RENAME TO anomaly');
        $this->addSql('ALTER TABLE adonis.ado_block RENAME TO block');
        $this->addSql('ALTER TABLE adonis.ado_business_object RENAME TO business_object');
        $this->addSql('ALTER TABLE adonis.ado_desktop_user RENAME TO desktop_user');
        $this->addSql('ALTER TABLE adonis.ado_device RENAME TO experiment');
        $this->addSql('ALTER TABLE adonis.ado_device_library RENAME TO experiment_library');
        $this->addSql('ALTER TABLE adonis.ado_device_wrapper RENAME TO experiment_wrapper');
        $this->addSql('ALTER TABLE adonis.ado_driver RENAME TO driver');
        $this->addSql('ALTER TABLE adonis.ado_entry_data RENAME TO data_entry');
        $this->addSql('ALTER TABLE adonis.ado_factor RENAME TO factor');
        $this->addSql('ALTER TABLE adonis.ado_field_generation RENAME TO field_generation');
        $this->addSql('ALTER TABLE adonis.ado_field_measure RENAME TO field_measure');
        $this->addSql('ALTER TABLE adonis.ado_graphical_structure RENAME TO graphical_structure');
        $this->addSql('ALTER TABLE adonis.ado_individual RENAME TO individual');
        $this->addSql('ALTER TABLE adonis.ado_mark RENAME TO mark');
        $this->addSql('ALTER TABLE adonis.ado_material RENAME TO material');
        $this->addSql('ALTER TABLE adonis.ado_measure RENAME TO measure');
        $this->addSql('ALTER TABLE adonis.ado_metadata RENAME TO metadata');
        $this->addSql('ALTER TABLE adonis.ado_modality RENAME TO modality');
        $this->addSql('ALTER TABLE adonis.ado_nature_zhe RENAME TO nature_zhe');
        $this->addSql('ALTER TABLE adonis.ado_note RENAME TO note');
        $this->addSql('ALTER TABLE adonis.ado_out_experimentation_zone RENAME TO out_experimentation_zone');
        $this->addSql('ALTER TABLE adonis.ado_platform RENAME TO platform');
        $this->addSql('ALTER TABLE adonis.ado_previous_value RENAME TO previous_value');
        $this->addSql('ALTER TABLE adonis.ado_project RENAME TO project');
        $this->addSql('ALTER TABLE adonis.ado_project_object RENAME TO project_object');
        $this->addSql('ALTER TABLE adonis.ado_protocol RENAME TO protocol');
        $this->addSql('ALTER TABLE adonis.ado_required_metadata RENAME TO required_metadata');
        $this->addSql('ALTER TABLE adonis.ado_scale RENAME TO scale_data');
        $this->addSql('ALTER TABLE adonis.ado_session RENAME TO session_data');
        $this->addSql('ALTER TABLE adonis.ado_state_code RENAME TO state_code');
        $this->addSql('ALTER TABLE adonis.ado_sub_bloc RENAME TO sub_block');
        $this->addSql('ALTER TABLE adonis.ado_test RENAME TO test');
        $this->addSql('ALTER TABLE adonis.ado_test_combination RENAME TO test_combination');
        $this->addSql('ALTER TABLE adonis.ado_test_growth RENAME TO test_growth');
        $this->addSql('ALTER TABLE adonis.ado_test_preconditioned RENAME TO test_preconditioned');
        $this->addSql('ALTER TABLE adonis.ado_test_range RENAME TO test_range');
        $this->addSql('ALTER TABLE adonis.ado_treatment RENAME TO treatment');
        $this->addSql('ALTER TABLE adonis.ado_unit_parcel RENAME TO unit_plot');
        $this->addSql('ALTER TABLE adonis.ado_value_hint RENAME TO value_hint');
        $this->addSql('ALTER TABLE adonis.ado_value_hint_list RENAME TO value_hint_list');
        $this->addSql('ALTER TABLE adonis.ado_var_generator RENAME TO variable_generator');
        $this->addSql('ALTER TABLE adonis.ado_var_unique RENAME TO variable_unique');
        $this->addSql('ALTER TABLE adonis.ado_variable RENAME TO variable');
        $this->addSql('ALTER TABLE adonis.ado_variable_library RENAME TO variable_library');
        $this->addSql('ALTER TABLE adonis.ado_workpath RENAME TO workpath');

        $this->addSql('ALTER SEQUENCE adonis.ado_anomaly_id_seq RENAME TO anomaly_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_desktop_user_id_seq RENAME TO desktop_user_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_device_library_id_seq RENAME TO experiment_library_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_device_wrapper_id_seq RENAME TO experiment_wrapper_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_driver_id_seq RENAME TO driver_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_entry_data_id_seq RENAME TO data_entry_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_factor_id_seq RENAME TO factor_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_field_generation_id_seq RENAME TO field_generation_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_field_measure_id_seq RENAME TO field_measure_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_graphical_structure_id_seq RENAME TO graphical_structure_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_mark_id_seq RENAME TO mark_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_material_id_seq RENAME TO material_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_metadata_id_seq RENAME TO metadata_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_modality_id_seq RENAME TO modality_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_nature_zhe_id_seq RENAME TO nature_zhe_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_note_id_seq RENAME TO note_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_out_experimentation_zone_id_seq RENAME TO out_experimentation_zone_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_platform_id_seq RENAME TO platform_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_previous_value_id_seq RENAME TO previous_value_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_project_id_seq RENAME TO project_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_project_object_id_seq RENAME TO project_object_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_protocol_id_seq RENAME TO protocol_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_required_metadata_id_seq RENAME TO required_metadata_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_scale_id_seq RENAME TO scale_data_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_session_id_seq RENAME TO session_data_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_state_code_id_seq RENAME TO state_code_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_test_id_seq RENAME TO test_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_treatment_id_seq RENAME TO treatment_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_value_hint_id_seq RENAME TO value_hint_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_value_hint_list_id_seq RENAME TO value_hint_list_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_variable_id_seq RENAME TO variable_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_variable_library_id_seq RENAME TO variable_library_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.ado_workpath_id_seq RENAME TO workpath_id_seq');

        $this->addSql('ALTER INDEX shared.uniq_450d190aea750e8 RENAME TO UNIQ_BF800262EA750E8');
        $this->addSql('ALTER INDEX shared.uniq_a1ddc6a7f85e0677 RENAME TO UNIQ_5B50DDCFF85E0677');
        $this->addSql('ALTER INDEX adonis.idx_8123f623daf72acc RENAME TO IDX_3AF2E3C4DAF72ACC');
        $this->addSql('ALTER INDEX adonis.idx_c485164d94a4c7d4 RENAME TO IDX_F6D9732694A4C7D4');
        $this->addSql('ALTER INDEX adonis.uniq_196942d3baf977bb RENAME TO UNIQ_1BEF2B4DBAF977BB');
        $this->addSql('ALTER INDEX adonis.uniq_fe3f68a166d1f9c RENAME TO UNIQ_960EEDD166D1F9C');
        $this->addSql('ALTER INDEX adonis.idx_3aff77ec166d1f9c RENAME TO IDX_4CB6E3FA166D1F9C');
        $this->addSql('ALTER INDEX adonis.idx_d46554c6ffe6496f RENAME TO IDX_7F91E780FFE6496F');
        $this->addSql('ALTER INDEX adonis.uniq_9ad7bda5a76ed395 RENAME TO UNIQ_ED4CD67AA76ED395');
        $this->addSql('ALTER INDEX adonis.uniq_f403a1cb94a4c7d4 RENAME TO UNIQ_8398CA1494A4C7D4');
        $this->addSql('ALTER INDEX adonis.idx_f403a1cb79160211 RENAME TO IDX_8398CA1479160211');
        $this->addSql('ALTER INDEX adonis.idx_30720e48ccd59258 RENAME TO IDX_EA20EAFDCCD59258');
        $this->addSql('ALTER INDEX adonis.idx_354a571af50d82f4 RENAME TO IDX_22FF6F30F50D82F4');
        $this->addSql('ALTER INDEX adonis.idx_84369cbe613fecdf RENAME TO IDX_7094607B613FECDF');
        $this->addSql('ALTER INDEX adonis.idx_84369cbe4963009 RENAME TO IDX_7094607B4963009');
        $this->addSql('ALTER INDEX adonis.idx_84369cbef3037e8e RENAME TO IDX_7094607BF3037E8E');
        $this->addSql('ALTER INDEX adonis.idx_84369cbe158e0b66 RENAME TO IDX_7094607B158E0B66');
        $this->addSql('ALTER INDEX webapp.uniq_a0163420166d1f9c RENAME TO UNIQ_65B64F1D166D1F9C');
        $this->addSql('ALTER INDEX webapp.idx_a0163420a76ed395 RENAME TO IDX_65B64F1DA76ED395');
        $this->addSql('ALTER INDEX webapp.uniq_653e245d166d1f9c RENAME TO UNIQ_3D93C837166D1F9C');
        $this->addSql('ALTER INDEX webapp.idx_653e245da76ed395 RENAME TO IDX_3D93C837A76ED395');
        $this->addSql('ALTER INDEX adonis.uniq_f5200720166d1f9c RENAME TO UNIQ_6C6E3FF9166D1F9C');
        $this->addSql('ALTER INDEX adonis.idx_81a181ed61ba84b1 RENAME TO IDX_EB6D432561BA84B1');
        $this->addSql('ALTER INDEX adonis.idx_81a181ed582aab8e RENAME TO IDX_EB6D4325582AAB8E');
        $this->addSql('ALTER INDEX adonis.idx_4a3ae29ff73142c2 RENAME TO IDX_CE336AB3F73142C2');
        $this->addSql('ALTER INDEX adonis.uniq_a1aee86c3423909 RENAME TO UNIQ_34CF4848C3423909');
        $this->addSql('ALTER INDEX adonis.idx_a1aee86166d1f9c RENAME TO IDX_34CF4848166D1F9C');
        $this->addSql('ALTER INDEX adonis.idx_f8dd9a65f50d82f4 RENAME TO IDX_430C8F82F50D82F4');
        $this->addSql('ALTER INDEX adonis.idx_f8dd9a655d83cc1 RENAME TO IDX_430C8F825D83CC1');
        $this->addSql('ALTER INDEX adonis.idx_39b0af07321113fc RENAME TO IDX_76509C9321113FC');
        $this->addSql('ALTER INDEX adonis.idx_46dd13d3bc88c1a3 RENAME TO IDX_7808B51DBC88C1A3');
        $this->addSql('ALTER INDEX adonis.idx_ba0806b3166d1f9c RENAME TO IDX_D0C4C47B166D1F9C');
        $this->addSql('ALTER INDEX adonis.idx_ba0806b35c96afc5 RENAME TO IDX_D0C4C47B5C96AFC5');
        $this->addSql('ALTER INDEX adonis.idx_e3f3eafa3a495054 RENAME TO IDX_67FA62D63A495054');
        $this->addSql('ALTER INDEX adonis.idx_e3f3eafa61220ea6 RENAME TO IDX_67FA62D661220EA6');
        $this->addSql('ALTER INDEX adonis.idx_cf66711813cd0a4c RENAME TO IDX_A49B2DE713CD0A4C');
        $this->addSql('ALTER INDEX adonis.idx_cf66711894a4c7d4 RENAME TO IDX_A49B2DE794A4C7D4');
        $this->addSql('ALTER INDEX adonis.idx_cf667118e9ed820c RENAME TO IDX_A49B2DE7E9ED820C');
        $this->addSql('ALTER INDEX adonis.idx_cf66711853426c55 RENAME TO IDX_A49B2DE753426C55');
        $this->addSql('ALTER INDEX adonis.idx_cf667118582aab8e RENAME TO IDX_A49B2DE7582AAB8E');
        $this->addSql('ALTER INDEX adonis.uniq_4ff64bd8166d1f9c RENAME TO UNIQ_7123ED16166D1F9C');
        $this->addSql('ALTER INDEX adonis.idx_476e5de7f3037e8e RENAME TO IDX_AC94C924F3037E8E');
        $this->addSql('ALTER INDEX adonis.idx_476e5de7fbd798f9 RENAME TO IDX_AC94C924FBD798F9');
        $this->addSql('ALTER INDEX adonis.idx_476e5de75d83cc1 RENAME TO IDX_AC94C9245D83CC1');
        $this->addSql('ALTER INDEX adonis.idx_576953ae61220ea6 RENAME TO IDX_ECB8464961220EA6');
        $this->addSql('ALTER INDEX adonis.uniq_be64275f94a4c7d4 RENAME TO UNIQ_80B1819194A4C7D4');
        $this->addSql('ALTER INDEX adonis.idx_be64275f61220ea6 RENAME TO IDX_80B1819161220EA6');
        $this->addSql('ALTER INDEX shared.idx_b759cc60a76ed395 RENAME TO IDX_2C695F87A76ED395');
        $this->addSql('ALTER INDEX shared.idx_b759cc60427eb8a5 RENAME TO IDX_2C695F87427EB8A5');
        $this->addSql('ALTER INDEX shared.idx_b759cc60fbf32840 RENAME TO IDX_2C695F87FBF32840');
        $this->addSql('ALTER INDEX shared.idx_9c804012a76ed395 RENAME TO IDX_B5642DE4A76ED395');
        $this->addSql('ALTER INDEX shared.idx_9c804012f6bd1646 RENAME TO IDX_B5642DE4F6BD1646');
        $this->addSql('ALTER INDEX adonis.idx_5d69d831d616280 RENAME TO IDX_86C5A4DFD616280');
        $this->addSql('ALTER INDEX adonis.uniq_abd8a4ebf3037e8e RENAME TO UNIQ_C97E3886F3037E8E');
        $this->addSql('ALTER INDEX adonis.idx_a89e569470e8809e RENAME TO IDX_DD2C65DB70E8809E');
        $this->addSql('ALTER INDEX adonis.idx_e5c4c4a4166d1f9c RENAME TO IDX_8F08066C166D1F9C');
        $this->addSql('ALTER INDEX adonis.idx_964a9188e9ed820c RENAME TO IDX_97752CCFE9ED820C');
        $this->addSql('ALTER INDEX adonis.idx_6a93f388f3037e8e RENAME TO IDX_7D26CBA2F3037E8E');
        $this->addSql('ALTER INDEX adonis.idx_6a93f388894f9321 RENAME TO IDX_7D26CBA2894F9321');
        $this->addSql('ALTER INDEX adonis.idx_6a93f388fb8912b5 RENAME TO IDX_7D26CBA2FB8912B5');
        $this->addSql('ALTER INDEX adonis.idx_d757cfa7f3037e8e RENAME TO IDX_428249E7F3037E8E');
        $this->addSql('ALTER INDEX adonis.idx_d757cfa7ae1ae982 RENAME TO IDX_428249E7AE1AE982');
        $this->addSql('ALTER INDEX adonis.idx_b3d549c9f3037e8e RENAME TO IDX_2A9B7110F3037E8E');
        $this->addSql('ALTER INDEX adonis.idx_b3d549c9ae1ae982 RENAME TO IDX_2A9B7110AE1AE982');
        $this->addSql('ALTER INDEX adonis.uniq_b3d549c9fe13cfd8 RENAME TO UNIQ_2A9B7110FE13CFD8');
        $this->addSql('ALTER INDEX adonis.idx_9e6b81b8f3037e8e RENAME TO IDX_F4A74370F3037E8E');
        $this->addSql('ALTER INDEX adonis.idx_1cc9d974ccd59258 RENAME TO IDX_602BE365CCD59258');
        $this->addSql('ALTER INDEX adonis.idx_3ac9fe961ba84b1 RENAME TO IDX_CA57B18761BA84B1');
        $this->addSql('ALTER INDEX adonis.idx_3ac9fe953426c55 RENAME TO IDX_CA57B18753426C55');
        $this->addSql('ALTER INDEX adonis.idx_3ac9fe9e9ed820c RENAME TO IDX_CA57B187E9ED820C');
        $this->addSql('ALTER INDEX adonis.idx_3ac9fe9471c0366 RENAME TO IDX_CA57B187471C0366');
        $this->addSql('ALTER INDEX adonis.idx_9b1b25703dae168b RENAME TO IDX_F1D7E7B83DAE168B');
        $this->addSql('ALTER INDEX adonis.uniq_f5152880f3037e8e RENAME TO UNIQ_F793411EF3037E8E');
        $this->addSql('ALTER INDEX adonis.idx_bae91c9e27166d67 RENAME TO IDX_843CBA5027166D67');
        $this->addSql('ALTER INDEX adonis.idx_8e713cae166d1f9c RENAME TO IDX_4D579EF5166D1F9C');
        $this->addSql('ALTER INDEX adonis.idx_8e713caeead2fd5 RENAME TO IDX_4D579EF5EAD2FD5');
        $this->addSql('ALTER INDEX adonis.idx_8e713caece8f2b87 RENAME TO IDX_4D579EF5CE8F2B87');
        $this->addSql('ALTER INDEX adonis.idx_8e713caee308ac6f RENAME TO IDX_4D579EF5E308AC6F');
        $this->addSql('ALTER INDEX adonis.uniq_24807347a76ed395 RENAME TO UNIQ_33354B6DA76ED395');
        $this->addSql('ALTER INDEX adonis.idx_6f7f8dd3166d1f9c RENAME TO IDX_D7FF1CBB166D1F9C');
        $this->addSql('ALTER INDEX adonis.idx_6f7f8dd3ead2fd5 RENAME TO IDX_D7FF1CBBEAD2FD5');
        $this->addSql('ALTER INDEX adonis.idx_6f7f8dd3ce8f2b87 RENAME TO IDX_D7FF1CBBCE8F2B87');
        $this->addSql('ALTER INDEX adonis.idx_6f7f8dd3e308ac6f RENAME TO IDX_D7FF1CBBE308AC6F');
        $this->addSql('ALTER INDEX adonis.idx_4af55e7ad616280 RENAME TO IDX_7420F8B4D616280');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'postgresql', 'Migration can only be executed safely on \'postgresql\'.');

        $this->addSql('ALTER TABLE shared.rel_user_project_status SET SCHEMA webapp');
        $this->addSql('ALTER TABLE shared.ado_user SET SCHEMA adonis');
        $this->addSql('ALTER TABLE shared.ado_site SET SCHEMA adonis');
        $this->addSql('ALTER TABLE shared.rel_user_site SET SCHEMA adonis');
        $this->addSql('ALTER TABLE webapp.file_request SET SCHEMA adonis');
        $this->addSql('ALTER TABLE adonis.file_request RENAME TO ado_file_request');
        $this->addSql('ALTER TABLE webapp.file_response SET SCHEMA adonis');
        $this->addSql('ALTER TABLE adonis.file_response RENAME TO ado_file_response');

        $this->addSql('ALTER SEQUENCE shared.rel_user_project_status_id_seq SET SCHEMA webapp');
        $this->addSql('ALTER SEQUENCE shared.ado_user_id_seq SET SCHEMA adonis');
        $this->addSql('ALTER SEQUENCE shared.ado_site_id_seq SET SCHEMA adonis');
        $this->addSql('ALTER SEQUENCE webapp.file_request_id_seq SET SCHEMA adonis');
        $this->addSql('ALTER SEQUENCE adonis.file_request_id_seq RENAME TO ado_file_request_id_seq');
        $this->addSql('ALTER SEQUENCE webapp.file_response_id_seq SET SCHEMA adonis');
        $this->addSql('ALTER SEQUENCE adonis.file_response_id_seq RENAME TO ado_file_response_id_seq');

        $this->addSql('ALTER TABLE adonis.anomaly RENAME TO ado_anomaly');
        $this->addSql('ALTER TABLE adonis.block RENAME TO ado_block');
        $this->addSql('ALTER TABLE adonis.business_object RENAME TO ado_business_object');
        $this->addSql('ALTER TABLE adonis.desktop_user RENAME TO ado_desktop_user');
        $this->addSql('ALTER TABLE adonis.experiment RENAME TO ado_device');
        $this->addSql('ALTER TABLE adonis.experiment_library RENAME TO ado_device_library');
        $this->addSql('ALTER TABLE adonis.experiment_wrapper RENAME TO ado_device_wrapper');
        $this->addSql('ALTER TABLE adonis.driver RENAME TO ado_driver');
        $this->addSql('ALTER TABLE adonis.data_entry RENAME TO ado_entry_data');
        $this->addSql('ALTER TABLE adonis.factor RENAME TO ado_factor');
        $this->addSql('ALTER TABLE adonis.field_generation RENAME TO ado_field_generation');
        $this->addSql('ALTER TABLE adonis.field_measure RENAME TO ado_field_measure');
        $this->addSql('ALTER TABLE adonis.graphical_structure RENAME TO ado_graphical_structure');
        $this->addSql('ALTER TABLE adonis.individual RENAME TO ado_individual');
        $this->addSql('ALTER TABLE adonis.mark RENAME TO ado_mark');
        $this->addSql('ALTER TABLE adonis.material RENAME TO ado_material');
        $this->addSql('ALTER TABLE adonis.measure RENAME TO ado_measure');
        $this->addSql('ALTER TABLE adonis.metadata RENAME TO ado_metadata');
        $this->addSql('ALTER TABLE adonis.modality RENAME TO ado_modality');
        $this->addSql('ALTER TABLE adonis.nature_zhe RENAME TO ado_nature_zhe');
        $this->addSql('ALTER TABLE adonis.note RENAME TO ado_note');
        $this->addSql('ALTER TABLE adonis.out_experimentation_zone RENAME TO ado_out_experimentation_zone');
        $this->addSql('ALTER TABLE adonis.platform RENAME TO ado_platform');
        $this->addSql('ALTER TABLE adonis.previous_value RENAME TO ado_previous_value');
        $this->addSql('ALTER TABLE adonis.project RENAME TO ado_project');
        $this->addSql('ALTER TABLE adonis.project_object RENAME TO ado_project_object');
        $this->addSql('ALTER TABLE adonis.protocol RENAME TO ado_protocol');
        $this->addSql('ALTER TABLE adonis.required_metadata RENAME TO ado_required_metadata');
        $this->addSql('ALTER TABLE adonis.scale_data RENAME TO ado_scale');
        $this->addSql('ALTER TABLE adonis.session_data RENAME TO ado_session');
        $this->addSql('ALTER TABLE adonis.state_code RENAME TO ado_state_code');
        $this->addSql('ALTER TABLE adonis.sub_block RENAME TO ado_sub_bloc');
        $this->addSql('ALTER TABLE adonis.test RENAME TO ado_test');
        $this->addSql('ALTER TABLE adonis.test_combination RENAME TO ado_test_combination');
        $this->addSql('ALTER TABLE adonis.test_growth RENAME TO ado_test_growth');
        $this->addSql('ALTER TABLE adonis.test_preconditioned RENAME TO ado_test_preconditioned');
        $this->addSql('ALTER TABLE adonis.test_range RENAME TO ado_test_range');
        $this->addSql('ALTER TABLE adonis.treatment RENAME TO ado_treatment');
        $this->addSql('ALTER TABLE adonis.unit_plot RENAME TO ado_unit_parcel');
        $this->addSql('ALTER TABLE adonis.value_hint RENAME TO ado_value_hint');
        $this->addSql('ALTER TABLE adonis.value_hint_list RENAME TO ado_value_hint_list');
        $this->addSql('ALTER TABLE adonis.variable_generator RENAME TO ado_var_generator');
        $this->addSql('ALTER TABLE adonis.variable_unique RENAME TO ado_var_unique');
        $this->addSql('ALTER TABLE adonis.variable RENAME TO ado_variable');
        $this->addSql('ALTER TABLE adonis.variable_library RENAME TO ado_variable_library');
        $this->addSql('ALTER TABLE adonis.workpath RENAME TO ado_workpath');

        $this->addSql('ALTER SEQUENCE adonis.anomaly_id_seq RENAME TO ado_anomaly_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.desktop_user_id_seq RENAME TO ado_desktop_user_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.experiment_library_id_seq RENAME TO ado_device_library_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.experiment_wrapper_id_seq RENAME TO ado_device_wrapper_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.driver_id_seq RENAME TO ado_driver_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.data_entry_id_seq RENAME TO ado_entry_data_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.factor_id_seq RENAME TO ado_factor_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.field_generation_id_seq RENAME TO ado_field_generation_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.field_measure_id_seq RENAME TO ado_field_measure_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.graphical_structure_id_seq RENAME TO ado_graphical_structure_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.mark_id_seq RENAME TO ado_mark_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.material_id_seq RENAME TO ado_material_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.metadata_id_seq RENAME TO ado_metadata_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.modality_id_seq RENAME TO ado_modality_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.nature_zhe_id_seq RENAME TO ado_nature_zhe_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.note_id_seq RENAME TO ado_note_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.out_experimentation_zone_id_seq RENAME TO ado_out_experimentation_zone_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.platform_id_seq RENAME TO ado_platform_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.previous_value_id_seq RENAME TO ado_previous_value_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.project_id_seq RENAME TO ado_project_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.project_object_id_seq RENAME TO ado_project_object_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.protocol_id_seq RENAME TO ado_protocol_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.required_metadata_id_seq RENAME TO ado_required_metadata_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.scale_data_id_seq RENAME TO ado_scale_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.session_data_id_seq RENAME TO ado_session_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.state_code_id_seq RENAME TO ado_state_code_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.test_id_seq RENAME TO ado_test_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.treatment_id_seq RENAME TO ado_treatment_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.value_hint_id_seq RENAME TO ado_value_hint_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.value_hint_list_id_seq RENAME TO ado_value_hint_list_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.variable_id_seq RENAME TO ado_variable_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.variable_library_id_seq RENAME TO ado_variable_library_id_seq');
        $this->addSql('ALTER SEQUENCE adonis.workpath_id_seq RENAME TO ado_workpath_id_seq');

        $this->addSql('ALTER INDEX adonis.uniq_7123ed16166d1f9c RENAME TO uniq_4ff64bd8166d1f9c');
        $this->addSql('ALTER INDEX adonis.idx_f4a74370f3037e8e RENAME TO idx_9e6b81b8f3037e8e');
        $this->addSql('ALTER INDEX adonis.idx_ca57b18753426c55 RENAME TO idx_3ac9fe953426c55');
        $this->addSql('ALTER INDEX adonis.idx_ca57b187e9ed820c RENAME TO idx_3ac9fe9e9ed820c');
        $this->addSql('ALTER INDEX adonis.idx_ca57b187471c0366 RENAME TO idx_3ac9fe9471c0366');
        $this->addSql('ALTER INDEX adonis.idx_ca57b18761ba84b1 RENAME TO idx_3ac9fe961ba84b1');
        $this->addSql('ALTER INDEX adonis.idx_f1d7e7b83dae168b RENAME TO idx_9b1b25703dae168b');
        $this->addSql('ALTER INDEX adonis.idx_4d579ef5ead2fd5 RENAME TO idx_8e713caeead2fd5');
        $this->addSql('ALTER INDEX adonis.idx_4d579ef5166d1f9c RENAME TO idx_8e713cae166d1f9c');
        $this->addSql('ALTER INDEX adonis.idx_4d579ef5ce8f2b87 RENAME TO idx_8e713caece8f2b87');
        $this->addSql('ALTER INDEX adonis.idx_4d579ef5e308ac6f RENAME TO idx_8e713caee308ac6f');
        $this->addSql('ALTER INDEX adonis.idx_d7ff1cbbe308ac6f RENAME TO idx_6f7f8dd3e308ac6f');
        $this->addSql('ALTER INDEX adonis.idx_d7ff1cbbce8f2b87 RENAME TO idx_6f7f8dd3ce8f2b87');
        $this->addSql('ALTER INDEX adonis.idx_d7ff1cbbead2fd5 RENAME TO idx_6f7f8dd3ead2fd5');
        $this->addSql('ALTER INDEX adonis.idx_d7ff1cbb166d1f9c RENAME TO idx_6f7f8dd3166d1f9c');
        $this->addSql('ALTER INDEX adonis.idx_843cba5027166d67 RENAME TO idx_bae91c9e27166d67');
        $this->addSql('ALTER INDEX adonis.uniq_33354b6da76ed395 RENAME TO uniq_24807347a76ed395');
        $this->addSql('ALTER INDEX adonis.idx_7420f8b4d616280 RENAME TO idx_4af55e7ad616280');
        $this->addSql('ALTER INDEX adonis.uniq_6c6e3ff9166d1f9c RENAME TO uniq_f5200720166d1f9c');
        $this->addSql('ALTER INDEX adonis.idx_ecb8464961220ea6 RENAME TO idx_576953ae61220ea6');
        $this->addSql('ALTER INDEX adonis.idx_8f08066c166d1f9c RENAME TO idx_e5c4c4a4166d1f9c');
        $this->addSql('ALTER INDEX adonis.idx_d0c4c47b5c96afc5 RENAME TO idx_ba0806b35c96afc5');
        $this->addSql('ALTER INDEX adonis.idx_d0c4c47b166d1f9c RENAME TO idx_ba0806b3166d1f9c');
        $this->addSql('ALTER INDEX adonis.uniq_f793411ef3037e8e RENAME TO uniq_f5152880f3037e8e');
        $this->addSql('ALTER INDEX adonis.idx_430c8f82f50d82f4 RENAME TO idx_f8dd9a65f50d82f4');
        $this->addSql('ALTER INDEX adonis.idx_430c8f825d83cc1 RENAME TO idx_f8dd9a655d83cc1');
        $this->addSql('ALTER INDEX adonis.idx_602be365ccd59258 RENAME TO idx_1cc9d974ccd59258');
        $this->addSql('ALTER INDEX shared.idx_2c695f87a76ed395 RENAME TO idx_b759cc60a76ed395');
        $this->addSql('ALTER INDEX shared.idx_2c695f87fbf32840 RENAME TO idx_b759cc60fbf32840');
        $this->addSql('ALTER INDEX shared.idx_2c695f87427eb8a5 RENAME TO idx_b759cc60427eb8a5');
        $this->addSql('ALTER INDEX shared.uniq_bf800262ea750e8 RENAME TO uniq_450d190aea750e8');
        $this->addSql('ALTER INDEX shared.idx_b5642de4a76ed395 RENAME TO idx_9c804012a76ed395');
        $this->addSql('ALTER INDEX shared.idx_b5642de4f6bd1646 RENAME TO idx_9c804012f6bd1646');
        $this->addSql('ALTER INDEX webapp.uniq_65b64f1d166d1f9c RENAME TO uniq_a0163420166d1f9c');
        $this->addSql('ALTER INDEX webapp.idx_65b64f1da76ed395 RENAME TO idx_a0163420a76ed395');
        $this->addSql('ALTER INDEX webapp.uniq_3d93c837166d1f9c RENAME TO uniq_653e245d166d1f9c');
        $this->addSql('ALTER INDEX webapp.idx_3d93c837a76ed395 RENAME TO idx_653e245da76ed395');
        $this->addSql('ALTER INDEX adonis.idx_f6d9732694a4c7d4 RENAME TO idx_c485164d94a4c7d4');
        $this->addSql('ALTER INDEX adonis.idx_4cb6e3fa166d1f9c RENAME TO idx_3aff77ec166d1f9c');
        $this->addSql('ALTER INDEX shared.uniq_5b50ddcff85e0677 RENAME TO uniq_a1ddc6a7f85e0677');
        $this->addSql('ALTER INDEX adonis.uniq_960eedd166d1f9c RENAME TO uniq_fe3f68a166d1f9c');
        $this->addSql('ALTER INDEX adonis.idx_ea20eafdccd59258 RENAME TO idx_30720e48ccd59258');
        $this->addSql('ALTER INDEX adonis.idx_eb6d432561ba84b1 RENAME TO idx_81a181ed61ba84b1');
        $this->addSql('ALTER INDEX adonis.idx_eb6d4325582aab8e RENAME TO idx_81a181ed582aab8e');
        $this->addSql('ALTER INDEX adonis.uniq_34cf4848c3423909 RENAME TO uniq_a1aee86c3423909');
        $this->addSql('ALTER INDEX adonis.idx_34cf4848166d1f9c RENAME TO idx_a1aee86166d1f9c');
        $this->addSql('ALTER INDEX adonis.idx_76509c9321113fc RENAME TO idx_39b0af07321113fc');
        $this->addSql('ALTER INDEX adonis.idx_ac94c924fbd798f9 RENAME TO idx_476e5de7fbd798f9');
        $this->addSql('ALTER INDEX adonis.idx_ac94c9245d83cc1 RENAME TO idx_476e5de75d83cc1');
        $this->addSql('ALTER INDEX adonis.idx_ac94c924f3037e8e RENAME TO idx_476e5de7f3037e8e');
        $this->addSql('ALTER INDEX adonis.idx_86c5a4dfd616280 RENAME TO idx_5d69d831d616280');
        $this->addSql('ALTER INDEX adonis.uniq_c97e3886f3037e8e RENAME TO uniq_abd8a4ebf3037e8e');
        $this->addSql('ALTER INDEX adonis.idx_dd2c65db70e8809e RENAME TO idx_a89e569470e8809e');
        $this->addSql('ALTER INDEX adonis.uniq_1bef2b4dbaf977bb RENAME TO uniq_196942d3baf977bb');
        $this->addSql('ALTER INDEX adonis.idx_67fa62d661220ea6 RENAME TO idx_e3f3eafa61220ea6');
        $this->addSql('ALTER INDEX adonis.idx_67fa62d63a495054 RENAME TO idx_e3f3eafa3a495054');
        $this->addSql('ALTER INDEX adonis.idx_7094607b158e0b66 RENAME TO idx_84369cbe158e0b66');
        $this->addSql('ALTER INDEX adonis.idx_7094607b613fecdf RENAME TO idx_84369cbe613fecdf');
        $this->addSql('ALTER INDEX adonis.idx_7094607bf3037e8e RENAME TO idx_84369cbef3037e8e');
        $this->addSql('ALTER INDEX adonis.idx_7094607b4963009 RENAME TO idx_84369cbe4963009');
        $this->addSql('ALTER INDEX adonis.idx_ce336ab3f73142c2 RENAME TO idx_4a3ae29ff73142c2');
        $this->addSql('ALTER INDEX adonis.idx_7f91e780ffe6496f RENAME TO idx_d46554c6ffe6496f');
        $this->addSql('ALTER INDEX adonis.uniq_ed4cd67aa76ed395 RENAME TO uniq_9ad7bda5a76ed395');
        $this->addSql('ALTER INDEX adonis.uniq_8398ca1494a4c7d4 RENAME TO uniq_f403a1cb94a4c7d4');
        $this->addSql('ALTER INDEX adonis.idx_8398ca1479160211 RENAME TO idx_f403a1cb79160211');
        $this->addSql('ALTER INDEX adonis.idx_a49b2de713cd0a4c RENAME TO idx_cf66711813cd0a4c');
        $this->addSql('ALTER INDEX adonis.idx_a49b2de7582aab8e RENAME TO idx_cf667118582aab8e');
        $this->addSql('ALTER INDEX adonis.idx_a49b2de7e9ed820c RENAME TO idx_cf667118e9ed820c');
        $this->addSql('ALTER INDEX adonis.idx_a49b2de753426c55 RENAME TO idx_cf66711853426c55');
        $this->addSql('ALTER INDEX adonis.idx_a49b2de794a4c7d4 RENAME TO idx_cf66711894a4c7d4');
        $this->addSql('ALTER INDEX adonis.uniq_80b1819194a4c7d4 RENAME TO uniq_be64275f94a4c7d4');
        $this->addSql('ALTER INDEX adonis.idx_80b1819161220ea6 RENAME TO idx_be64275f61220ea6');
        $this->addSql('ALTER INDEX adonis.idx_97752ccfe9ed820c RENAME TO idx_964a9188e9ed820c');
        $this->addSql('ALTER INDEX adonis.idx_7d26cba2f3037e8e RENAME TO idx_6a93f388f3037e8e');
        $this->addSql('ALTER INDEX adonis.idx_7d26cba2fb8912b5 RENAME TO idx_6a93f388fb8912b5');
        $this->addSql('ALTER INDEX adonis.idx_7d26cba2894f9321 RENAME TO idx_6a93f388894f9321');
        $this->addSql('ALTER INDEX adonis.idx_428249e7f3037e8e RENAME TO idx_d757cfa7f3037e8e');
        $this->addSql('ALTER INDEX adonis.idx_428249e7ae1ae982 RENAME TO idx_d757cfa7ae1ae982');
        $this->addSql('ALTER INDEX adonis.idx_2a9b7110f3037e8e RENAME TO idx_b3d549c9f3037e8e');
        $this->addSql('ALTER INDEX adonis.idx_2a9b7110ae1ae982 RENAME TO idx_b3d549c9ae1ae982');
        $this->addSql('ALTER INDEX adonis.uniq_2a9b7110fe13cfd8 RENAME TO uniq_b3d549c9fe13cfd8');
        $this->addSql('ALTER INDEX adonis.idx_3af2e3c4daf72acc RENAME TO idx_8123f623daf72acc');
        $this->addSql('ALTER INDEX adonis.idx_22ff6f30f50d82f4 RENAME TO idx_354a571af50d82f4');
        $this->addSql('ALTER INDEX adonis.idx_7808b51dbc88c1a3 RENAME TO idx_46dd13d3bc88c1a3');
    }
}
