<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20210819152046 extends AbstractMigration
{
    public function getDescription() : string
    {
        return 'Add variable scales';
    }

    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'postgresql', 'Migration can only be executed safely on \'postgresql\'.');

        $this->addSql('CREATE SEQUENCE webapp.scale_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE TABLE webapp.scale (id INT NOT NULL, variable_id INT DEFAULT NULL, name VARCHAR(255) NOT NULL, min_value INT NOT NULL, max_value INT NOT NULL, open BOOLEAN NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_C37422A0F3037E8E ON webapp.scale (variable_id)');
        $this->addSql('ALTER TABLE webapp.scale ADD CONSTRAINT FK_C37422A0F3037E8E FOREIGN KEY (variable_id) REFERENCES webapp.variable_simple (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
    }

    public function down(Schema $schema) : void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'postgresql', 'Migration can only be executed safely on \'postgresql\'.');

        $this->addSql('DROP SEQUENCE webapp.scale_id_seq CASCADE');
        $this->addSql('DROP TABLE webapp.scale');
    }
}
