<?php

declare(strict_types=1);

namespace PackageVersions;

use Composer\InstalledVersions;
use OutOfBoundsException;

class_exists(InstalledVersions::class);

/**
 * This class is generated by composer/package-versions-deprecated, specifically by
 * @see \PackageVersions\Installer
 *
 * This file is overwritten at every run of `composer install` or `composer update`.
 *
 * @deprecated in favor of the Composer\InstalledVersions class provided by Composer 2. Require composer-runtime-api:^2 to ensure it is present.
 */
final class Versions
{
    /**
     * @deprecated please use {@see self::rootPackageName()} instead.
     *             This constant will be removed in version 2.0.0.
     */
    const ROOT_PACKAGE_NAME = '__root__';

    /**
     * Array of all available composer packages.
     * Dont read this array from your calling code, but use the \PackageVersions\Versions::getVersion() method instead.
     *
     * @var array<string, string>
     * @internal
     */
    const VERSIONS          = array (
  'api-platform/core' => 'v2.6.8@ff3aab5b196709c721960c0bb4f1d52759af737d',
  'aws/aws-crt-php' => 'v1.2.7@d71d9906c7bb63a28295447ba12e74723bd3730e',
  'aws/aws-sdk-php' => '3.334.1@3938b3467f64a30fed7ee1762a6785f808a5ae4d',
  'behat/transliterator' => 'v1.5.0@baac5873bac3749887d28ab68e2f74db3a4408af',
  'brick/geo' => '0.7.2@725789f7c090235e230b9a666acf59e0fc7f8e24',
  'cocur/background-process' => 'v0.7@9ae2902922f02ec5544d723756758eb7304c6869',
  'composer/package-versions-deprecated' => '1.11.99.4@b174585d1fe49ceed21928a945138948cb394600',
  'doctrine/annotations' => '1.14.4@253dca476f70808a5aeed3a47cc2cc88c5cab915',
  'doctrine/cache' => '2.2.0@1ca8f21980e770095a31456042471a57bc4c68fb',
  'doctrine/collections' => '1.8.0@2b44dd4cbca8b5744327de78bafef5945c7e7b5e',
  'doctrine/common' => '3.4.5@6c8fef961f67b8bc802ce3e32e3ebd1022907286',
  'doctrine/dbal' => '2.13.9@c480849ca3ad6706a39c970cdfe6888fa8a058b8',
  'doctrine/deprecations' => '1.1.3@dfbaa3c2d2e9a9df1118213f3b8b0c597bb99fab',
  'doctrine/doctrine-bundle' => '2.7.2@22d53b2c5ad03929628fb4a928b01135585b7179',
  'doctrine/doctrine-migrations-bundle' => '2.2.3@0a081b55a88259a887af7be654743a8c5f703e99',
  'doctrine/event-manager' => '1.2.0@95aa4cb529f1e96576f3fda9f5705ada4056a520',
  'doctrine/inflector' => '2.0.10@5817d0659c5b50c9b950feb9af7b9668e2c436bc',
  'doctrine/instantiator' => '1.5.0@0a0fa9780f5d4e507415a065172d26a98d02047b',
  'doctrine/lexer' => '2.1.1@861c870e8b75f7c8f69c146c7f89cc1c0f1b49b6',
  'doctrine/migrations' => '2.3.5@28d92a34348fee5daeb80879e56461b2e862fc05',
  'doctrine/orm' => '2.20.0@8ed6c2234aba019f9737a6bcc9516438e62da27c',
  'doctrine/persistence' => '3.4.0@0ea965320cec355dba75031c1b23d4c78362e3ff',
  'doctrine/sql-formatter' => '1.3.0@3447381095d32a171fe3a58323749f44dbb5ac7d',
  'egulias/email-validator' => '3.2.6@e5997fa97e8790cdae03a9cbd5e78e45e3c7bda7',
  'fig/link-util' => '1.1.2@5d7b8d04ed3393b4b59968ca1e906fb7186d81e8',
  'friendsofphp/proxy-manager-lts' => 'v1.0.18@2c8a6cffc3220e99352ad958fe7cf06bf6f7690f',
  'gedmo/doctrine-extensions' => 'v3.13.0@291d0c527d2dc9ee07b888c9a4e2a179893f08ab',
  'gesdinet/jwt-refresh-token-bundle' => 'v1.4.0@a47a373ec0838394bd9c1642c51be39b9c41da84',
  'guzzlehttp/guzzle' => '7.9.2@d281ed313b989f213357e3be1a179f02196ac99b',
  'guzzlehttp/promises' => '2.0.4@f9c436286ab2892c7db7be8c8da4ef61ccf7b455',
  'guzzlehttp/psr7' => '2.7.0@a70f5c95fb43bc83f07c9c948baa0dc1829bf201',
  'jms/metadata' => '2.8.0@7ca240dcac0c655eb15933ee55736ccd2ea0d7a6',
  'knplabs/gaufrette' => 'v0.10.0@ef5ec9d72c06d21febfa09b36d5c3d8e3af9cf8b',
  'knplabs/knp-gaufrette-bundle' => 'v0.7.3@b127fc85958ba321851cb1fe16de7ba0af7871e0',
  'laminas/laminas-code' => '3.4.1@1cb8f203389ab1482bf89c0e70a04849bacd7766',
  'laminas/laminas-eventmanager' => '3.5.0@41f7209428f37cab9573365e361f4078209aaafa',
  'laminas/laminas-zendframework-bridge' => '1.6.1@e112dd2c099f4f6142c16fc65fda89a638e06885',
  'lcobucci/clock' => '2.0.0@353d83fe2e6ae95745b16b3d911813df6a05bfb3',
  'lcobucci/jwt' => '4.3.0@4d7de2fe0d51a96418c0d04004986e410e87f6b4',
  'lexik/jwt-authentication-bundle' => 'v2.21.0@d57159da3f572b42ab609630edb6e27d71b37eca',
  'mmucklo/queue-bundle' => '6.7.0@11481017c777fd18930d3e3f5d26f5f07e9f4d4a',
  'monolog/monolog' => '2.10.0@5cf826f2991858b54d5c3809bee745560a1042a7',
  'mtdowling/jmespath.php' => '2.8.0@a2a865e05d5f420b50cc2f85bb78d565db12a6bc',
  'namshi/jose' => '7.2.3@89a24d7eb3040e285dd5925fcad992378b82bcff',
  'nelmio/cors-bundle' => '2.5.0@3a526fe025cd20e04a6a11370cf5ab28dbb5a544',
  'phpdocumentor/reflection-common' => '2.2.0@1d01c49d4ed62f25aa84a747ad35d5a16924662b',
  'phpdocumentor/reflection-docblock' => '5.6.0@f3558a4c23426d12bffeaab463f8a8d8b681193c',
  'phpdocumentor/type-resolver' => '1.10.0@679e3ce485b99e84c775d28e2e96fade9a7fb50a',
  'phpstan/phpdoc-parser' => '2.0.0@c00d78fb6b29658347f9d37ebe104bffadf36299',
  'psr/cache' => '1.0.1@d11b50ad223250cf17b86e38383413f5a6764bf8',
  'psr/container' => '1.1.2@513e0666f7216c7459170d56df27dfcefe1689ea',
  'psr/event-dispatcher' => '1.0.0@dbefd12671e8a14ec7f180cab83036ed26714bb0',
  'psr/http-client' => '1.0.3@bb5906edc1c324c9a05aa0873d40117941e5fa90',
  'psr/http-factory' => '1.1.0@2b4765fddfe3b508ac62f829e852b1501d3f6e8a',
  'psr/http-message' => '2.0@402d35bcb92c70c026d1a6a9883f06b2ead23d71',
  'psr/link' => '1.0.0@eea8e8662d5cd3ae4517c9b864493f59fca95562',
  'psr/log' => '1.1.4@d49695b909c3b7628b6289db5479a1c204601f11',
  'ralouphie/getallheaders' => '3.0.3@120b605dfeb996808c31b6477290a714d356e822',
  'sensio/framework-extra-bundle' => 'v6.2.10@2f886f4b31f23c76496901acaedfedb6936ba61f',
  'stof/doctrine-extensions-bundle' => 'v1.10.1@299d5333ce83941069852be36b949abbc776bf1d',
  'symfony/apache-pack' => 'v1.0.1@3aa5818d73ad2551281fc58a75afd9ca82622e6c',
  'symfony/asset' => 'v5.4.45@b7a18eaff1d717c321b4f13403413f8815bf9cb0',
  'symfony/cache' => 'v5.4.46@0fe08ee32cec2748fbfea10c52d3ee02049e0f6b',
  'symfony/cache-contracts' => 'v2.5.4@517c3a3619dadfa6952c4651767fcadffb4df65e',
  'symfony/config' => 'v5.4.46@977c88a02d7d3f16904a81907531b19666a08e78',
  'symfony/console' => 'v5.4.47@c4ba980ca61a9eb18ee6bcc73f28e475852bb1ed',
  'symfony/dependency-injection' => 'v5.4.48@e5ca16dee39ef7d63e552ff0bf0a2526a1142c92',
  'symfony/deprecation-contracts' => 'v2.5.4@605389f2a7e5625f273b53960dc46aeaf9c62918',
  'symfony/doctrine-bridge' => 'v5.4.48@43ed5e31c9188e4f4d3845d16986db4a86644eef',
  'symfony/dotenv' => 'v5.4.48@08013403089c8a126c968179179b817a552841ab',
  'symfony/error-handler' => 'v5.4.46@d19ede7a2cafb386be9486c580649d0f9e3d0363',
  'symfony/event-dispatcher' => 'v5.4.45@72982eb416f61003e9bb6e91f8b3213600dcf9e9',
  'symfony/event-dispatcher-contracts' => 'v2.5.4@e0fe3d79b516eb75126ac6fa4cbf19b79b08c99f',
  'symfony/expression-language' => 'v5.4.45@a784b66edc4c151eb05076d04707906ee2c209a9',
  'symfony/filesystem' => 'v5.4.45@57c8294ed37d4a055b77057827c67f9558c95c54',
  'symfony/finder' => 'v5.4.45@63741784cd7b9967975eec610b256eed3ede022b',
  'symfony/flex' => 'v1.21.8@bda5f869ac51c8e985a6fe9f964c4cb78228a369',
  'symfony/form' => 'v5.4.45@c1974a723cdee8a273cb49ce13fada5c1667706a',
  'symfony/framework-bundle' => 'v5.4.45@3d70f14176422d4d8ee400b6acae4e21f7c25ca2',
  'symfony/http-foundation' => 'v5.4.48@3f38b8af283b830e1363acd79e5bc3412d055341',
  'symfony/http-kernel' => 'v5.4.48@c2dbfc92b851404567160d1ecf3fb7d9b7bde9b0',
  'symfony/intl' => 'v5.4.47@5258476a3ab680cd633a1d23130fcc9e8027e3ff',
  'symfony/ldap' => 'v5.4.45@be1474c7e93e5f7a24f5ed2e8c583f46e8094121',
  'symfony/mailer' => 'v5.4.45@f732e1fafdf0f4a2d865e91f1018aaca174aeed9',
  'symfony/mime' => 'v5.4.45@8c1b9b3e5b52981551fc6044539af1d974e39064',
  'symfony/monolog-bridge' => 'v5.4.45@cf7d75d4d64a41fbb1c0e92301bec404134fa84b',
  'symfony/monolog-bundle' => 'v3.10.0@414f951743f4aa1fd0f5bf6a0e9c16af3fe7f181',
  'symfony/options-resolver' => 'v5.4.45@74e5b6f0db3e8589e6cfd5efb317a1fc2bb52fb6',
  'symfony/password-hasher' => 'v5.4.45@6c5993b24505f98b90ca4896448012bbec54c7c8',
  'symfony/polyfill-intl-grapheme' => 'v1.31.0@b9123926e3b7bc2f98c02ad54f6a4b02b91a8abe',
  'symfony/polyfill-intl-icu' => 'v1.31.0@d80a05e9904d2c2b9b95929f3e4b5d3a8f418d78',
  'symfony/polyfill-intl-idn' => 'v1.31.0@c36586dcf89a12315939e00ec9b4474adcb1d773',
  'symfony/polyfill-intl-normalizer' => 'v1.31.0@3833d7255cc303546435cb650316bff708a1c75c',
  'symfony/polyfill-mbstring' => 'v1.31.0@85181ba99b2345b0ef10ce42ecac37612d9fd341',
  'symfony/polyfill-php72' => 'v1.31.0@fa2ae56c44f03bed91a39bfc9822e31e7c5c38ce',
  'symfony/polyfill-php73' => 'v1.31.0@0f68c03565dcaaf25a890667542e8bd75fe7e5bb',
  'symfony/polyfill-php80' => 'v1.31.0@60328e362d4c2c802a54fcbf04f9d3fb892b4cf8',
  'symfony/polyfill-php81' => 'v1.31.0@4a4cfc2d253c21a5ad0e53071df248ed48c6ce5c',
  'symfony/process' => 'v5.4.47@5d1662fb32ebc94f17ddb8d635454a776066733d',
  'symfony/property-access' => 'v5.4.45@111e7ed617509f1a9139686055d234aad6e388e0',
  'symfony/property-info' => 'v5.4.48@a0396295ad585f95fccd690bc6a281e5bd303902',
  'symfony/proxy-manager-bridge' => 'v5.4.45@e96cd37f3de0b75ff32f6b79c180ba77c4037eec',
  'symfony/routing' => 'v5.4.48@dd08c19879a9b37ff14fd30dcbdf99a4cf045db1',
  'symfony/security-bundle' => 'v5.4.45@d6081d1b9118f944df90bb77444a8617eba01542',
  'symfony/security-core' => 'v5.4.48@cca947b1a74bdbc21c4d6288a4abb938d9a7eaba',
  'symfony/security-csrf' => 'v5.4.45@28dcafc3220f12264bb2aabe2389a2163458c1f4',
  'symfony/security-guard' => 'v5.4.45@f3da3dbec38aaedaf287ffeb4e3a90994af37faa',
  'symfony/security-http' => 'v5.4.47@cde02b002e0447075430e6a84482e38f2fd9268d',
  'symfony/serializer' => 'v5.4.45@460c5df9fb6c39d10d5b7f386e4feae4b6370221',
  'symfony/service-contracts' => 'v2.5.4@f37b419f7aea2e9abf10abd261832cace12e3300',
  'symfony/stopwatch' => 'v5.4.45@fb2c199cf302eb207f8c23e7ee174c1c31a5c004',
  'symfony/string' => 'v5.4.47@136ca7d72f72b599f2631aca474a4f8e26719799',
  'symfony/translation' => 'v5.4.45@98f26acc99341ca4bab345fb14d7b1d7cb825bed',
  'symfony/translation-contracts' => 'v2.5.4@450d4172653f38818657022252f9d81be89ee9a8',
  'symfony/twig-bridge' => 'v5.4.48@853a0c9aa40123a9feeb335c865b659d94e49e5d',
  'symfony/twig-bundle' => 'v5.4.45@e1ca56e1dc7791eb19f0aff71d3d94e6a91cc8f9',
  'symfony/validator' => 'v5.4.48@883667679d93d6c30f1b7490d669801712d3be2f',
  'symfony/var-dumper' => 'v5.4.48@42f18f170aa86d612c3559cfb3bd11a375df32c8',
  'symfony/var-exporter' => 'v5.4.45@862700068db0ddfd8c5b850671e029a90246ec75',
  'symfony/web-link' => 'v5.4.45@5b71baea258dbbe2a3627cb11c1721e8a2216a55',
  'symfony/webpack-encore-bundle' => 'v1.17.2@471ebbc03072dad6e31840dc317bc634a32785f5',
  'symfony/yaml' => 'v5.4.45@a454d47278cc16a5db371fe73ae66a78a633371e',
  'twig/extra-bundle' => 'v3.11.0@bf8a304eac15838d7724fdf64c345bdefbb75f03',
  'twig/twig' => 'v3.11.3@3b06600ff3abefaf8ff55d5c336cd1c4253f8c7e',
  'vich/uploader-bundle' => '1.23.1@7d20347fc92243ab8e261c0b6196c25b77c579f8',
  'webmozart/assert' => '1.11.0@11cb2199493b2f8a3b53e7f19068fc6aac760991',
  'willdurand/negotiation' => '3.1.0@68e9ea0553ef6e2ee8db5c1d98829f111e623ec2',
  'amphp/amp' => 'v2.6.4@ded3d9be08f526089eb7ee8d9f16a9768f9dec2d',
  'amphp/byte-stream' => 'v1.8.2@4f0e968ba3798a423730f567b1b50d3441c16ddc',
  'clue/ndjson-react' => 'v1.3.0@392dc165fce93b5bb5c637b67e59619223c931b0',
  'composer/pcre' => '3.3.2@b2bed4734f0cc156ee1fe9c0da2550420d99a21e',
  'composer/semver' => '3.4.3@4313d26ada5e0c4edfbd1dc481a92ff7bff91f12',
  'composer/xdebug-handler' => '3.0.5@6c1925561632e83d60a44492e0b344cf48ab85ef',
  'deployer/deployer' => 'v6.9.0@c4380effdc9f6d9c6ae549bb76f0a22bcb1d31d2',
  'deployer/phar-update' => 'v2.2.0@9ad07422f2cd43a1382ee8e134bdcd3a374848e3',
  'deployer/recipes' => '6.2.2@84b3229c518c094a950e1fe785b7b8f9598770fe',
  'dnoegel/php-xdg-base-dir' => 'v0.1.1@8f8a6e48c5ecb0f991c2fdcf5f154a47d85f9ffd',
  'doctrine/data-fixtures' => '1.6.7@ae4e845decbe177348fdbecd04331f4fb96aa301',
  'doctrine/doctrine-fixtures-bundle' => '3.4.5@5988484f79362cd7d06564bd11be7ce622e08c87',
  'evenement/evenement' => 'v3.0.2@0a16b0d71ab13284339abb99d9d2bd813640efbc',
  'felixfbecker/advanced-json-rpc' => 'v3.2.1@b5f37dbff9a8ad360ca341f3240dc1c168b45447',
  'felixfbecker/language-server-protocol' => 'v1.5.3@a9e113dbc7d849e35b8776da39edaf4313b7b6c9',
  'fidry/cpu-core-counter' => '1.2.0@8520451a140d3f46ac33042715115e290cf5785f',
  'friendsofphp/php-cs-fixer' => 'v3.65.0@79d4f3e77b250a7d8043d76c6af8f0695e8a469f',
  'myclabs/deep-copy' => '1.12.1@123267b2c49fbf30d78a7b2d333f6be754b94845',
  'netresearch/jsonmapper' => 'v4.5.0@8e76efb98ee8b6afc54687045e1b8dba55ac76e5',
  'nikic/php-parser' => 'v4.19.4@715f4d25e225bc47b293a8b997fe6ce99bf987d2',
  'phar-io/manifest' => '2.0.4@54750ef60c58e43759730615a392c31c80e23176',
  'phar-io/version' => '3.2.1@4f7fd7836c6f332bb2933569e566a0d6c4cbed74',
  'phpunit/php-code-coverage' => '9.2.32@85402a822d1ecf1db1096959413d35e1c37cf1a5',
  'phpunit/php-file-iterator' => '3.0.6@cf1c2e7c203ac650e352f4cc675a7021e7d1b3cf',
  'phpunit/php-invoker' => '3.1.1@5a10147d0aaf65b58940a0b72f71c9ac0423cc67',
  'phpunit/php-text-template' => '2.0.4@5da5f67fc95621df9ff4c4e5a84d6a8a2acf7c28',
  'phpunit/php-timer' => '5.0.3@5a63ce20ed1b5bf577850e2c4e87f4aa902afbd2',
  'phpunit/phpunit' => '9.6.21@de6abf3b6f8dd955fac3caad3af7a9504e8c2ffa',
  'pimple/pimple' => 'v3.5.0@a94b3a4db7fb774b3d78dad2315ddc07629e1bed',
  'psalm/plugin-symfony' => 'v5.1.0@f23ec3439743fb24f5c1101e52d032f23d5befa6',
  'react/cache' => 'v1.2.0@d47c472b64aa5608225f47965a484b75c7817d5b',
  'react/child-process' => 'v0.6.5@e71eb1aa55f057c7a4a0d08d06b0b0a484bead43',
  'react/dns' => 'v1.13.0@eb8ae001b5a455665c89c1df97f6fb682f8fb0f5',
  'react/event-loop' => 'v1.5.0@bbe0bd8c51ffc05ee43f1729087ed3bdf7d53354',
  'react/promise' => 'v3.2.0@8a164643313c71354582dc850b42b33fa12a4b63',
  'react/socket' => 'v1.16.0@23e4ff33ea3e160d2d1f59a0e6050e4b0fb0eac1',
  'react/stream' => 'v1.4.0@1e5b0acb8fe55143b5b426817155190eb6f5b18d',
  'sebastian/cli-parser' => '1.0.2@2b56bea83a09de3ac06bb18b92f068e60cc6f50b',
  'sebastian/code-unit' => '1.0.8@1fc9f64c0927627ef78ba436c9b17d967e68e120',
  'sebastian/code-unit-reverse-lookup' => '2.0.3@ac91f01ccec49fb77bdc6fd1e548bc70f7faa3e5',
  'sebastian/comparator' => '4.0.8@fa0f136dd2334583309d32b62544682ee972b51a',
  'sebastian/complexity' => '2.0.3@25f207c40d62b8b7aa32f5ab026c53561964053a',
  'sebastian/diff' => '4.0.6@ba01945089c3a293b01ba9badc29ad55b106b0bc',
  'sebastian/environment' => '5.1.5@830c43a844f1f8d5b7a1f6d6076b784454d8b7ed',
  'sebastian/exporter' => '4.0.6@78c00df8f170e02473b682df15bfcdacc3d32d72',
  'sebastian/global-state' => '5.0.7@bca7df1f32ee6fe93b4d4a9abbf69e13a4ada2c9',
  'sebastian/lines-of-code' => '1.0.4@e1e4a170560925c26d424b6a03aed157e7dcc5c5',
  'sebastian/object-enumerator' => '4.0.4@5c9eeac41b290a3712d88851518825ad78f45c71',
  'sebastian/object-reflector' => '2.0.4@b4f479ebdbf63ac605d183ece17d8d7fe49c15c7',
  'sebastian/recursion-context' => '4.0.5@e75bd0f07204fec2a0af9b0f3cfe97d05f92efc1',
  'sebastian/resource-operations' => '3.0.4@05d5692a7993ecccd56a03e40cd7e5b09b1d404e',
  'sebastian/type' => '3.2.1@75e2c2a32f5e0b3aef905b9ed0b179b953b3d7c7',
  'sebastian/version' => '3.0.2@c6c1022351a901512170118436c764e473f6de8c',
  'spatie/array-to-xml' => '2.17.1@5cbec9c6ab17e320c58a259f0cebe88bde4a7c46',
  'symfony/browser-kit' => 'v5.4.45@03cce39764429e07fbab9b989a1182a24578341d',
  'symfony/css-selector' => 'v5.4.45@4f7f3c35fba88146b56d0025d20ace3f3901f097',
  'symfony/debug-bundle' => 'v5.4.45@653c7629d036ef24ac5de54a157aecdc400d2570',
  'symfony/dom-crawler' => 'v5.4.48@b57df76f4757a9a8dfbb57ba48d7780cc20776c6',
  'symfony/http-client' => 'v5.4.49@d77d8e212cde7b5c4a64142bf431522f19487c28',
  'symfony/http-client-contracts' => 'v2.5.4@fbfd73095ae958935396cf2243c47b01c677750c',
  'symfony/maker-bundle' => 'v1.43.0@e3f9a1d9e0f4968f68454403e820dffc7db38a59',
  'symfony/phpunit-bridge' => 'v5.4.48@c6839a192ac526a7905980552d5997ea7f738eb2',
  'symfony/web-profiler-bundle' => 'v5.4.48@4afb0399456b966be92410d2bbd6146cc3ce2174',
  'theseer/tokenizer' => '1.2.3@737eda637ed5e28c3413cb1ebe8bb52cbf1ca7a2',
  'vimeo/psalm' => '5.26.1@d747f6500b38ac4f7dfc5edbcae6e4b637d7add0',
  'paragonie/random_compat' => '2.*@',
  'symfony/polyfill-ctype' => '*@',
  'symfony/polyfill-iconv' => '*@',
  'symfony/polyfill-php71' => '*@',
  'symfony/polyfill-php70' => '*@',
  'symfony/polyfill-php56' => '*@',
  '__root__' => '1.0.0+no-version-set@',
);

    private function __construct()
    {
    }

    /**
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function rootPackageName() : string
    {
        if (!self::composer2ApiUsable()) {
            return self::ROOT_PACKAGE_NAME;
        }

        return InstalledVersions::getRootPackage()['name'];
    }

    /**
     * @throws OutOfBoundsException If a version cannot be located.
     *
     * @psalm-param key-of<self::VERSIONS> $packageName
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function getVersion(string $packageName): string
    {
        if (self::composer2ApiUsable()) {
            return InstalledVersions::getPrettyVersion($packageName)
                . '@' . InstalledVersions::getReference($packageName);
        }

        if (isset(self::VERSIONS[$packageName])) {
            return self::VERSIONS[$packageName];
        }

        throw new OutOfBoundsException(
            'Required package "' . $packageName . '" is not installed: check your ./vendor/composer/installed.json and/or ./composer.lock files'
        );
    }

    private static function composer2ApiUsable(): bool
    {
        if (!class_exists(InstalledVersions::class, false)) {
            return false;
        }

        if (method_exists(InstalledVersions::class, 'getAllRawData')) {
            $rawData = InstalledVersions::getAllRawData();
            if (count($rawData) === 1 && count($rawData[0]) === 0) {
                return false;
            }
        } else {
            $rawData = InstalledVersions::getRawData();
            if ($rawData === null || $rawData === []) {
                return false;
            }
        }

        return true;
    }
}
