<?php

namespace Dtc\QueueBundle\Doctrine;

use Dtc\QueueBundle\Manager\RunManager;
use Dtc\QueueBundle\Model\Run;

abstract class DoctrineRunManager extends RunManager
{
    /** @var \Doctrine\Persistence\ObjectManager */
    protected $objectManager;

    /** @var string|null */
    protected $runArchiveClass;

    public function __construct($objectManager, $runClass, $runArchiveClass)
    {
        $this->runArchiveClass = $runArchiveClass;
        $this->objectManager = $objectManager;
        parent::__construct($runClass);
    }

    /**
     * @return \Doctrine\Persistence\ObjectManager
     */
    public function getObjectManager()
    {
        return $this->objectManager;
    }

    /**
     * @return \Doctrine\Persistence\ObjectRepository
     */
    public function getRepository()
    {
        return $this->getObjectManager()->getRepository($this->getRunClass());
    }

    /**
     * @return string|null
     */
    public function getRunArchiveClass()
    {
        return $this->runArchiveClass;
    }

    /**
     * @return int
     *
     * @throws \Exception
     */
    public function pruneStalledRuns()
    {
        $runs = $this->getOldLiveRuns();
        /** @var Run $run */
        $delete = [];

        foreach ($runs as $run) {
            $lastHeartbeat = $run->getLastHeartbeatAt();
            $time = time() - 3600;
            $processTimeout = $run->getProcessTimeout();
            $time -= $processTimeout;
            $oldDate = \DateTime::createFromFormat('U', strval($time));
            if (false === $oldDate) {
                throw new \Exception("Could not create DateTime object from $time");
            }
            $oldDate->setTimezone(new \DateTimeZone(date_default_timezone_get()));
            if (null === $lastHeartbeat || $oldDate > $lastHeartbeat) {
                $delete[] = $run;
            }
        }

        return $this->deleteOldRuns($delete);
    }

    /**
     * @return int
     */
    protected function deleteOldRuns(array $delete)
    {
        $count = count($delete);
        $objectManager = $this->getObjectManager();
        for ($i = 0; $i < $count; $i += 100) {
            $deleteList = array_slice($delete, $i, 100);
            foreach ($deleteList as $object) {
                $objectManager->remove($object);
            }
            $this->flush();
        }

        return $count;
    }

    protected function flush()
    {
        $this->getObjectManager()->flush();
    }

    /**
     * @param string $action
     */
    protected function persistRun(Run $run, $action = 'persist')
    {
        parent::persistRun($run, $action);
        $this->persist($run, $action);
    }

    /**
     * @return array
     */
    abstract protected function getOldLiveRuns();

    abstract protected function persist($object, $action = 'persist');

    abstract protected function removeOlderThan($objectName, $field, \DateTime $olderThan);

    public function pruneArchivedRuns(\DateTime $olderThan)
    {
        return $this->removeOlderThan($this->getRunArchiveClass(), 'endedAt', $olderThan);
    }
}
