<?php

namespace Dtc\QueueBundle\Tests\Controller;

use Dtc\QueueBundle\Controller\TrendsController;
use Dtc\QueueBundle\Model\BaseJob;
use Dtc\QueueBundle\ORM\JobTimingManager;
use PHPUnit\Framework\TestCase;
use Symfony\Component\HttpFoundation\Request;

class TrendsControllerTest extends TestCase
{
    use ControllerTrait;

    public function testTimings()
    {
        $container = $this->getContainerOrm();
        $this->runTimingsTests($container);
        $container = $this->getContainerOdm();
        $this->runTimingsTests($container);
    }

    public function testTrendsAction()
    {
        $container = $this->getContainerOrm();
        $trendsController = new TrendsController($container);
        $response = $trendsController->trends();
        $this->runJsCssTest($response);
    }

    /**
     * @param \Symfony\Component\DependencyInjection\Container $container
     */
    public function runTimingsTests($container)
    {
        $trendsController = new TrendsController($container);

        $dateTimeStr = '2017-07-01T4:04:04Z';
        $dateTime = \DateTime::createFromFormat(DATE_ISO8601, $dateTimeStr);
        self::assertNotFalse($dateTime);
        $dateTime->setTimezone(new \DateTimeZone(date_default_timezone_get()));
        /** @var JobTimingManager $jobTimingManager */
        $jobTimingManager = $container->get('dtc_queue.manager.job_timing');
        $jobTimingManager->recordTiming(BaseJob::STATUS_SUCCESS, $dateTime);
        $jobTimingManager->recordTiming(BaseJob::STATUS_SUCCESS, $dateTime);
        $jobTimingManager->recordTiming(BaseJob::STATUS_EXCEPTION, $dateTime);

        $request = new Request();
        $request->query->set('type', 'HOUR');
        $request->query->set('end', '2017-07-01T5:05:00.0Z');
        $timings = $trendsController->timings($request);
        $content = $timings->getContent();

        self::assertNotEmpty($content);
        $contentDecoded = json_decode($content, true);
        self::assertCount(3, $contentDecoded);
        self::assertEquals([3], $contentDecoded['timings_data_0']);
        self::assertEquals(['2017-07-01 04'], $contentDecoded['timings_dates']);
        self::assertEquals(['2017-07-01T04:00:00+00:00'], $contentDecoded['timings_dates_rfc3339']);

        $request = new Request();
        $request->query->set('type', 'MINUTE');
        $request->query->set('end', '2017-07-01T4:05:04.0Z');
        $timings = $trendsController->timings($request);
        $content = $timings->getContent();
        $contentDecoded = json_decode($content, true);
        self::assertEquals(['2017-07-01 04:04'], $contentDecoded['timings_dates']);
        self::assertEquals(['2017-07-01T04:04:00+00:00'], $contentDecoded['timings_dates_rfc3339']);

        $request = new Request();
        $request->query->set('type', 'DAY');
        $request->query->set('end', '2017-07-01T4:05:04.0Z');
        $timings = $trendsController->timings($request);
        $content = $timings->getContent();
        $contentDecoded = json_decode($content, true);
        self::assertEquals(['2017-07-01'], $contentDecoded['timings_dates']);

        $request = new Request();
        $request->query->set('type', 'MONTH');
        $request->query->set('end', '2017-07-01T4:05:04.0Z');
        $timings = $trendsController->timings($request);
        $content = $timings->getContent();
        $contentDecoded = json_decode($content, true);
        self::assertEquals(['2017-07'], $contentDecoded['timings_dates']);

        $request = new Request();
        $request->query->set('type', 'YEAR');
        $request->query->set('end', '2017-07-01T4:05:04.0Z');
        $timings = $trendsController->timings($request);
        $content = $timings->getContent();
        $contentDecoded = json_decode($content, true);
        self::assertEquals(['2017'], $contentDecoded['timings_dates']);
    }
}
