/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

public class StyleUtil {
    public static DesignElementHandle copyStyles(DesignElementHandle source, DesignElementHandle target, boolean isCascaded) {
        return StyleUtil.copyStyleProperties(source, target, isCascaded, false);
    }

    public static DesignElementHandle copyStyles(DesignElementHandle source, DesignElementHandle target) {
        return StyleUtil.copyStyleProperties(source, target, false, false);
    }

    public static DesignElementHandle copyLocalStyles(DesignElementHandle source, DesignElementHandle target) {
        return StyleUtil.copyStyleProperties(source, target, false, true);
    }

    private static DesignElementHandle copyStyleProperties(DesignElementHandle source, DesignElementHandle target, boolean isCascaded, boolean isLocal) {
        if (source == null) {
            return null;
        }
        IElementDefn elementDefn = source.getDefn();
        if (target == null) {
            target = source.getElementFactory().newElement(elementDefn.getName(), null);
        }
        if (target.getDefn() != elementDefn || source == target) {
            return target;
        }
        if (!elementDefn.hasStyle()) {
            return target;
        }
        DesignElement copiedElement = target.getElement();
        DesignElement sourceElement = source.getElement();
        Module module = source.getModule();
        ElementPropertyDefn propDefn = sourceElement.getPropertyDefn("style");
        copiedElement.setProperty(propDefn, sourceElement.getProperty(module, propDefn));
        IElementDefn styleDefn = MetaDataDictionary.getInstance().getStyle();
        List<IElementPropertyDefn> styleProps = styleDefn.getProperties();
        int i = 0;
        while (i < styleProps.size()) {
            propDefn = (ElementPropertyDefn)styleProps.get(i);
            if (propDefn.isStyleProperty()) {
                Object value = null;
                value = isLocal ? sourceElement.getLocalProperty(module, propDefn) : (isCascaded ? sourceElement.getProperty(module, propDefn) : sourceElement.getFactoryProperty(module, propDefn));
                if (value != null) {
                    copiedElement.setProperty(propDefn, value);
                }
            }
            ++i;
        }
        return target;
    }
}

