/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.LayoutRecordTask;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.ElementDeletedEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.elements.table.LayoutUtil;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.command.ElementBackRefRecord;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.IReferencableElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.Parameter;
import org.eclipse.birt.report.model.elements.ParameterGroup;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.SimpleDataSet;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.validators.ValidationExecutor;
import org.eclipse.birt.report.model.validators.ValidationNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentRecord
extends SimpleRecord {
    protected ContainerContext containerInfo = null;
    protected DesignElement content = null;
    protected boolean add = true;
    protected int oldPosn = -1;
    protected final Module module;

    public ContentRecord(Module module, ContainerContext containerInfor, DesignElement contentObj, boolean isAdd) {
        this.init(containerInfor, contentObj, -1, isAdd);
        this.module = module;
        assert (module != null);
    }

    public ContentRecord(Module module, ContainerContext containerInfo, DesignElement contentObj, int newPos) {
        this.init(containerInfo, contentObj, newPos, true);
        this.module = module;
        assert (module != null);
    }

    private void init(ContainerContext theContainerInfo, DesignElement contentObj, int newPos, boolean isAdd) {
        this.containerInfo = theContainerInfo;
        this.content = contentObj;
        this.add = isAdd;
        assert (newPos >= -1);
        assert (this.containerInfo != null);
        assert (this.content != null);
        assert (isAdd && this.content.getContainer() == null || !isAdd && this.content.getContainer() != null);
        assert (this.containerInfo.getContainerDefn().canContain(this.content));
        if (isAdd) {
            int count = this.containerInfo.getContentCount(this.module);
            this.oldPosn = newPos == -1 || count < newPos ? count : newPos;
        } else {
            this.oldPosn = this.containerInfo.indexOf(this.module, this.content);
            assert (this.oldPosn != -1);
        }
        this.label = this.add ? CommandLabelFactory.getCommandLabel("Message.AddElement") : CommandLabelFactory.getCommandLabel("Message.DropElement");
    }

    @Override
    public DesignElement getTarget() {
        if (this.eventTarget != null) {
            return this.eventTarget.getElement();
        }
        return this.containerInfo.getElement();
    }

    @Override
    public NotificationEvent getEvent() {
        return null;
    }

    @Override
    protected void perform(boolean undo) {
        if (this.add && !undo || !this.add && undo) {
            this.containerInfo.add(this.module, this.content, this.oldPosn);
            if (this.content.getRoot() != null) {
                this.module.manageId(this.content, true);
            }
        } else {
            if (this.content.getRoot() != null) {
                this.module.manageId(this.content, false);
            }
            this.oldPosn = this.containerInfo.indexOf(this.module, this.content);
            this.containerInfo.remove(this.module, this.content);
            if (this.content.hasReferences()) {
                this.adjustReferenceClients((IReferencableElement)((Object)this.content));
            }
            this.adjustReferredClients(this.content);
        }
    }

    private void adjustReferenceClients(IReferencableElement referred) {
        ArrayList<BackRef> clients = new ArrayList<BackRef>(referred.getClientList());
        for (BackRef ref : clients) {
            DesignElement client = ref.getElement();
            if (client != null) {
                ElementBackRefRecord.unresolveBackRef(this.module, client, referred, ref.getPropertyName());
                continue;
            }
            ElementBackRefRecord.unresolveBackRef(this.module, ref.getStructure(), referred, ref.getPropertyName());
        }
    }

    private void adjustReferredClients(DesignElement element) {
        List<IElementPropertyDefn> propDefns = element.getPropertyDefns();
        StyleElement style = element.getStyle(this.module);
        if (style != null) {
            ElementBackRefRecord.unresolveBackRef(this.module, element, style, "style");
        }
        for (PropertyDefn propertyDefn : propDefns) {
            List valueList;
            if ("extends".equalsIgnoreCase(propertyDefn.getName()) || "style".equalsIgnoreCase(propertyDefn.getName())) continue;
            if (propertyDefn.getTypeCode() == 15 || propertyDefn.getTypeCode() == 19) {
                ReferenceValue value = (ReferenceValue)element.getLocalProperty(this.module, (ElementPropertyDefn)propertyDefn);
                if (value == null || !value.isResolved()) continue;
                if (value instanceof ElementRefValue) {
                    ((ElementRefValue)value).getTargetElement().dropClient(element);
                } else {
                    ((StructRefValue)value).getTargetStructure().dropClient(element);
                }
                value.unresolved(value.getName());
                continue;
            }
            if (propertyDefn.getTypeCode() != 20 || propertyDefn.getSubTypeCode() != 15 || (valueList = (List)element.getLocalProperty(this.module, (ElementPropertyDefn)propertyDefn)) == null) continue;
            int i = valueList.size() - 1;
            while (i >= 0) {
                ElementRefValue item = (ElementRefValue)valueList.get(i);
                if (item.isResolved()) {
                    item.getTargetElement().dropClient(element);
                    item.unresolved(item.getName());
                }
                --i;
            }
        }
    }

    private boolean isSelector(DesignElement content) {
        if (!(content instanceof StyleElement)) {
            return false;
        }
        return MetaDataDictionary.getInstance().getPredefinedStyle(content.getName()) != null;
    }

    @Override
    public List<ValidationNode> getValidators() {
        List<ValidationNode> list = ValidationExecutor.getValidationNodes(this.containerInfo.getElement(), this.containerInfo.getTriggerSetForContainerDefn(), false);
        if (this.add && this.state != 2 || !this.add && this.state == 2) {
            ElementDefn contentDefn = (ElementDefn)this.content.getDefn();
            list.addAll(ValidationExecutor.getValidationNodes(this.content, contentDefn.getTriggerDefnSet(), false));
        }
        return list;
    }

    @Override
    protected List<RecordTask> getPostTasks() {
        ReportItem compoundElement;
        ArrayList<RecordTask> retValue = new ArrayList<RecordTask>();
        retValue.addAll(super.getPostTasks());
        DesignElement container = this.containerInfo.getElement();
        if (this.eventTarget != null) {
            PropertyEvent event = new PropertyEvent(this.eventTarget.getElement(), this.eventTarget.getPropName());
            retValue.add(new NotificationRecordTask(container, (NotificationEvent)event));
            this.content.clearListeners();
            return retValue;
        }
        if ((container instanceof TableItem || container instanceof GridItem || container instanceof TableGroup || container instanceof TableRow) && (compoundElement = LayoutUtil.getCompoundContainer(container)) != null) {
            retValue.add(new LayoutRecordTask(this.module, compoundElement));
        }
        NotificationEvent event = null;
        event = this.add && this.state != 2 || !this.add && this.state == 2 ? new ContentEvent(this.containerInfo, this.content, 1) : new ContentEvent(this.containerInfo, this.content, 2);
        if (this.state == 1) {
            event.setSender(this.sender);
        }
        retValue.add(new NotificationRecordTask(container, event));
        if (this.add && this.state != 2 || !this.add && this.state == 2) {
            if (this.isSelector(this.content)) {
                retValue.add(new NotificationRecordTask(this.content, event, container.getRoot()));
            }
            return retValue;
        }
        if (this.content instanceof Parameter || this.content instanceof ParameterGroup || this.content instanceof SimpleDataSet || this.content instanceof StyleElement) {
            event = new ElementDeletedEvent(container, this.content);
            if (this.state == 1) {
                event.setSender(this.sender);
            }
            retValue.add(new NotificationRecordTask(this.content, event, container.getRoot()));
        } else {
            this.content.clearListeners();
        }
        return retValue;
    }
}

