/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.simpleapi;

import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.simpleapi.IAction;
import org.eclipse.birt.report.model.api.simpleapi.IImage;
import org.eclipse.birt.report.model.simpleapi.ActionImpl;
import org.eclipse.birt.report.model.simpleapi.ReportItem;

public class Image
extends ReportItem
implements IImage {
    public Image(ImageHandle image) {
        super(image);
    }

    public double getScale() {
        return ((ImageHandle)this.handle).getScale();
    }

    public String getSize() {
        return ((ImageHandle)this.handle).getSize();
    }

    public String getAltText() {
        return ((ImageHandle)this.handle).getAltText();
    }

    public void setAltText(String altText) throws SemanticException {
        this.setProperty("altText", altText);
    }

    public String getAltTextKey() {
        return ((ImageHandle)this.handle).getAltTextKey();
    }

    public void setAltTextKey(String altTextKey) throws SemanticException {
        this.setProperty("altTextID", altTextKey);
    }

    public String getSource() {
        return ((ImageHandle)this.handle).getSource();
    }

    public void setSource(String source) throws SemanticException {
        this.setProperty("source", source);
    }

    public String getURI() {
        return ((ImageHandle)this.handle).getURI();
    }

    public String getTypeExpression() {
        return ((ImageHandle)this.handle).getTypeExpression();
    }

    public String getValueExpression() {
        return ((ImageHandle)this.handle).getValueExpression();
    }

    public String getImageName() {
        return ((ImageHandle)this.handle).getImageName();
    }

    public void setImageName(String name) throws SemanticException {
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            ((ImageHandle)this.handle).setImageName(name);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    public void setURI(String uri) throws SemanticException {
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            ((ImageHandle)this.handle).setURI(uri);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    public void setScale(double scale) throws SemanticException {
        this.setProperty("scale", scale);
    }

    public void setSize(String size) throws SemanticException {
        this.setProperty("size", size);
    }

    public void setTypeExpression(String value) throws SemanticException {
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            ((ImageHandle)this.handle).setTypeExpression(value);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    public void setValueExpression(String value) throws SemanticException {
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            ((ImageHandle)this.handle).setValueExpression(value);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    public String getHelpText() {
        return ((ImageHandle)this.handle).getHelpText();
    }

    public void setHelpText(String helpText) throws SemanticException {
        this.setProperty("helpText", helpText);
    }

    public String getHelpTextKey() {
        return ((ImageHandle)this.handle).getHelpTextKey();
    }

    public void setHelpTextKey(String helpTextKey) throws SemanticException {
        this.setProperty("helpTextID", helpTextKey);
    }

    public IAction getAction() {
        return new ActionImpl(((ImageHandle)this.handle).getActionHandle(), (ImageHandle)this.handle);
    }

    public void setFile(String file) throws SemanticException {
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            ((ImageHandle)this.handle).setFile(file);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    public String getFile() {
        return ((ImageHandle)this.handle).getFile();
    }

    public void setURL(String url) throws SemanticException {
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            ((ImageHandle)this.handle).setURL(url);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    public String getURL() {
        return ((ImageHandle)this.handle).getURL();
    }

    public void addAction(IAction action) throws SemanticException {
        if (action == null) {
            return;
        }
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            this.handle.setProperty("action", action.getStructure());
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }
}

