/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.DummyEngineTask;
import org.eclipse.birt.report.designer.data.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportEngineFactory;
import org.eclipse.birt.report.engine.api.impl.ReportEngineHelper;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.datatools.connectivity.oda.IBlob;

public class SelectValueFetcher {
    private SelectValueFetcher() {
    }

    public static List getSelectValueList(String expression, DataSetHandle dataSetHandle, boolean useDataSetFilter) throws BirtException {
        Expression jsExpression = new Expression((Object)expression, "javascript");
        return SelectValueFetcher.getSelectValueList(jsExpression, dataSetHandle, useDataSetFilter);
    }

    public static List getSelectValueFromBinding(String expression, DataSetHandle dataSetHandle, Iterator binding, boolean useDataSetFilter) throws BirtException {
        Expression jsExpression = new Expression((Object)expression, "javascript");
        return SelectValueFetcher.getSelectValueFromBinding(jsExpression, dataSetHandle, binding, useDataSetFilter);
    }

    public static List getSelectValueList(Expression expression, DataSetHandle dataSetHandle, boolean useDataSetFilter) throws BirtException {
        DataRequestSession session = null;
        ScriptExpression expr = null;
        ReportEngine engine = null;
        DummyEngineTask engineTask = null;
        try {
            if (dataSetHandle.getModuleHandle() instanceof ReportDesignHandle) {
                ReportDesignHandle copy = (ReportDesignHandle)dataSetHandle.getModuleHandle().copy().getHandle(null);
                EngineConfig config = new EngineConfig();
                config.setProperty("PARENT_CLASSLOADER", (Object)DataSetProvider.getCustomScriptClassLoader(Thread.currentThread().getContextClassLoader(), (ModuleHandle)copy));
                engine = (ReportEngine)new ReportEngineFactory().createReportEngine(config);
                engineTask = new DummyEngineTask(engine, new ReportEngineHelper(engine).openReportDesign(copy), (ModuleHandle)copy);
                session = engineTask.getDataSession();
                engineTask.run();
                expr = session.getModelAdaptor().adaptExpression(expression);
            } else {
                session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3, dataSetHandle == null ? null : dataSetHandle.getModuleHandle()));
                expr = session.getModelAdaptor().adaptExpression(expression);
            }
            boolean startsWithRow = ExpressionUtility.isColumnExpression(expr.getText(), true);
            boolean startsWithDataSetRow = ExpressionUtility.isColumnExpression(expr.getText(), false);
            if (!startsWithRow && !startsWithDataSetRow) {
                throw new DataException(Messages.getString((String)"SelectValueDialog.messages.info.invalidSelectVauleExpression"));
            }
            String dataSetColumnName = null;
            dataSetColumnName = startsWithDataSetRow ? ExpressionUtil.getColumnName((String)expr.getText()) : ExpressionUtil.getColumnBindingName((String)expr.getText());
            ArrayList<ComputedColumn> bindingList = new ArrayList<ComputedColumn>();
            ComputedColumn handle = new ComputedColumn();
            String columnName = "TEMP_" + expression.getStringExpression();
            handle.setExpression(ExpressionUtil.createJSDataSetRowExpression((String)dataSetColumnName));
            handle.setName(columnName);
            bindingList.add(handle);
            Collection result = session.getColumnValueSet(dataSetHandle, dataSetHandle.getPropertyHandle("parameters").iterator(), bindingList.iterator(), null, columnName, useDataSetFilter, null);
            assert (result != null);
            if (result.isEmpty()) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            Object resultProtoType = result.iterator().next();
            if (resultProtoType instanceof IBlob || resultProtoType instanceof byte[]) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            ArrayList arrayList = new ArrayList(result);
            return arrayList;
        }
        finally {
            if (dataSetHandle.getModuleHandle() instanceof ReportDesignHandle) {
                if (engineTask != null) {
                    engineTask.close();
                }
                if (engine != null) {
                    engine.destroy();
                }
            } else if (session != null) {
                session.shutdown();
            }
        }
    }

    public static List getSelectValueFromBinding(Expression expression, DataSetHandle dataSetHandle, Iterator binding, boolean useDataSetFilter) throws BirtException {
        return SelectValueFetcher.getSelectValueFromBinding(expression, dataSetHandle, binding, null, useDataSetFilter);
    }

    public static List getSelectValueFromBinding(Expression expression, DataSetHandle dataSetHandle, Iterator binding, Iterator groupIterator, boolean useDataSetFilter) throws BirtException {
        String columnName = null;
        ArrayList bindingList = new ArrayList();
        if (binding != null && binding.hasNext()) {
            while (binding.hasNext()) {
                bindingList.add(binding.next());
            }
        }
        ComputedColumn handle = new ComputedColumn();
        columnName = "TEMP_" + expression.getStringExpression();
        handle.setExpressionProperty("expression", expression);
        handle.setName(columnName);
        bindingList.add(handle);
        Collection result = null;
        DataRequestSession session = null;
        if (dataSetHandle.getModuleHandle() instanceof ReportDesignHandle) {
            EngineConfig config = new EngineConfig();
            ReportDesignHandle copy = (ReportDesignHandle)dataSetHandle.getModuleHandle().copy().getHandle(null);
            config.setProperty("PARENT_CLASSLOADER", (Object)DataSetProvider.getCustomScriptClassLoader(Thread.currentThread().getContextClassLoader(), (ModuleHandle)copy));
            ReportEngine engine = (ReportEngine)new ReportEngineFactory().createReportEngine(config);
            DummyEngineTask engineTask = new DummyEngineTask(engine, new ReportEngineHelper(engine).openReportDesign(copy), (ModuleHandle)copy);
            session = engineTask.getDataSession();
            engineTask.run();
            result = session.getColumnValueSet(dataSetHandle, dataSetHandle.getPropertyHandle("parameters").iterator(), bindingList.iterator(), groupIterator, columnName, useDataSetFilter, null);
            engineTask.close();
            engine.destroy();
        } else {
            session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3, dataSetHandle == null ? null : dataSetHandle.getModuleHandle()));
            result = session.getColumnValueSet(dataSetHandle, dataSetHandle.getPropertyHandle("parameters").iterator(), bindingList.iterator(), null, columnName, useDataSetFilter, null);
            session.shutdown();
        }
        assert (result != null);
        if (result.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Object resultProtoType = result.iterator().next();
        if (resultProtoType instanceof IBlob || resultProtoType instanceof byte[]) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(result);
    }

    public static List getSelectValueList(String expression, DataSetHandle dataSetHandle) throws BirtException {
        return SelectValueFetcher.getSelectValueList(expression, dataSetHandle, true);
    }

    public static List getSelectValueList(Expression expression, DataSetHandle dataSetHandle) throws BirtException {
        return SelectValueFetcher.getSelectValueList(expression, dataSetHandle, true);
    }
}

