/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.core.model.schematic.CellHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.RowHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.ISelectionFilter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.BaseBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.CellBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AreaEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportComponentEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportContainerEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportFlowLayoutEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.CellFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.TableCellDragHandle;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportFlowLayout;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.bidi.BidiUIUtils;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;

public class TableCellEditPart
extends AbstractCellEditPart {
    private List handles = null;

    public TableCellEditPart(Object obj) {
        super(obj);
    }

    protected List getModelChildren() {
        return this.getCellAdapter().getChildren();
    }

    protected IFigure createFigure() {
        CellFigure figure = new CellFigure();
        ReportFlowLayout rflayout = new ReportFlowLayout();
        figure.setLayoutManager((LayoutManager)rflayout);
        figure.setOpaque(false);
        return figure;
    }

    protected Dimension getCellDimension() {
        int h = 0;
        int w = 0;
        TableEditPart tablePart = (TableEditPart)this.getParent();
        int rNumber = this.getRowNumber();
        int cNumber = this.getColumnNumber();
        if (rNumber > 0 && cNumber > 0) {
            int i = rNumber;
            while (i < rNumber + this.getRowSpan()) {
                h += tablePart.caleVisualHeight(i);
                ++i;
            }
            int j = cNumber;
            while (j < cNumber + this.getColSpan()) {
                w += tablePart.caleVisualWidth(j);
                ++j;
            }
        }
        return new Dimension(w, h);
    }

    public void refreshFigure() {
        CellBorder cborder = new CellBorder();
        if (this.getFigure().getBorder() instanceof CellBorder) {
            cborder.setBorderInsets(((CellBorder)this.getFigure().getBorder()).getBorderInsets());
        }
        this.refreshBorder(this.getCellAdapter().getHandle(), cborder);
        Insets ist = this.getCellAdapter().getPadding(this.getFigure().getInsets());
        ((CellBorder)this.getFigure().getBorder()).setPaddingInsets(ist);
        StyleHandle style = ((CellHandle)this.getModel()).getPrivateStyle();
        String hAlign = style.getTextAlign();
        String vAlign = style.getVerticalAlign();
        ReportFlowLayout rflayout = (ReportFlowLayout)this.getFigure().getLayoutManager();
        if ("center".equals(hAlign)) {
            rflayout.setMajorAlignment(0);
        } else if ("right".equals(hAlign) && !this.getFigure().isMirrored()) {
            rflayout.setMajorAlignment(2);
        } else if ("left".equals(hAlign) && this.getFigure().isMirrored()) {
            rflayout.setMajorAlignment(2);
        } else {
            rflayout.setMajorAlignment(1);
        }
        if ("middle".equals(vAlign)) {
            rflayout.setMinorAlignment(0);
        } else if ("bottom".equals(vAlign)) {
            rflayout.setMinorAlignment(2);
        } else {
            rflayout.setMinorAlignment(1);
        }
        ((CellFigure)this.getFigure()).setDirectionRTL(BidiUIUtils.INSTANCE.isDirectionRTL(this.getModel()));
        rflayout.layout(this.getFigure());
        this.updateBlankString();
        this.refreshBackground((DesignElementHandle)this.getModel());
    }

    public void updateBlankString() {
        if (this.getModelChildren().size() == 0 && 1 == this.getColumnNumber()) {
            TableHandleAdapter tha = ((TableEditPart)this.getParent()).getTableAdapter();
            RowHandleAdapter rha = HandleAdapterFactory.getInstance().getRowHandleAdapter(tha.getRow(this.getRowNumber()));
            String type = rha.getType();
            DesignElementHandle obj = rha.getHandle().getContainer();
            if (("gh".equals(type) || "gf".equals(type)) && rha.getHandle().getContainer() instanceof TableGroupHandle) {
                String name = null;
                try {
                    name = ExpressionUtil.getColumnBindingName((String)((TableGroupHandle)obj).getKeyExpr());
                }
                catch (BirtException birtException) {}
                if (name != null) {
                    ((CellFigure)this.getFigure()).setBlankString(String.valueOf(rha.getTypeString()) + " (" + name + ")");
                    return;
                }
            }
            ((CellFigure)this.getFigure()).setBlankString(rha.getTypeString());
        } else {
            ((CellFigure)this.getFigure()).setBlankString(null);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ReportComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ReportFlowLayoutEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new ReportContainerEditPolicy());
    }

    public int getRowNumber() {
        return this.getCellAdapter().getRowNumber();
    }

    public int getColumnNumber() {
        return this.getCellAdapter().getColumnNumber();
    }

    public int getColSpan() {
        return this.getCellAdapter().getColumnSpan();
    }

    public void setColumnSpan(int colSpan) {
        try {
            this.getCellAdapter().setColumnSpan(colSpan);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public int getRowSpan() {
        return this.getCellAdapter().getRowSpan();
    }

    public void setRowSpan(int rowSpan) {
        try {
            this.getCellAdapter().setRowSpan(rowSpan);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public EditPart getTargetEditPart(Request request) {
        return super.getTargetEditPart(request);
    }

    protected CellHandleAdapter getCellAdapter() {
        return (CellHandleAdapter)this.getModelAdapter();
    }

    public void showTargetFeedback(Request request) {
        if (this.getSelected() == 0 && this.isActive() && request.getType() == "selection") {
            if (this.isFigureLeft(request)) {
                this.getViewer().setCursor(ReportPlugin.getDefault().getLeftCellCursor());
            } else {
                this.getViewer().setCursor(ReportPlugin.getDefault().getRightCellCursor());
            }
        }
        super.showTargetFeedback(request);
    }

    public void eraseTargetFeedback(Request request) {
        if (this.isActive()) {
            this.getViewer().setCursor(null);
        }
        super.eraseTargetFeedback(request);
    }

    protected void addChildVisual(EditPart part, int index) {
        this.getViewer().setCursor(null);
        super.addChildVisual(part, index);
    }

    protected void updateBaseBorder(DesignElementHandle handle, BaseBorder border) {
        super.updateBaseBorder(handle, border);
        DesignElementHandle parent = ((DesignElementHandle)this.getModel()).getContainer();
        if ("none".equals(border.bottomStyle)) {
            this.updateBottomBorder(parent, border);
            if (border instanceof CellBorder) {
                ((CellBorder)border).setBottomFrom(0);
            }
        } else if (border instanceof CellBorder) {
            ((CellBorder)border).setBottomFrom(1);
        }
        if ("none".equals(border.topStyle)) {
            this.updateTopBorder(parent, border);
            if (border instanceof CellBorder) {
                ((CellBorder)border).setTopFrom(0);
            }
        } else if (border instanceof CellBorder) {
            ((CellBorder)border).setTopFrom(1);
        }
        if ("none".equals(border.leftStyle) && this.getColumnNumber() == 1) {
            this.updateLeftBorder(parent, border);
        }
        if ("none".equals(border.rightStyle) && this.getColumnNumber() + this.getColSpan() == ((TableEditPart)this.getParent()).getColumnCount() + 1) {
            this.updateRightBorder(parent, border);
        }
    }

    public Object getAdapter(Class key) {
        if (key == ISelectionFilter.class) {
            return new ISelectionFilter(){

                public List filterEditpart(List editparts) {
                    int size = editparts.size();
                    ArrayList copy = new ArrayList(editparts);
                    int i = 0;
                    while (i < size) {
                        EditPart part = (EditPart)editparts.get(i);
                        if (part instanceof AreaEditPart) {
                            copy.remove(part);
                        }
                        ++i;
                    }
                    boolean hasCell = false;
                    boolean hasOther = false;
                    int i2 = 0;
                    while (i2 < size) {
                        Object obj = ((EditPart)editparts.get(i2)).getModel();
                        if (obj instanceof CellHandle || obj instanceof RowHandle || obj instanceof ColumnHandle) {
                            hasCell = true;
                        } else {
                            hasOther = true;
                        }
                        ++i2;
                    }
                    if (hasCell && hasOther) {
                        i2 = 0;
                        while (i2 < size) {
                            EditPart part = (EditPart)editparts.get(i2);
                            Object obj = part.getModel();
                            if (obj instanceof CellHandle || obj instanceof RowHandle || obj instanceof ColumnHandle) {
                                copy.remove(part);
                            }
                            ++i2;
                        }
                    }
                    editparts = copy;
                    return editparts;
                }
            };
        }
        return super.getAdapter(key);
    }

    protected List getHandleList() {
        TableCellDragHandle row;
        TableCellDragHandle column;
        ArrayList<TableCellDragHandle> retValue = new ArrayList<TableCellDragHandle>();
        TableEditPart parent = (TableEditPart)this.getParent();
        int columnNumner = parent.getColumnCount();
        int rowNumer = parent.getRowCount();
        if (this.getColumnNumber() + this.getColSpan() - 1 < columnNumner) {
            column = new TableCellDragHandle(this, 16, this.getColumnNumber() + this.getColSpan() - 1, this.getColumnNumber() + this.getColSpan());
            retValue.add(column);
        } else {
            column = new TableCellDragHandle(this, 16, this.getColumnNumber() + this.getColSpan() - 1, this.getColumnNumber() + this.getColSpan() - 1);
            retValue.add(column);
        }
        if (this.getRowNumber() + this.getRowSpan() - 1 < rowNumer) {
            row = new TableCellDragHandle(this, 4, this.getRowNumber() + this.getRowSpan() - 1, this.getRowNumber() + this.getRowSpan());
            retValue.add(row);
        } else {
            row = new TableCellDragHandle(this, 4, this.getRowNumber() + this.getRowSpan() - 1, this.getRowNumber() + this.getRowSpan() - 1);
            retValue.add(row);
        }
        return retValue;
    }

    public void activate() {
        if (this.handles == null) {
            this.handles = this.getHandleList();
        }
        IFigure layer = this.getLayer("Handle Layer");
        int size = this.handles.size();
        int i = 0;
        while (i < size) {
            Figure handle = (Figure)this.handles.get(i);
            layer.add((IFigure)handle);
            ++i;
        }
        super.activate();
    }

    public void deactivate() {
        IFigure layer = this.getLayer("Handle Layer");
        int size = this.handles.size();
        int i = 0;
        while (i < size) {
            Figure handle = (Figure)this.handles.get(i);
            layer.remove((IFigure)handle);
            ++i;
        }
        super.deactivate();
    }

    protected void updateExistPart() {
        Figure handle;
        IFigure layer = this.getLayer("Handle Layer");
        int size = this.handles.size();
        int i = 0;
        while (i < size) {
            handle = (Figure)this.handles.get(i);
            layer.remove((IFigure)handle);
            ++i;
        }
        this.handles = this.getHandleList();
        size = this.handles.size();
        i = 0;
        while (i < size) {
            handle = (Figure)this.handles.get(i);
            layer.add((IFigure)handle);
            ++i;
        }
    }
}

