/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.UseCssInReportDialog;
import org.eclipse.birt.report.designer.ui.dialogs.UseCssInThemeDialog;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;

public class UseCssStyleAction
extends AbstractViewAction {
    public static final String ID = "org.eclipse.birt.report.designer.internal.ui.views.UseCssStyleAction";
    public static final String ACTION_TEXT = Messages.getString((String)"UseCssStyleAction.text");

    public UseCssStyleAction(Object selectedObject) {
        this(selectedObject, ACTION_TEXT);
    }

    public UseCssStyleAction(Object selectedObject, String text) {
        super(selectedObject, text);
    }

    public boolean isEnabled() {
        return true;
    }

    public void run() {
        Object selection = this.getSelection();
        if (selection == null) {
            return;
        }
        if (selection instanceof SlotHandle && ((SlotHandle)selection).getElementHandle() instanceof ReportDesignHandle) {
            this.useCssInReportDesign();
        } else if (selection instanceof ThemeHandle) {
            this.useCssInTheme((ThemeHandle)selection);
        }
    }

    private void useCssInReportDesign() {
        UseCssInReportDialog dialog = new UseCssInReportDialog();
        String relativeFileName = null;
        dialog.setFileName(relativeFileName);
        if (dialog.open() == 0) {
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans(ACTION_TEXT);
            try {
                ReportDesignHandle moduleHandle = (ReportDesignHandle)SessionHandleAdapter.getInstance().getReportDesignHandle();
                IncludedCssStyleSheet css = StructureFactory.createIncludedCssStyleSheet();
                css.setFileName(dialog.getFileName());
                css.setExternalCssURI(dialog.getURI());
                moduleHandle.addCss(css);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
                stack.rollback();
                return;
            }
            stack.commit();
        }
    }

    private void useCssInTheme(ThemeHandle oldTheme) {
        UseCssInThemeDialog dialog = new UseCssInThemeDialog();
        String relativeFileName = null;
        dialog.setFileName(relativeFileName);
        dialog.setTheme(oldTheme);
        if (dialog.open() == 0) {
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans(ACTION_TEXT);
            ThemeHandle themeHandle = dialog.getTheme();
            try {
                IncludedCssStyleSheet css = StructureFactory.createIncludedCssStyleSheet();
                css.setFileName(dialog.getFileName());
                css.setExternalCssURI(dialog.getURI());
                themeHandle.addCss(css);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
                stack.rollback();
                return;
            }
            stack.commit();
        }
    }
}

