/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.parameters;

import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.ui.parameters.IParameter;
import org.eclipse.birt.report.designer.ui.parameters.IParameterGroup;
import org.eclipse.birt.report.designer.ui.parameters.ParameterUtil;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;

public abstract class ScalarParameter
implements IParameter {
    protected IParameterGroup group = null;
    private Object selectionValue = null;
    protected ScalarParameterHandle handle;
    protected IEngineTask engineTask;

    public ScalarParameter(ScalarParameterHandle handle, IEngineTask engineTask) {
        this.handle = handle;
        this.engineTask = engineTask;
    }

    public abstract List getValueList();

    public Object getSelectionValue() {
        return this.selectionValue;
    }

    public void setSelectionValue(Object value) {
        this.selectionValue = value;
    }

    public void setParentGroup(IParameterGroup group) {
        this.group = group;
    }

    public IParameterGroup getParentGroup() {
        return this.group;
    }

    public String getDefaultValue() {
        return this.handle.getDefaultValue();
    }

    public List getDefaultValues() {
        return this.handle.getDefaultValueList();
    }

    public ScalarParameterHandle getHandle() {
        return this.handle;
    }

    public String format(String input) throws BirtException {
        return ParameterUtil.format((ParameterHandle)this.handle, input);
    }

    public Object converToDataType(Object value) throws BirtException {
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            Object[] rtValues = new Object[values.length];
            int i = 0;
            while (i < values.length) {
                rtValues[i] = ParameterUtil.convert(values[i], this.handle.getDataType());
                ++i;
            }
            return rtValues;
        }
        return ParameterUtil.convert(value, this.handle.getDataType());
    }

    public boolean isRequired() {
        return this.handle.isRequired();
    }
}

