/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.autoupdate.handler;

import fr.inra.adonis.autoupdate.AdonisAutoUpdate;
import fr.inra.adonis.autoupdate.p2.P2Util;
import fr.inra.adonis.autoupdate.p2.UpdateTerrain;
import fr.inra.adonis.bureau.menus.MenusUtils;
import fr.inra.adonis.core.ini.AdonisProperties;
import fr.inra.adonis.core.util.CoreUtilActivator;
import fr.inra.adonis.persistance.SiteDescription;
import fr.inra.adonis.persistance.teneo.DAOFactoryTeneo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.Version;

public class AdonisUpdateHandler
extends AbstractHandler {
    private static final String ReconcileKey = "org.eclipse.update.reconcile";
    private static final String ReconcileValue = "false";

    public Object execute(ExecutionEvent exEvent) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)exEvent);
        DAOFactoryTeneo daoFactory = (DAOFactoryTeneo)DAOFactoryTeneo.getInstance();
        try {
            P2Util p2util = new P2Util(AdonisProperties.getAdonisProperties().getAdonisUpdateSite());
            Version versionUpdate = p2util.checkForUpdates();
            if (versionUpdate != null && MenusUtils.askForSave()) {
                Version versionCourante = new Version(CoreUtilActivator.ADONIS_VERSION);
                boolean continueUpdate = true;
                if (versionCourante.getMajor() < versionUpdate.getMajor()) {
                    continueUpdate = true;
                    StringBuilder sb = new StringBuilder("Attention la nouvelle version d'adonis comporte une mise \u00e0 jour du mod\u00e8le\nDes projets de saisies sont en cours de transferts sur les sites suivants:\n");
                    List siteList = AdonisProperties.getAdonisProperties().getSitesList();
                    for (SiteDescription site : siteList) {
                        Collection siteTransfered = daoFactory.getProjetSaisieTransfere(daoFactory.getCurrentSite());
                        if (siteTransfered.size() <= 0) continue;
                        continueUpdate = false;
                        sb.append("-Site '" + site.getNomSite() + "' contient les projets transfer\u00e9s:\n");
                        for (String str : siteTransfered) {
                            sb.append(String.valueOf(str) + ", ");
                        }
                        sb.append("\n ");
                    }
                    if (!continueUpdate) {
                        MessageDialog.openWarning((Shell)shell, (String)"Mise \u00e0 jour impossible", (String)sb.toString());
                    }
                }
                if (continueUpdate && p2util.checkAndPerformUpdates(shell)) {
                    UpdateTerrain updateTerrain = new UpdateTerrain(shell);
                    updateTerrain.updateTerrain();
                    updateTerrain.updateAlgo();
                    this.updateConfigIni();
                    MessageDialog.openInformation((Shell)shell, (String)"Mise \u00e0 jour termin\u00e9e", (String)"La mise \u00e0 jour est termin\u00e9e. Adonis va red\u00e9marer");
                    PlatformUI.getWorkbench().restart();
                }
            } else {
                MessageDialog.openInformation((Shell)shell, (String)"Mise \u00e0 jour", (String)"Aucune mise \u00e0 jour disponible");
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)shell, (String)"Mise \u00e9chou\u00e9e", (String)("Erreur lors de la mise \u00e0 jour:" + e.getLocalizedMessage()));
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateConfigIni() {
        String str = ResourcesPlugin.getWorkspace().getRoot().getLocation().toPortableString();
        File workspaceLocation = new File(str);
        File configFile = new File(String.valueOf(workspaceLocation.getParentFile().getAbsolutePath()) + "/configuration/config.ini");
        AdonisAutoUpdate.getLogger().logInfo("Mise \u00e0 jour config.ini :" + configFile.getAbsolutePath());
        if (!configFile.exists()) return;
        BufferedReader bufRead = null;
        AdonisAutoUpdate.getLogger().logInfo("Lecture de config.ini :" + configFile.getAbsolutePath());
        bufRead = new BufferedReader(new FileReader(configFile));
        String line = null;
        while (true) {
            if ((line = bufRead.readLine()) != null && str.contains(ReconcileKey)) {
                return;
            }
            if (line != null) continue;
            break;
        }
        {
            AdonisAutoUpdate.getLogger().logInfo("Ajout de reconcile dans config.ini");
            PrintWriter pw = null;
            try {
                try {
                    pw = new PrintWriter(new FileWriter(configFile, true));
                    pw.println();
                    pw.print(ReconcileKey);
                    pw.print("=");
                    pw.print(ReconcileValue);
                    return;
                }
                catch (Exception e) {
                    AdonisAutoUpdate.getLogger().logError((Throwable)e);
                    if (pw == null) return;
                    pw.close();
                    return;
                }
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Exception e) {}
            AdonisAutoUpdate.getLogger().logError((Throwable)e);
            return;
        }
        finally {
            if (bufRead != null) {
                try {
                    bufRead.close();
                }
                catch (IOException e) {
                    AdonisAutoUpdate.getLogger().logError((Throwable)e);
                }
            }
        }
    }
}

