/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.autoupdate.p2;

import fr.inra.adonis.autoupdate.AdonisAutoUpdate;
import fr.inra.adonis.core.ini.AdonisProperties;
import fr.inra.adonis.core.util.HttpsServerConnectionUtils;
import fr.inra.adonis.core.util.SiteUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class UpdateTerrain {
    private static final String FichierUpdateTerrain = "updateTerrain.ini";
    private static final String FichierUpdateAlgo = "algo.ini";
    private static final String WAP = "wap";
    private static final String CFU1 = "cfu1";
    private String urlUpdateSite = AdonisProperties.getAdonisProperties().getAdonisUpdateSite();
    private HttpsServerConnectionUtils serverHttpsUtils;
    private final Shell shell;

    public UpdateTerrain(Shell shell) {
        this.shell = shell;
        if (this.urlUpdateSite.startsWith("file:")) {
            return;
        }
        if (!this.urlUpdateSite.endsWith("/")) {
            this.urlUpdateSite = String.valueOf(this.urlUpdateSite) + "/";
        }
        try {
            this.serverHttpsUtils = new HttpsServerConnectionUtils();
        }
        catch (Exception e) {
            this.serverHttpsUtils = null;
            AdonisAutoUpdate.getLogger().logError((Throwable)e);
        }
    }

    public void updateAlgo() {
        if (this.serverHttpsUtils == null) {
            return;
        }
        try {
            String urlStr = String.valueOf(this.urlUpdateSite) + FichierUpdateAlgo;
            String contentIni = this.serverHttpsUtils.getContent(urlStr, false);
            if (contentIni == null || contentIni.length() == 0) {
                return;
            }
            BufferedReader reader = new BufferedReader(new StringReader(contentIni));
            String line = null;
            do {
                if ((line = reader.readLine()) == null || line.isEmpty()) continue;
                this.downloadAlgo(line, null);
            } while (line != null);
            reader.readLine();
        }
        catch (Exception e) {
            AdonisAutoUpdate.getLogger().logError((Throwable)e);
        }
    }

    private boolean downloadAlgo(String algoPlugin, IProgressMonitor monitor) {
        String alogPath = String.valueOf(SiteUtil.getRepertoireAlgorithme()) + File.separator + "plugins";
        File destination = this.computeDestinationFilename(alogPath, algoPlugin);
        String urlStr = String.valueOf(this.urlUpdateSite) + algoPlugin;
        if (this.download(urlStr, destination, monitor)) {
            this.removeOldAlgo(destination.getName());
            return true;
        }
        return false;
    }

    private File computeDestinationFilename(String destinationPath, String filename) {
        File file = new File(filename);
        return new File(destinationPath, file.getName());
    }

    private void removeOldAlgo(String algoPlugin) {
        String algoName;
        int pos;
        File pluginAlgo = new File(SiteUtil.getRepertoireAlgorithme(), "plugins");
        if (pluginAlgo.isDirectory() && (pos = (algoName = algoPlugin).indexOf("_")) > 0) {
            File[] files;
            algoName = algoName.substring(0, pos).toLowerCase();
            File[] fileArray = files = pluginAlgo.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String name = file.getName().toLowerCase();
                if (name.startsWith(algoName) && !name.equalsIgnoreCase(algoPlugin)) {
                    try {
                        file.delete();
                    }
                    catch (SecurityException e) {
                        AdonisAutoUpdate.getLogger().logError((Throwable)e);
                    }
                }
                ++n2;
            }
        }
    }

    public void updateTerrain() {
        if (this.serverHttpsUtils == null) {
            return;
        }
        try {
            String urlStr = String.valueOf(this.urlUpdateSite) + FichierUpdateTerrain;
            String contentIni = this.serverHttpsUtils.getContent(urlStr, false);
            if (contentIni == null || contentIni.length() == 0) {
                return;
            }
            final Properties prop = new Properties();
            prop.load(new StringReader(contentIni));
            final String installationWapPath = SiteUtil.getInstallationWapPath();
            final String installationCfu1Path = SiteUtil.getInstallationCfu1Path();
            final String[] messageFin = new String[]{""};
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    String wapzipPath = prop.getProperty(UpdateTerrain.WAP);
                    monitor.subTask("T\u00e9l\u00e9chargement du Wap");
                    if (wapzipPath != null && UpdateTerrain.this.downloadIntallTerrain(wapzipPath, installationWapPath, monitor)) {
                        messageFin[0] = String.valueOf(messageFin[0]) + "Une nouvelle version du wap a \u00e9t\u00e9 t\u00e9l\u00e9charg\u00e9e:\n-";
                        messageFin[0] = String.valueOf(messageFin[0]) + installationWapPath + "\n";
                    }
                    monitor.subTask("T\u00e9l\u00e9chargement du CFU1");
                    String cfu1zipPath = prop.getProperty(UpdateTerrain.CFU1);
                    if (cfu1zipPath != null && UpdateTerrain.this.downloadIntallTerrain(cfu1zipPath, installationCfu1Path, monitor)) {
                        if (!messageFin[0].isEmpty()) {
                            messageFin[0] = String.valueOf(messageFin[0]) + "\n";
                        }
                        messageFin[0] = String.valueOf(messageFin[0]) + "Une nouvelle version du cfu1 a \u00e9t\u00e9 t\u00e9l\u00e9charg\u00e9e: \n-" + installationCfu1Path;
                    }
                }
            };
            try {
                new ProgressMonitorDialog(this.shell).run(true, true, runnable);
                if (!messageFin[0].isEmpty()) {
                    String entete = "Nouvelle version adonis terrain disponible.\nPensez \u00e0 mettre \u00e0 jour l'application sur chaque appareil portable.\nAdonis bureau ne donnera plus d'avertissement pour cette mise \u00e0 jour.\nL'installation de ces mises \u00e0 jour se fait manuellement comme lors de la premi\u00e8re installation. (se r\u00e9f\u00e9rer \u00e0 la documentation)";
                    MessageDialog.openInformation((Shell)this.shell, (String)"T\u00e9l\u00e9chargement terrain termin\u00e9", (String)(String.valueOf(entete) + "\nD\u00e9tails:\n" + messageFin[0]));
                }
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)this.shell, (String)"Erreur update", (String)("Erreur lors du t\u00e9l\u00e9chargement des applications terrains:\n" + e.getMessage()));
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                MessageDialog.openInformation((Shell)this.shell, (String)"Info update", (String)("T\u00e9l\u00e9chargement annul\u00e9" + e.getMessage()));
            }
        }
        catch (Exception e) {
            AdonisAutoUpdate.getLogger().logError((Throwable)e);
        }
    }

    private boolean downloadIntallTerrain(String zipFilename, String directory, IProgressMonitor monitor) {
        File destination = this.computeDestinationFilename(directory, zipFilename);
        String urlStr = String.valueOf(this.urlUpdateSite) + zipFilename;
        return this.download(urlStr, destination, monitor);
    }

    private boolean download(final String urlFilename, File destination, IProgressMonitor monitor) {
        if (destination.exists()) {
            return false;
        }
        try {
            this.serverHttpsUtils.downloadFile(urlFilename, destination.getAbsolutePath(), monitor);
            return true;
        }
        catch (Exception e) {
            this.shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)UpdateTerrain.this.shell, (String)"Erreur", (String)("Erreur lors du t\u00e9l\u00e9chargement de :" + urlFilename + "\n" + e.getMessage()));
                }
            });
            AdonisAutoUpdate.getLogger().logError((Throwable)e);
            return false;
        }
    }
}

