/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.adapter;

import java.util.ArrayList;
import java.util.List;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.report.engine.api.EngineException;

public class CubeUtil {
    private static final String POSITION_DELIMITER = "::";

    public static String getPositionID(CubeCursor cursor) throws OLAPException {
        StringBuffer result = new StringBuffer();
        List ordinateEdge = CubeUtil.getAllEdges(cursor);
        int i = 0;
        while (i < ordinateEdge.size()) {
            EdgeCursor edge = (EdgeCursor)ordinateEdge.get(i);
            result.append(POSITION_DELIMITER);
            result.append(edge.getPosition());
            ++i;
        }
        return result.toString();
    }

    private static List getAllEdges(CubeCursor cursor) throws OLAPException {
        ArrayList ordinateEdge = new ArrayList();
        ordinateEdge.addAll(cursor.getOrdinateEdge());
        ordinateEdge.addAll(cursor.getPageEdge());
        return ordinateEdge;
    }

    public static void positionCursor(CubeCursor cursor, String position) throws OLAPException, EngineException {
        if (position == null || position.trim().length() == 0) {
            return;
        }
        if (position.startsWith(POSITION_DELIMITER)) {
            position = position.substring(2);
        }
        String[] positions = position.split("\\Q::\\E");
        List edges = CubeUtil.getAllEdges(cursor);
        int i = 0;
        while (i < edges.size()) {
            ((EdgeCursor)edges.get(i)).setPosition(new Long(positions[i]).longValue());
            ++i;
        }
    }
}

