/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v1;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.executor.PageVariable;
import org.eclipse.birt.report.engine.internal.document.IPageHintReader;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.PageHint;
import org.eclipse.birt.report.engine.presentation.PageSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageHintReaderV1
implements IPageHintReader {
    protected IReportDocument document;
    ArrayList pageHints = new ArrayList();

    public PageHintReaderV1(IReportDocument document) throws IOException {
        this.document = document;
        IDocArchiveReader reader = document.getArchive();
        RAInputStream in = reader.getStream("/pages");
        try {
            DataInputStream di = new DataInputStream(new BufferedInputStream((InputStream)in));
            long pageCount = IOUtil.readLong((DataInputStream)di);
            long i = 0L;
            while (i < pageCount) {
                PageHint hint = this.readPageHint(di);
                this.pageHints.add(hint);
                ++i;
            }
        }
        catch (IOException ex) {
            in.close();
            throw ex;
        }
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public void close() {
    }

    @Override
    public long getTotalPage() throws IOException {
        return this.pageHints.size();
    }

    @Override
    public IPageHint getPageHint(long pageNumber) throws IOException {
        return (IPageHint)this.pageHints.get((int)pageNumber);
    }

    public long findPage(long offset) throws IOException {
        int i = 0;
        while (i < this.pageHints.size()) {
            IPageHint hint = (IPageHint)this.pageHints.get(i);
            PageSection section = hint.getSection(0);
            if (section.startOffset > offset) {
                return i + 1;
            }
            ++i;
        }
        return this.pageHints.size();
    }

    private PageHint readPageHint(DataInputStream in) throws IOException {
        long pageNumber = IOUtil.readLong((DataInputStream)in);
        long pageOffset = IOUtil.readLong((DataInputStream)in);
        PageHint hint = new PageHint(pageNumber, pageOffset);
        PageSection section = new PageSection();
        section.startOffset = IOUtil.readLong((DataInputStream)in);
        section.endOffset = IOUtil.readLong((DataInputStream)in);
        hint.addSection(section);
        return hint;
    }

    @Override
    public long getPageOffset(long pageNumber, String masterPage) throws IOException {
        return this.getPageHint(pageNumber).getOffset();
    }

    @Override
    public Collection<PageVariable> getPageVariables() throws IOException {
        return new ArrayList<PageVariable>();
    }
}

