/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.emitter;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.layout.emitter.BorderInfo;
import org.eclipse.birt.report.engine.layout.emitter.IPage;
import org.eclipse.birt.report.engine.layout.emitter.IPageDevice;
import org.eclipse.birt.report.engine.layout.emitter.TableBorder;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.IAreaVisitor;
import org.eclipse.birt.report.engine.nLayout.area.IContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.IImageArea;
import org.eclipse.birt.report.engine.nLayout.area.ITemplateArea;
import org.eclipse.birt.report.engine.nLayout.area.ITextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.CellArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.PageArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.RowArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TableArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextArea;
import org.eclipse.birt.report.engine.nLayout.area.style.BackgroundImageInfo;
import org.eclipse.birt.report.engine.nLayout.area.style.BoxStyle;
import org.eclipse.birt.report.engine.nLayout.area.style.DiagonalInfo;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.css.CSSValue;

public abstract class PageDeviceRender
implements IAreaVisitor {
    public static final String IMAGE_FOLDER = "image";
    public static final int H_TEXT_SPACE = 30;
    public static final int V_TEXT_SPACE = 100;
    public static final int ignoredOverflow = 3000;
    protected float scale;
    protected IReportRunnable reportRunnable;
    protected ReportDesignHandle reportDesign;
    protected IReportContext context;
    protected IEmitterServices services;
    protected int currentX;
    protected int currentY;
    protected Stack rowStyleStack = new Stack();
    protected int offsetX = 0;
    protected int offsetY = 0;
    protected Logger logger = Logger.getLogger(PageDeviceRender.class.getName());
    protected IPageDevice pageDevice;
    protected IPage pageGraphic;
    private static final int BODY_HEIGHT = 1;
    private static final int BODY_WIDTH = 2;
    private int extendDirection = 0;
    public static final int EXTEND_NONE = 0;
    public static final int EXTEND_ON_HORIZONTAL = 1;
    public static final int EXTEND_ON_VERTICAL = 2;
    public static final int EXTEND_ON_HORIZONTAL_AND_VERTICAL = 3;

    public abstract String getOutputFormat();

    public abstract IPageDevice createPageDevice(String var1, String var2, String var3, String var4, IReportContext var5, IReportContent var6) throws Exception;

    public void start(IReportContent rc) {
        ReportDesignHandle designHandle = rc.getDesign().getReportDesign();
        String title = rc.getTitle();
        String author = designHandle.getAuthor();
        String comments = designHandle.getComments();
        String subject = designHandle.getSubject();
        try {
            this.pageDevice = this.createPageDevice(title, author, subject, comments, this.context, rc);
        }
        catch (Exception e) {
            this.log(e, Level.SEVERE);
        }
    }

    protected void log(Throwable t, Level level) {
        this.logger.log(level, t.getMessage(), t);
    }

    public void end(IReportContent rc) {
        try {
            this.pageDevice.close();
        }
        catch (Exception e) {
            this.log(e, Level.WARNING);
        }
    }

    public void setTotalPage(ITextArea totalPage) {
    }

    public void visitText(ITextArea textArea) {
        this.drawText(textArea);
    }

    public void visitImage(IImageArea imageArea) {
        this.drawImage(imageArea);
    }

    public void visitAutoText(ITemplateArea templateArea) {
    }

    public void visitContainer(IContainerArea container) {
        if (container instanceof PageArea) {
            this.visitPage((PageArea)container);
        } else {
            this.startContainer(container);
            this.visitChildren(container);
            this.endContainer(container);
        }
    }

    protected void visitChildren(IContainerArea container) {
        Iterator<IArea> iter = container.getChildren();
        while (iter.hasNext()) {
            IArea child = iter.next();
            child.accept(this);
        }
    }

    private int getActualPageBodyWidth(PageArea page) {
        return this.getActualPageBodySize(page, 2);
    }

    private int getActualPageBodyHeight(PageArea page) {
        return this.getActualPageBodySize(page, 1);
    }

    private int getActualPageBodySize(PageArea page, int direction) {
        int pref = 0;
        IContainerArea body = page.getBody();
        if (body == null) {
            return 0;
        }
        Iterator<IArea> iter = page.getBody().getChildren();
        while (iter.hasNext()) {
            AbstractArea area = (AbstractArea)iter.next();
            pref = direction == 1 ? Math.max(pref, area.getY() + area.getHeight()) : Math.max(pref, area.getX() + area.getWidth());
        }
        return pref;
    }

    protected void startContainer(IContainerArea container) {
        if (container.needClip()) {
            this.startClip(container);
        }
        if (container instanceof RowArea) {
            this.rowStyleStack.push(container.getBoxStyle());
        } else if (container instanceof CellArea) {
            this.drawCell((CellArea)container);
        } else {
            this.drawContainer(container);
        }
        this.currentX += this.getX(container);
        this.currentY += this.getY(container);
    }

    protected void drawCellDiagonal(CellArea cell) {
        DiagonalInfo diagonalInfo = cell.getDiagonalInfo();
        if (diagonalInfo != null) {
            int startX = this.currentX + this.getX(cell);
            int startY = this.currentY + this.getY(cell);
            int width = this.getWidth(cell);
            int height = this.getHeight(cell);
            int dw = diagonalInfo.getDiagonalWidth();
            int ds = diagonalInfo.getDiagonalStyle();
            if (ds == 23) {
                ds = 21;
            }
            switch (diagonalInfo.getDiagonalNumber()) {
                case 2: {
                    this.pageGraphic.drawLine(startX + width / 2, startY, startX + width, startY + height - dw / 2, this.getScaledValue(dw), diagonalInfo.getDiagonalColor(), ds);
                    this.pageGraphic.drawLine(startX, startY + height / 2, startX + width, startY + height - dw / 2, this.getScaledValue(dw), diagonalInfo.getDiagonalColor(), ds);
                    break;
                }
                case 1: {
                    this.pageGraphic.drawLine(startX, startY + dw / 2, startX + width, startY + height - dw / 2, this.getScaledValue(dw), diagonalInfo.getDiagonalColor(), ds);
                    break;
                }
                default: {
                    this.pageGraphic.drawLine(startX, startY + dw / 2, startX + width, startY + height - dw / 2, this.getScaledValue(dw), diagonalInfo.getDiagonalColor(), ds);
                    this.pageGraphic.drawLine(startX + width / 2, startY + dw / 2, startX + width, startY + height - dw / 2, this.getScaledValue(dw), diagonalInfo.getDiagonalColor(), ds);
                    this.pageGraphic.drawLine(startX, startY + height / 2, startX + width, startY + height - dw / 2, this.getScaledValue(dw), diagonalInfo.getDiagonalColor(), ds);
                }
            }
        }
    }

    protected void drawCell(CellArea container) {
        this.drawCellDiagonal(container);
        Color rowbc = null;
        BackgroundImageInfo rowbi = null;
        BoxStyle rowStyle = null;
        if (this.rowStyleStack.size() > 0 && (rowStyle = (BoxStyle)this.rowStyleStack.peek()) != null) {
            rowbc = rowStyle.getBackgroundColor();
            rowbi = rowStyle.getBackgroundImage();
        }
        BoxStyle style = container.getBoxStyle();
        Color bc = style.getBackgroundColor();
        BackgroundImageInfo bi = style.getBackgroundImage();
        if (rowbc != null || rowbi != null || bc != null || bi != null) {
            int startX = this.currentX + this.getX(container);
            int startY = this.currentY + this.getY(container);
            int width = this.getWidth(container);
            int height = this.getHeight(container);
            if (rowbc != null) {
                this.pageGraphic.drawBackgroundColor(rowbc, startX, startY, width, height);
            }
            if (rowbi != null) {
                this.drawBackgroundImage(rowbi, startX, startY, width, height);
            }
            if (bc != null) {
                this.pageGraphic.drawBackgroundColor(bc, startX, startY, width, height);
            }
            if (bi != null) {
                this.drawBackgroundImage(bi, startX, startY, width, height);
            }
        }
    }

    protected void visitPage(PageArea page) {
        this.scale = page.getScale();
        if (page.isExtendToMultiplePages()) {
            int pageBodyHeight = this.getActualPageBodyHeight(page);
            int pageBodyWidth = this.getActualPageBodyWidth(page);
            IContainerArea pageBody = page.getBody();
            int definedBodyHeight = 0;
            int definedBodyWidth = 0;
            if (pageBody != null) {
                definedBodyHeight = pageBody.getHeight();
                definedBodyWidth = pageBody.getWidth();
            }
            if (pageBodyHeight > definedBodyHeight) {
                this.addExtendDirection(2);
            }
            if (pageBodyWidth > definedBodyWidth) {
                this.addExtendDirection(1);
            }
            this.offsetX = 0;
            this.offsetY = 0;
            if (this.extendDirection == 0) {
                this.addPage(page);
            } else if (this.extendDirection == 1) {
                do {
                    this.addPage(page);
                    this.offsetX += definedBodyWidth;
                } while (this.offsetX < pageBodyWidth - 3000);
            } else if (this.extendDirection == 2) {
                do {
                    this.addPage(page);
                    this.offsetY += definedBodyHeight;
                } while (this.offsetY < pageBodyHeight - 3000);
            } else if (this.extendDirection == 3) {
                while (true) {
                    this.addPage(page);
                    this.offsetX += definedBodyWidth;
                    if (this.offsetX < pageBodyWidth - 3000) continue;
                    this.offsetX = 0;
                    this.offsetY += definedBodyHeight;
                    if (this.offsetY >= pageBodyHeight - 3000) break;
                }
            }
            this.setExtendDirection(0);
        } else {
            this.addPage(page);
        }
    }

    protected void addPage(PageArea page) {
        this.newPage(page);
        this.currentX = 0;
        this.currentY = 0;
        IContainerArea pageRoot = page.getRoot();
        if (pageRoot != null) {
            IContainerArea pageBody;
            IContainerArea pageFooter;
            this.startContainer(page.getRoot());
            IContainerArea pageHeader = page.getHeader();
            if (pageHeader != null) {
                this.visitContainer(pageHeader);
            }
            if ((pageFooter = page.getFooter()) != null) {
                this.visitContainer(pageFooter);
            }
            if ((pageBody = page.getBody()) != null) {
                this.startContainer(pageBody);
                this.enterBody();
                this.visitChildren(pageBody);
                this.exitBody();
                this.endContainer(pageBody);
            }
            this.endContainer(page.getRoot());
        }
        this.endContainer(page);
    }

    private void enterBody() {
        this.currentX -= this.offsetX;
        this.currentY -= this.offsetY;
    }

    private void exitBody() {
        this.currentX += this.offsetX;
        this.currentY += this.offsetY;
    }

    protected void endContainer(IContainerArea container) {
        this.currentX -= this.getX(container);
        this.currentY -= this.getY(container);
        if (container instanceof PageArea) {
            this.pageGraphic.dispose();
        } else {
            if (container instanceof RowArea) {
                this.rowStyleStack.pop();
            }
            if (container instanceof TableArea) {
                this.drawTableBorder((TableArea)container);
            } else if (!(container instanceof CellArea)) {
                BorderInfo[] borders = this.cacheBorderInfo(container);
                this.drawBorder(borders);
            }
            if (container.needClip()) {
                this.endClip();
            }
        }
    }

    protected void newPage(IContainerArea page) {
        int pageHeight = this.getHeight(page);
        int pageWidth = this.getWidth(page);
        BoxStyle style = page.getBoxStyle();
        Color backgroundColor = style.getBackgroundColor();
        this.pageGraphic = this.pageDevice.newPage(pageWidth, pageHeight, backgroundColor);
        BackgroundImageInfo bi = style.getBackgroundImage();
        if (bi != null) {
            this.drawBackgroundImage(bi, 0, 0, pageWidth, pageHeight);
        }
    }

    protected int getExtendDirection() {
        return this.extendDirection;
    }

    protected void setExtendDirection(int direction) {
        this.extendDirection = direction;
    }

    protected void addExtendDirection(int direction) {
        this.extendDirection |= direction;
    }

    private void startClip(IArea area) {
        int startX = this.currentX + this.getX(area);
        int startY = this.currentY + this.getY(area);
        int width = this.getWidth(area);
        int height = this.getHeight(area);
        this.pageGraphic.startClip(startX, startY, width, height);
    }

    private void endClip() {
        this.pageGraphic.endClip();
    }

    private void drawBackgroundImage(BackgroundImageInfo bi, int startX, int startY, int width, int height) {
        try {
            this.pageGraphic.drawBackgroundImage(startX, startY, width, height, bi.getWidth(), bi.getHeight(), bi.getRepeatedMode(), bi.getUrl(), this.getScaledValue(bi.getXOffset()), this.getScaledValue(bi.getYOffset()));
        }
        catch (IOException e) {
            this.log(e, Level.WARNING);
        }
    }

    protected void drawContainer(IContainerArea container) {
        BoxStyle style = container.getBoxStyle();
        if (style == null || style == BoxStyle.DEFAULT) {
            return;
        }
        Color bc = style.getBackgroundColor();
        BackgroundImageInfo bi = style.getBackgroundImage();
        if (bc != null || bi != null) {
            int startX = this.currentX + this.getX(container);
            int startY = this.currentY + this.getY(container);
            int width = this.getWidth(container);
            int height = this.getHeight(container);
            if (bc != null) {
                this.pageGraphic.drawBackgroundColor(bc, startX, startY, width, height);
            }
            if (bi != null) {
                this.drawBackgroundImage(bi, startX, startY, width, height);
            }
        }
    }

    private BorderInfo[] cacheCellBorder(CellArea container) {
        BoxStyle style = container.getBoxStyle();
        if (style == null) {
            return null;
        }
        if (container.getContent() == null) {
            return null;
        }
        int borderTopWidth = this.getScaledValue(style.getTopBorderWidth());
        int borderLeftWidth = this.getScaledValue(style.getLeftBorderWidth());
        int borderBottomWidth = this.getScaledValue(style.getBottomBorderWidth());
        int borderRightWidth = this.getScaledValue(style.getRightBorderWidth());
        if (borderTopWidth > 0 || borderLeftWidth > 0 || borderBottomWidth > 0 || borderRightWidth > 0) {
            BorderInfo[] borders = new BorderInfo[]{new BorderInfo(0, 0, 0, 0, borderTopWidth, style.getTopBorderColor(), style.getTopBorderStyle(), 0), new BorderInfo(0, 0, 0, 0, borderRightWidth, style.getRightBorderColor(), style.getRightBorderStyle(), 1), new BorderInfo(0, 0, 0, 0, borderBottomWidth, style.getBottomBorderColor(), style.getBottomBorderStyle(), 2), new BorderInfo(0, 0, 0, 0, borderLeftWidth, style.getLeftBorderColor(), style.getLeftBorderStyle(), 3)};
            return borders;
        }
        return null;
    }

    private BorderInfo[] cacheBorderInfo(IContainerArea container) {
        BoxStyle style = container.getBoxStyle();
        if (style == null || BoxStyle.DEFAULT == style) {
            return null;
        }
        int borderTopWidth = this.getScaledValue(style.getTopBorderWidth());
        int borderLeftWidth = this.getScaledValue(style.getLeftBorderWidth());
        int borderBottomWidth = this.getScaledValue(style.getBottomBorderWidth());
        int borderRightWidth = this.getScaledValue(style.getRightBorderWidth());
        if (borderTopWidth > 0 || borderLeftWidth > 0 || borderBottomWidth > 0 || borderRightWidth > 0) {
            int startX = this.currentX + this.getX(container);
            int startY = this.currentY + this.getY(container);
            BorderInfo[] borders = new BorderInfo[]{new BorderInfo(startX, startY + borderTopWidth / 2, startX + this.getWidth(container), startY + borderTopWidth / 2, borderTopWidth, style.getTopBorderColor(), style.getTopBorderStyle(), 0), new BorderInfo(startX + this.getWidth(container) - borderRightWidth / 2, startY, startX + this.getWidth(container) - borderRightWidth / 2, startY + this.getHeight(container), borderRightWidth, style.getRightBorderColor(), style.getRightBorderStyle(), 1), new BorderInfo(startX, startY + this.getHeight(container) - borderBottomWidth / 2, startX + this.getWidth(container), startY + this.getHeight(container) - borderBottomWidth / 2, borderBottomWidth, style.getBottomBorderColor(), style.getBottomBorderStyle(), 2), new BorderInfo(startX + borderLeftWidth / 2, startY, startX + borderLeftWidth / 2, startY + this.getHeight(container), borderLeftWidth, style.getLeftBorderColor(), style.getLeftBorderStyle(), 3)};
            return borders;
        }
        return null;
    }

    protected void drawText(ITextArea text) {
        TextArea ta;
        TextStyle style = text.getTextStyle();
        assert (style != null);
        int textX = this.currentX + this.getX(text);
        int textY = this.currentY + this.getY(text);
        float fontSize = style.getFontInfo().getFontSize();
        int x = textX + this.getScaledValue((int)(fontSize * 30.0f));
        int y = textY + this.getScaledValue((int)(fontSize * 100.0f));
        if ((double)this.scale != 1.0) {
            FontInfo fontInfo = new FontInfo(style.getFontInfo());
            fontInfo.setFontSize(fontInfo.getFontSize() * this.scale);
            style = new TextStyle(style);
            style.setFontInfo(fontInfo);
            if (style.getLetterSpacing() != 0 || style.getWordSpacing() != 0) {
                style.setLetterSpacing(this.getScaledValue(style.getLetterSpacing()));
                style.setWordSpacing(this.getScaledValue(style.getWordSpacing()));
            }
        }
        if (text instanceof TextArea && ((ta = (TextArea)text).getRunLevel() & 1) != 0) {
            style = new TextStyle(style);
            style.setDirection(41);
        }
        this.drawTextAt(text, x, y, this.getWidth(text), this.getHeight(text), style);
    }

    protected void drawTextAt(ITextArea text, int x, int y, int width, int height, TextStyle textStyle) {
        this.pageGraphic.drawText(text.getText(), x, y, width, height, textStyle);
    }

    protected void drawImage(IImageArea image) {
        int imageX = this.currentX + this.getX(image);
        int imageY = this.currentY + this.getY(image);
        int height = this.getHeight(image);
        int width = this.getWidth(image);
        String helpText = image.getHelpText();
        try {
            byte[] data = image.getImageData();
            String extension = image.getExtension();
            String uri = image.getImageUrl();
            if (data != null) {
                this.pageGraphic.drawImage(uri, data, extension, imageX, imageY, height, width, helpText, image.getParameters());
            } else if (uri != null) {
                this.pageGraphic.drawImage(uri, extension, imageX, imageY, height, width, helpText, image.getParameters());
            }
        }
        catch (Throwable t) {
            this.log(t, Level.WARNING);
        }
    }

    private void drawBorder(TableBorder tb) {
        TableBorder.BorderSegment seg;
        TableBorder.BorderSegment seg2;
        if (tb == null) {
            return;
        }
        tb.findBreakPoints();
        TableBorder.Border border = null;
        for (Integer pos : tb.columnBorders.keySet()) {
            if (pos == tb.tableLRX) continue;
            border = (TableBorder.Border)tb.columnBorders.get(pos);
            int j = 0;
            while (j < border.segments.size()) {
                seg2 = (TableBorder.BorderSegment)border.segments.get(j);
                TableBorder.Border rs = (TableBorder.Border)tb.rowBorders.get(seg2.start);
                TableBorder.Border re = (TableBorder.Border)tb.rowBorders.get(seg2.end);
                if (rs != null && re != null) {
                    int sy = this.getScaledValue(rs.position + rs.width / 2);
                    int ey = this.getScaledValue(re.position + re.width / 2);
                    int x = this.getScaledValue(border.position + seg2.width / 2);
                    if (border.breakPoints.contains(new Integer(seg2.start))) {
                        sy = this.getScaledValue(rs.position);
                    }
                    if (border.breakPoints.contains(new Integer(seg2.end))) {
                        ey = seg2.end == tb.tableLRY ? this.getScaledValue(re.position) : this.getScaledValue(re.position + re.width);
                    }
                    this.drawBorder(new BorderInfo(this.currentX + x, this.currentY + sy, this.currentX + x, this.currentY + ey, this.getScaledValue(seg2.width), seg2.color, seg2.style, 3));
                }
                ++j;
            }
        }
        border = (TableBorder.Border)tb.columnBorders.get(tb.tableLRX);
        int j = 0;
        while (j < border.segments.size()) {
            seg = (TableBorder.BorderSegment)border.segments.get(j);
            TableBorder.Border rs = (TableBorder.Border)tb.rowBorders.get(seg.start);
            TableBorder.Border re = (TableBorder.Border)tb.rowBorders.get(seg.end);
            if (rs != null && re != null) {
                int sy = this.getScaledValue(rs.position + rs.width / 2);
                int ey = this.getScaledValue(re.position + re.width / 2);
                int x = this.getScaledValue(border.position - seg.width / 2);
                if (border.breakPoints.contains(new Integer(seg.start))) {
                    sy = this.getScaledValue(rs.position);
                }
                if (border.breakPoints.contains(new Integer(seg.end))) {
                    ey = seg.end == tb.tableLRY ? this.getScaledValue(re.position) : this.getScaledValue(re.position + re.width);
                }
                this.drawBorder(new BorderInfo(this.currentX + x, this.currentY + sy, this.currentX + x, this.currentY + ey, this.getScaledValue(seg.width), seg.color, seg.style, 1));
            }
            ++j;
        }
        for (Integer pos : tb.rowBorders.keySet()) {
            if (pos == tb.tableLRY) continue;
            border = (TableBorder.Border)tb.rowBorders.get(pos);
            int j2 = 0;
            while (j2 < border.segments.size()) {
                seg2 = (TableBorder.BorderSegment)border.segments.get(j2);
                TableBorder.Border cs = (TableBorder.Border)tb.columnBorders.get(seg2.start);
                TableBorder.Border ce = (TableBorder.Border)tb.columnBorders.get(seg2.end);
                if (cs != null && ce != null) {
                    int sx = this.getScaledValue(cs.position + cs.width / 2);
                    int ex = this.getScaledValue(ce.position + ce.width / 2);
                    int y = this.getScaledValue(border.position + seg2.width / 2);
                    if (border.breakPoints.contains(new Integer(seg2.start))) {
                        sx = seg2.start == tb.tableX && border.position != tb.tableY ? this.getScaledValue(cs.position + cs.width) : this.getScaledValue(cs.position);
                    }
                    if (border.breakPoints.contains(new Integer(seg2.end))) {
                        ex = seg2.end == tb.tableLRX ? (border.position == tb.tableY ? this.getScaledValue(ce.position) : this.getScaledValue(ce.position - ce.width)) : this.getScaledValue(ce.position + ce.width);
                    }
                    this.drawBorder(new BorderInfo(this.currentX + sx, this.currentY + y, this.currentX + ex, this.currentY + y, this.getScaledValue(seg2.width), seg2.color, seg2.style, 0));
                }
                ++j2;
            }
        }
        border = (TableBorder.Border)tb.rowBorders.get(tb.tableLRY);
        j = 0;
        while (j < border.segments.size()) {
            seg = (TableBorder.BorderSegment)border.segments.get(j);
            TableBorder.Border cs = (TableBorder.Border)tb.columnBorders.get(seg.start);
            TableBorder.Border ce = (TableBorder.Border)tb.columnBorders.get(seg.end);
            if (cs != null && ce != null) {
                int sx = this.getScaledValue(cs.position + cs.width / 2);
                int ex = this.getScaledValue(ce.position + ce.width / 2);
                int y = this.getScaledValue(border.position - seg.width / 2);
                if (border.breakPoints.contains(new Integer(seg.start))) {
                    sx = this.getScaledValue(cs.position);
                }
                if (border.breakPoints.contains(new Integer(seg.end))) {
                    ex = seg.end == tb.tableLRX ? this.getScaledValue(ce.position) : this.getScaledValue(ce.position + ce.width);
                }
                this.drawBorder(new BorderInfo(this.currentX + sx, this.currentY + y, this.currentX + ex, this.currentY + y, this.getScaledValue(seg.width), seg.color, seg.style, 2));
            }
            ++j;
        }
    }

    private void drawBorder(BorderInfo[] borders) {
        if (borders == null) {
            return;
        }
        ArrayList<BorderInfo> dbl = null;
        ArrayList<BorderInfo> solid = null;
        ArrayList<BorderInfo> dashed = null;
        ArrayList<BorderInfo> dotted = null;
        int i = 0;
        while (i < borders.length) {
            if ("double".equals(borders[i].borderStyle)) {
                if (dbl == null) {
                    dbl = new ArrayList<BorderInfo>();
                }
                dbl.add(borders[i]);
            } else if ("dashed".equals(borders[i].borderStyle)) {
                if (dashed == null) {
                    dashed = new ArrayList<BorderInfo>();
                }
                dashed.add(borders[i]);
            } else if ("dotted".equals(borders[i].borderStyle)) {
                if (dotted == null) {
                    dotted = new ArrayList<BorderInfo>();
                }
                dotted.add(borders[i]);
            } else {
                if (solid == null) {
                    solid = new ArrayList<BorderInfo>();
                }
                solid.add(borders[i]);
            }
            ++i;
        }
        if (dotted != null) {
            for (BorderInfo bi : dotted) {
                this.drawBorder(bi);
            }
        }
        if (dashed != null) {
            for (BorderInfo bi : dashed) {
                this.drawBorder(bi);
            }
        }
        if (solid != null) {
            for (BorderInfo bi : solid) {
                this.drawBorder(bi);
            }
        }
        if (dbl != null) {
            for (BorderInfo bi : dbl) {
                this.drawDoubleBorder(bi);
            }
        }
    }

    private void drawBorder(BorderInfo bi) {
        if (23 == bi.borderStyle) {
            this.drawDoubleBorder(bi);
        } else {
            this.pageGraphic.drawLine(bi.startX, bi.startY, bi.endX, bi.endY, bi.borderWidth, bi.borderColor, bi.borderStyle);
        }
    }

    private void drawDoubleBorder(BorderInfo bi) {
        int borderWidth = bi.borderWidth;
        int outerBorderWidth = borderWidth / 4;
        int innerBorderWidth = borderWidth / 4;
        int startX = bi.startX;
        int startY = bi.startY;
        int endX = bi.endX;
        int endY = bi.endY;
        Color borderColor = bi.borderColor;
        switch (bi.borderType) {
            case 0: {
                this.pageGraphic.drawLine(startX, startY - borderWidth / 2 + outerBorderWidth / 2, endX, endY - borderWidth / 2 + outerBorderWidth / 2, outerBorderWidth, borderColor, 21);
                this.pageGraphic.drawLine(startX, startY + borderWidth / 2 - innerBorderWidth / 2, endX, endY + borderWidth / 2 - innerBorderWidth / 2, innerBorderWidth, borderColor, 21);
                break;
            }
            case 1: {
                this.pageGraphic.drawLine(startX + borderWidth / 2 - outerBorderWidth / 2, startY, endX + borderWidth / 2 - outerBorderWidth / 2, endY, outerBorderWidth, borderColor, 21);
                this.pageGraphic.drawLine(startX - borderWidth / 2 + innerBorderWidth / 2, startY, endX - borderWidth / 2 + innerBorderWidth / 2, endY, innerBorderWidth, borderColor, 21);
                break;
            }
            case 2: {
                this.pageGraphic.drawLine(startX, startY + borderWidth / 2 - outerBorderWidth / 2, endX, endY + borderWidth / 2 - outerBorderWidth / 2, outerBorderWidth, borderColor, 21);
                this.pageGraphic.drawLine(startX, startY - borderWidth / 2 + innerBorderWidth / 2, endX, endY - borderWidth / 2 + innerBorderWidth / 2, innerBorderWidth, borderColor, 21);
                break;
            }
            case 3: {
                this.pageGraphic.drawLine(startX - borderWidth / 2 + outerBorderWidth / 2, startY, endX - borderWidth / 2 + outerBorderWidth / 2, endY, outerBorderWidth, borderColor, 21);
                this.pageGraphic.drawLine(startX + borderWidth / 2 - innerBorderWidth / 2, startY, endX + borderWidth / 2 - innerBorderWidth / 2, endY, innerBorderWidth, borderColor, 21);
            }
        }
    }

    protected int getX(IArea area) {
        return this.getScaledValue(area.getX());
    }

    protected int getY(IArea area) {
        return this.getScaledValue(area.getY());
    }

    protected int getWidth(IArea area) {
        return this.getScaledValue(area.getWidth());
    }

    protected int getHeight(IArea area) {
        return this.getScaledValue(area.getHeight());
    }

    protected int getScaledValue(int value) {
        return (int)((float)value * this.scale);
    }

    private int getScaledValue(CSSValue cssValue) {
        return this.getScaledValue(PropertyUtil.getDimensionValue(cssValue));
    }

    protected void drawTableBorder(TableArea table) {
        TableBorder tb = new TableBorder(table.getX(), table.getY());
        this.traverseRows(tb, table, tb.tableX, tb.tableY);
        this.drawBorder(tb);
    }

    private void traverseRows(TableBorder tb, IContainerArea container, int offsetX, int offsetY) {
        Iterator<IArea> i = container.getChildren();
        while (i.hasNext()) {
            IArea area = i.next();
            if (!(area instanceof IContainerArea)) continue;
            offsetX += area.getX();
            offsetY += area.getY();
            if (area instanceof RowArea) {
                this.handleBorderInRow(tb, (RowArea)area, offsetX, offsetY);
            } else {
                this.traverseRows(tb, (IContainerArea)area, offsetX, offsetY);
            }
            offsetX -= area.getX();
            offsetY -= area.getY();
        }
    }

    private void handleBorderInRow(TableBorder tb, RowArea row, int offsetX, int offsetY) {
        Iterator<IArea> ri = row.getChildren();
        while (ri.hasNext()) {
            IArea area = ri.next();
            if (!(area instanceof CellArea)) continue;
            CellArea cell = (CellArea)area;
            BorderInfo[] borders = this.cacheCellBorder(cell);
            int cellX = offsetX + cell.getX();
            int cellY = offsetY + cell.getY();
            int cellRx = cellX + cell.getWidth();
            int cellBy = cellY + cell.getHeight();
            tb.addColumn(cellX);
            tb.addColumn(cellRx);
            tb.addRow(cellBy);
            if (borders != null && borders[0].borderWidth != 0) {
                tb.setRowBorder(cellY, cellX, cellRx, borders[0].borderStyle, borders[0].borderWidth, borders[0].borderColor);
            }
            if (borders != null && borders[3].borderWidth != 0) {
                tb.setColumnBorder(cellX, cellY, cellBy, borders[3].borderStyle, borders[3].borderWidth, borders[3].borderColor);
            }
            if (borders != null && borders[2].borderWidth != 0) {
                tb.setRowBorder(cellBy, cellX, cellRx, borders[2].borderStyle, borders[2].borderWidth, borders[2].borderColor);
            }
            if (borders == null || borders[1].borderWidth == 0) continue;
            tb.setColumnBorder(cellRx, cellY, cellBy, borders[1].borderStyle, borders[1].borderWidth, borders[1].borderColor);
        }
    }
}

