/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import com.ibm.icu.util.ULocale;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.parser.MultiViewEngineIRVisitor;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;

public class ReportParser {
    protected static Logger logger = Logger.getLogger(ReportParser.class.getName());
    private Map options = new HashMap();

    public ReportParser() {
    }

    public ReportParser(IReportEngine engine) {
        this.loadOption(engine);
    }

    public ReportParser(ExecutionContext context) {
        ReportEngine engine;
        if (context != null && (engine = context.getEngine()) != null) {
            this.loadOption(engine);
        }
    }

    protected void loadOption(IReportEngine engine) {
        EngineConfig config;
        if (engine != null && (config = engine.getConfig()) != null) {
            String resourcePath;
            IResourceLocator locator = config.getResourceLocator();
            if (locator != null) {
                this.options.put("resourceLocator", locator);
            }
            if ((resourcePath = config.getResourcePath()) != null) {
                this.options.put("resourceFolder", resourcePath);
            }
        }
    }

    public ReportParser(Map options) {
        this.options.putAll(options);
    }

    public Report parse(String name, InputStream in) throws DesignFileException {
        ReportDesignHandle designHandle = this.getDesignHandle(name, in);
        return this.parse(designHandle);
    }

    public Report parse(String name) throws DesignFileException {
        ReportDesignHandle designHandle = this.getDesignHandle(name, null);
        return this.parse(designHandle);
    }

    public ReportDesignHandle getDesignHandle(String name, InputStream in) throws DesignFileException {
        SessionHandle sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.getDefault());
        IResourceLocator locator = (IResourceLocator)this.options.get("resourceLocator");
        if (locator != null) {
            sessionHandle.setResourceLocator(locator);
        }
        ReportDesignHandle designHandle = null;
        ModuleOption modOptions = new ModuleOption(this.options);
        designHandle = in != null ? sessionHandle.openDesign(name, in, modOptions) : sessionHandle.openDesign(name, modOptions);
        return designHandle;
    }

    public Report parse(ReportDesignHandle design) {
        assert (design != null);
        MultiViewEngineIRVisitor visitor = new MultiViewEngineIRVisitor(design);
        Report report = visitor.translate();
        report.setVersion("2.5.1");
        return report;
    }
}

